/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import com.oregondsp.signalProcessing.fft.RDFT;

public class OregonDspFFT {
    public static float[] forward(float[] realData) {
        RDFT rdft = new RDFT((int)Math.round(Math.log(realData.length) / Math.log(2.0)));
        float[] forward = new float[realData.length];
        rdft.evaluate(realData, forward);
        return forward;
    }

    public static float[] inverse(float[] realData) {
        RDFT rdft = new RDFT((int)Math.round(Math.log(realData.length) / Math.log(2.0)));
        float[] inverse = new float[realData.length];
        rdft.evaluateInverse(realData, inverse);
        return inverse;
    }

    public static float[] correlate(float[] x, float[] y) {
        float[] xforward = new float[x.length];
        xforward = OregonDspFFT.forward(x);
        float[] yforward = new float[y.length];
        yforward = OregonDspFFT.forward(y);
        float[] ans = new float[x.length];
        ans[0] = xforward[0] * yforward[0];
        ans[x.length / 2] = xforward[x.length / 2] * yforward[x.length / 2];
        for (int j = 1; j < x.length / 2; ++j) {
            float a = xforward[j];
            float b = xforward[x.length - j];
            float c = yforward[j];
            float d = yforward[x.length - j];
            ans[j] = a * c + b * d;
            ans[x.length - j] = -a * d + b * c;
        }
        ans = OregonDspFFT.inverse(ans);
        return ans;
    }

    public static float[] convolve(float[] x, float[] y, float delta) {
        float[] xforward = new float[x.length];
        xforward = OregonDspFFT.forward(x);
        float[] yforward = new float[y.length];
        yforward = OregonDspFFT.forward(y);
        float[] ans = new float[x.length];
        ans[0] = xforward[0] * yforward[0];
        ans[x.length / 2] = xforward[x.length / 2] * yforward[x.length / 2];
        for (int j = 1; j < x.length / 2; ++j) {
            float a = xforward[j];
            float b = xforward[x.length - j];
            float c = yforward[j];
            float d = yforward[x.length - j];
            ans[j] = a * c - b * d;
            ans[x.length - j] = a * d + b * c;
        }
        ans = OregonDspFFT.inverse(ans);
        int i = 0;
        while (i < ans.length) {
            int n = i++;
            ans[n] = ans[n] * delta;
        }
        return ans;
    }
}

