/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dissendium
extends LocalObject
implements ClientRequestInterceptor,
ORBInitializer {
    private byte[] uscPropBytes;
    private byte[] irisPropBytes;
    private Properties baseProperties = System.getProperties();
    public static final int uscID = 3948;
    public static final int irisID = 9463002;
    private static final String DARK_MAGIC_PASSWORD_FILE = "darkMagic.passwordFile";
    private static final String IRIS_PASSWORD_FILE = "irisDmc.passwordFile";
    public static final String DISSENDIUM_ORB_PROP_NAME = "org.omg.PortableInterceptor.ORBInitializerClass.edu.sc.seis.fissuresUtil.Dissendium";
    public static final String DISSENDIUM_ORB_PROP_VALUE = "edu.sc.seis.fissuresUtil.Dissendium";
    private static final Logger logger = LoggerFactory.getLogger(Dissendium.class);

    public Dissendium() throws IOException {
        Properties props = this.getPasswordProps("darkMagic");
        if (props.size() != 0) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            props.store(out, "darkMagic passwords");
            this.uscPropBytes = out.toByteArray();
            out.close();
        } else {
            this.uscPropBytes = new byte[0];
        }
        props = this.getPasswordProps("irisDmc");
        if (props.size() != 0) {
            StringBuffer propStrBuf = new StringBuffer();
            for (String string : props.keySet()) {
                if (string.equals(IRIS_PASSWORD_FILE)) {
                    String passFileName = props.getProperty(string);
                    if (passFileName != null) {
                        logger.info("reading from IRIS password file: " + string);
                        try {
                            String inStr;
                            BufferedReader br = new BufferedReader(new FileReader(passFileName));
                            while ((inStr = br.readLine()) != null) {
                                String[] parts = inStr.split(" ");
                                if (parts.length < 5) {
                                    logger.debug("password file error at line: " + inStr);
                                    logger.debug("Skipping ...");
                                    continue;
                                }
                                if (inStr.trim().length() <= 0) continue;
                                propStrBuf.append(inStr).append(";");
                            }
                            br.close();
                        }
                        catch (Exception e) {
                            logger.error("Exception thrown while reading IRIS password file", (Throwable)e);
                        }
                        continue;
                    }
                    logger.debug("IRIS password file property with empty entry...skipping");
                    continue;
                }
                StringBuffer sb = new StringBuffer(32);
                String[] keyBits = string.split("\\.");
                if (keyBits.length < 4) {
                    logger.info("improperly formatted key (rejecting): " + string);
                    continue;
                }
                for (int i = 1; i < keyBits.length; ++i) {
                    sb.append(keyBits[i]);
                    sb.append(" ");
                }
                String authVal = props.getProperty(string);
                if (authVal == null) {
                    logger.info("empty auth property (rejecting)");
                    continue;
                }
                String[] authBits = authVal.split("\\:");
                if (authBits.length < 2) {
                    logger.info("improperly formatted auth values (rejecting): " + authVal);
                    continue;
                }
                sb.append(authBits[0]);
                sb.append(" ");
                sb.append(authBits[1]);
                propStrBuf.append(sb.toString()).append(";");
            }
            this.irisPropBytes = propStrBuf.toString().getBytes();
        } else {
            this.irisPropBytes = new byte[0];
        }
    }

    public void post_init(ORBInitInfo info) {
    }

    public void pre_init(ORBInitInfo info) {
        try {
            if (this.uscPropBytes != null && this.uscPropBytes.length != 0 || this.irisPropBytes != null && this.irisPropBytes.length != 0) {
                info.add_client_request_interceptor((ClientRequestInterceptor)this);
                logger.info("Dissendium registered with orb");
            } else {
                logger.info("Dissendium NOT registered with orb as no passwords specified.");
            }
        }
        catch (Throwable t) {
            logger.error("Exception adding Dissendium to orb", t);
        }
    }

    public void send_request(ClientRequestInfo info) throws ForwardRequest {
        ServiceContext context = new ServiceContext(3948, this.uscPropBytes);
        info.add_request_service_context(context, true);
        context = new ServiceContext(9463002, this.irisPropBytes);
        info.add_request_service_context(context, true);
    }

    public void send_poll(ClientRequestInfo arg0) {
    }

    public void receive_reply(ClientRequestInfo arg0) {
    }

    public void receive_exception(ClientRequestInfo arg0) throws ForwardRequest {
    }

    public void receive_other(ClientRequestInfo arg0) throws ForwardRequest {
    }

    public String name() {
        return "Dissendium";
    }

    public void destroy() {
    }

    /*
     * WARNING - void declaration
     */
    public Properties getPasswordProps(String keyPrefix) throws FileNotFoundException, IOException {
        Properties returnProps;
        block5: {
            block4: {
                void var4_7;
                returnProps = new Properties();
                if (!keyPrefix.equals("darkMagic")) break block4;
                String darkFileName = this.baseProperties.getProperty(DARK_MAGIC_PASSWORD_FILE);
                if (darkFileName != null) {
                    logger.info("Loading darkMagic passwords from " + darkFileName);
                    Properties properties = new Properties();
                    properties.load(new BufferedInputStream(new FileInputStream(darkFileName)));
                } else {
                    logger.info("Loading darkMagic passwords from system properties");
                    Properties properties = this.baseProperties;
                }
                for (String string : var4_7.keySet()) {
                    if (!string.startsWith("darkMagic.") || string.equals(DARK_MAGIC_PASSWORD_FILE)) continue;
                    logger.info("Adding password for " + string);
                    returnProps.put(string, var4_7.getProperty(string));
                }
                break block5;
            }
            if (!keyPrefix.equals("irisDmc")) break block5;
            logger.info("Loading IRIS passwords from system properties");
            for (String string : this.baseProperties.keySet()) {
                if (!string.startsWith("irisDmc.")) continue;
                logger.info("Found IRIS property " + string);
                returnProps.put(string, this.baseProperties.getProperty(string));
            }
        }
        return returnProps;
    }

    public static void insertOrbProp(Properties props) {
        if (!props.containsKey(DISSENDIUM_ORB_PROP_NAME)) {
            props.put(DISSENDIUM_ORB_PROP_NAME, DISSENDIUM_ORB_PROP_VALUE);
        }
    }
}

