/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.map;

import gov.usgs.util.ResourceReader;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class JGWToIndex {
    public static void main(String[] args) throws IOException {
        String[] files;
        String dir = ".";
        if (args.length > 0) {
            dir = args[0];
        }
        for (String fn : files = new File(dir).list()) {
            if (!fn.endsWith(".jgw")) continue;
            ResourceReader rr = ResourceReader.getResourceReader((String)fn);
            double[] jgw = new double[6];
            for (int i = 0; i < 6; ++i) {
                jgw[i] = Double.parseDouble(rr.nextLine());
            }
            String jpg = fn.substring(0, fn.length() - 2) + "pg";
            BufferedImage image = ImageIO.read(new File(jpg));
            double w = jgw[4];
            double e = w + (double)image.getWidth() * jgw[0];
            double n = jgw[5];
            double s = n + (double)image.getHeight() * jgw[3];
            System.out.printf("%s, %d, %d, %f, %f, %f, %f\n", jpg, image.getWidth(), image.getHeight(), w, e, s, n);
        }
    }
}

