/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.map;

import gov.usgs.plot.Plot;
import gov.usgs.plot.map.GeoImage;
import gov.usgs.plot.map.GeoLabelSet;
import gov.usgs.plot.map.MapRenderer;
import gov.usgs.proj.GeoRange;
import gov.usgs.proj.Mercator;
import gov.usgs.proj.Projection;
import gov.usgs.proj.TransverseMercator;
import gov.usgs.util.CodeTimer;
import gov.usgs.util.Log;
import gov.usgs.util.Pair;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import javax.swing.JFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoImageSet {
    private static final int ONE_MEGABYTE = 0x100000;
    private static final double AREAL_THRESHOLD = 0.08;
    private List<GeoImage> images = new ArrayList<GeoImage>();
    private List<GeoImageCacheEntry> loadedImages = new LinkedList<GeoImageCacheEntry>();
    private int maxLoadedImagesSize = 0x2000000;
    private Logger logger = Log.getLogger((String)"gov.usgs.plot.map.GeoImageSet");
    private boolean arealCacheSort = true;

    public GeoImageSet() {
    }

    public GeoImageSet(String indexFilename) {
        this();
        try {
            BufferedReader in = new BufferedReader(new FileReader(indexFilename));
            String s = null;
            while ((s = in.readLine()) != null) {
                if ((s = s.trim()).length() <= 0 || s.startsWith("#")) continue;
                GeoImage gi = new GeoImage(s);
                this.images.add(gi);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Pair<GeoImageSet, GeoLabelSet> loadMapPacks(String root) {
        File[] files = new File(root).listFiles();
        if (files == null) {
            return null;
        }
        GeoImageSet gis = new GeoImageSet();
        GeoLabelSet gls = new GeoLabelSet();
        for (File f : files) {
            File lf;
            if (!f.isDirectory()) continue;
            File mp = new File(f.getPath() + File.separatorChar + "MapPack.txt");
            if (mp.exists()) {
                Logger l = Logger.getLogger("gov.usgs.plot");
                l.fine(l.getName() + ":" + l.getParent().getLevel() + ":" + l.getParent().getName());
                Logger.getLogger("gov.usgs.plot").fine("loading MapPack: " + mp.getPath());
                try {
                    BufferedReader in = new BufferedReader(new FileReader(mp));
                    String s = null;
                    while ((s = in.readLine()) != null) {
                        if ((s = s.trim()).length() <= 0 || s.startsWith("#")) continue;
                        GeoImage gi = new GeoImage(f.getPath(), s);
                        gis.images.add(gi);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!(lf = new File(f.getPath() + File.separatorChar + "Labels.txt")).exists()) continue;
            gls.appendFile(lf.getPath());
        }
        return new Pair((Object)gis, (Object)gls);
    }

    public void setArealCacheSort(boolean b) {
        this.arealCacheSort = b;
    }

    public void setMaxLoadedImagesSize(int mp) {
        this.maxLoadedImagesSize = mp * 0x100000;
    }

    private int getLoadedImagesSize() {
        int size = 0;
        Iterator<GeoImageCacheEntry> it = this.loadedImages.iterator();
        while (it.hasNext()) {
            size += it.next().getMemorySize();
        }
        return size;
    }

    private void purgeLoadedImages(List<GeoImage> avoid) {
        Collections.sort(this.loadedImages);
        int needToDelete = this.getLoadedImagesSize() - this.maxLoadedImagesSize;
        Iterator<GeoImageCacheEntry> it = this.loadedImages.iterator();
        while (it.hasNext() && needToDelete > 0) {
            GeoImageCacheEntry ce = it.next();
            if (avoid == null || !avoid.contains(ce.image)) {
                this.logger.fine("GeoImageSet Purge: " + ce.image);
                it.remove();
                needToDelete -= ce.getMemorySize();
                ce.image.disposeImage();
                continue;
            }
            this.logger.fine("SKIPPED DUE TO AVOID");
        }
        if (needToDelete > 0) {
            this.logger.info("overfull GeoImageCache by " + needToDelete + " bytes");
        }
    }

    private void addLoadedImage(GeoImage image, List<GeoImage> avoidPurging) {
        GeoImageCacheEntry ce = null;
        for (GeoImageCacheEntry o : this.loadedImages) {
            if (!((Object)o).equals(image)) continue;
            ce = o;
            break;
        }
        if (ce == null) {
            ce = new GeoImageCacheEntry(image);
            this.loadedImages.add(ce);
        } else {
            ce.touch();
        }
        if (this.getLoadedImagesSize() > this.maxLoadedImagesSize) {
            this.purgeLoadedImages(avoidPurging);
        }
    }

    public synchronized GeoImage getCompositeImage(GeoRange range, int ppdLon, int ppdLat) {
        return this.getCompositeImage(range, ppdLon, ppdLat, Double.NaN);
    }

    public synchronized GeoImage getCompositeImage(GeoRange range, int ppdLon, int ppdLat, double scale) {
        CodeTimer ct = new CodeTimer("getCompositeImage");
        double width = range.getLonRange() * (double)ppdLon;
        double height = range.getLatRange() * (double)ppdLat;
        double area = width * height;
        Rectangle2D.Double mask = new Rectangle2D.Double(0.0, 0.0, (int)width, (int)height);
        BufferedImage buffer = new BufferedImage((int)width, (int)height, 2);
        ArrayList<ImageTranslation> txs = new ArrayList<ImageTranslation>();
        for (GeoImage gi : this.images) {
            GeoRange imageRange = gi.getRange();
            if (!imageRange.overlaps(range)) continue;
            double xs = imageRange.getLonRange() * (double)ppdLon;
            double ys = imageRange.getLatRange() * (double)ppdLat;
            double subsetArea = xs * ys;
            double a = subsetArea / area;
            boolean added = false;
            if (Double.isNaN(scale)) {
                if (a > 0.08) {
                    added = true;
                }
            } else if (gi.inScale(scale, a)) {
                added = true;
            }
            if (!added) continue;
            double lr = imageRange.getWest() - range.getWest();
            double tx = lr * (double)ppdLon;
            double ty = (range.getNorth() - imageRange.getNorth()) * (double)ppdLat;
            double sx = 1.0 / (gi.getPixelsPerLon() / (double)ppdLon);
            double sy = 1.0 / (gi.getPixelsPerLat() / (double)ppdLat);
            double w = (double)gi.getPixelWidth() * sx;
            double h = (double)gi.getPixelHeight() * sy;
            Rectangle2D.Double r1 = new Rectangle2D.Double(tx, ty, w, h);
            r1 = (Rectangle2D.Double)r1.createIntersection(mask);
            if (r1.width > 0.0) {
                ImageTranslation it1 = new ImageTranslation(gi, r1, tx, ty, sx, sy);
                txs.add(it1);
            }
            tx = (lr += 360.0) * (double)ppdLon;
            Rectangle2D.Double r2 = new Rectangle2D.Double(tx, ty, w, h);
            r2 = (Rectangle2D.Double)r2.createIntersection(mask);
            if (!(r2.width > 0.0)) continue;
            ImageTranslation it2 = new ImageTranslation(gi, r2, tx, ty, sx, sy);
            txs.add(it2);
        }
        Area a = new Area();
        Collections.sort(txs);
        ListIterator lit = txs.listIterator(txs.size());
        while (lit.hasPrevious()) {
            ImageTranslation it = (ImageTranslation)lit.previous();
            if (a.contains(it.rect)) {
                lit.remove();
                continue;
            }
            a.add(new Area(it.rect));
        }
        ArrayList<GeoImage> gis = new ArrayList<GeoImage>(txs.size());
        for (ImageTranslation it : txs) {
            gis.add(it.image);
        }
        ct.mark("preload");
        Graphics2D g2 = (Graphics2D)buffer.getGraphics();
        for (ImageTranslation it : txs) {
            GeoImage gi = it.image;
            AffineTransform at = new AffineTransform();
            at.translate(it.tx, it.ty);
            at.scale(it.sx, it.sy);
            g2.drawRenderedImage(gi.getImage(), at);
            gis.remove(gi);
            this.addLoadedImage(gi, gis);
        }
        g2.dispose();
        GeoRange newRange = new GeoRange(range);
        GeoImage result = GeoImage.createMemoryImage(buffer, newRange);
        ct.stop();
        return result;
    }

    public synchronized RenderedImage getMapBackground(Projection proj, GeoRange range, int width) {
        return this.getMapBackground(proj, range, width, Double.NaN);
    }

    public synchronized RenderedImage getMapBackground(Projection proj, GeoRange range, int width, double scale) {
        int grid = 20;
        width += grid - width % grid;
        this.logger.fine(range.toString());
        double[] extents = range.getProjectedExtents(proj);
        double aspect = (extents[3] - extents[2]) / (extents[1] - extents[0]);
        int height = (int)((double)width * aspect);
        height += grid - height % grid;
        int ppdLon = (int)((double)width / range.getLonRange() * 1.2);
        int ppdLat = (int)((double)height / range.getLatRange() * 1.2);
        ppdLon = Math.max(ppdLon, 5);
        ppdLat = Math.max(ppdLat, 5);
        double padLon = range.getLonRange() * 0.0;
        double padLat = range.getLatRange() * 0.0;
        GeoRange padRange = new GeoRange(range.getWest() - padLon, range.getEast() + padLon, range.getSouth() - padLat, range.getNorth() + padLat);
        GeoImage gi = this.getCompositeImage(padRange, ppdLon, ppdLat, scale);
        BufferedImage im = null;
        if (gi != null) {
            im = proj.getProjectedImage(10, width, height, gi.getImage(), padRange, extents[0], extents[1], extents[2], extents[3]);
        }
        return im;
    }

    public static void main(String[] args) throws Exception {
        GeoImageSet is = (GeoImageSet)GeoImageSet.loadMapPacks((String)args[0]).item1;
        GeoRange range = new GeoRange(Double.parseDouble(args[1]), Double.parseDouble(args[2]), Double.parseDouble(args[3]), Double.parseDouble(args[4]));
        Mercator m = new Mercator();
        m.setOrigin(range.getCenter());
        TransverseMercator tm = new TransverseMercator();
        tm.setup(range.getCenter(), 0.0, 0.0);
        MapRenderer mr = new MapRenderer(range, (Projection)tm);
        double scale = 22000.0;
        int width = 600;
        RenderedImage image = is.getMapBackground((Projection)tm, range, width, scale);
        int INSET = 50;
        mr.setLocation(INSET, INSET, image.getWidth());
        mr.setMapImage(image);
        mr.createGraticule(6, true);
        mr.createBox(6);
        final Plot plot = new Plot();
        plot.setSize(800, 800);
        plot.addRenderer(mr);
        JFrame f = new JFrame("GeoImageSet Test, Projected"){
            public static final long serialVersionUID = -1L;

            public void paint(Graphics g) {
                super.paint(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(Color.RED);
                g2.fillRect(0, 0, 1200, 1000);
                plot.render(g2);
            }
        };
        f.setSize(1200, 1000);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImageTranslation
    implements Comparable<ImageTranslation> {
        public GeoImage image;
        public Rectangle2D.Double rect;
        public double tx;
        public double ty;
        public double sx;
        public double sy;

        public ImageTranslation(GeoImage im, Rectangle2D.Double r, double tx, double ty, double sx, double sy) {
            this.image = im;
            this.rect = r;
            this.tx = tx;
            this.ty = ty;
            this.sx = sx;
            this.sy = sy;
        }

        @Override
        public int compareTo(ImageTranslation o) {
            return this.image.compareTo(o.image);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GeoImageCacheEntry
    implements Comparable<GeoImageCacheEntry> {
        public GeoImage image;
        public long lastAccess;

        public GeoImageCacheEntry(GeoImage img) {
            this.image = img;
            this.touch();
        }

        @Override
        public int compareTo(GeoImageCacheEntry oce) {
            double a2;
            double a1;
            int val;
            if (GeoImageSet.this.arealCacheSort && (val = (int)(((a1 = this.image.getLonLatArea()) - (a2 = oce.image.getLonLatArea())) * 100000.0)) > 100) {
                return val;
            }
            return (int)(this.lastAccess - oce.lastAccess);
        }

        public int getMemorySize() {
            return this.image.getPixelWidth() * this.image.getPixelHeight();
        }

        public void touch() {
            this.lastAccess = System.currentTimeMillis();
        }

        public boolean equals(Object o) {
            if (o instanceof GeoImageCacheEntry) {
                GeoImageCacheEntry ce = (GeoImageCacheEntry)o;
                return this.image.getFilename().equals(ce.image.getFilename());
            }
            if (o instanceof GeoImage) {
                GeoImage gi = (GeoImage)o;
                return this.image.getFilename().equals(gi.getFilename());
            }
            return false;
        }
    }
}

