/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.map;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import gov.usgs.proj.GeoRange;
import gov.usgs.proj.Projection;
import gov.usgs.util.CodeTimer;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoImage
implements Comparable<GeoImage> {
    private String filename;
    private GeoRange range;
    private int pixelWidth;
    private int pixelHeight;
    private double minScale;
    private double maxScale;
    private int priority = 0;
    private BufferedImage image;

    public GeoImage() {
    }

    public GeoImage(String is) {
        String[] ss = is.split(",");
        this.filename = ss[0].trim();
        this.pixelWidth = Integer.parseInt(ss[1].trim());
        this.pixelHeight = Integer.parseInt(ss[2].trim());
        double w = Double.parseDouble(ss[3].trim());
        double e = Double.parseDouble(ss[4].trim());
        double s = Double.parseDouble(ss[5].trim());
        double n = Double.parseDouble(ss[6].trim());
        this.range = new GeoRange(w, e, s, n);
        this.image = null;
        if (ss.length > 7) {
            this.minScale = Double.parseDouble(ss[7].trim());
            this.maxScale = Double.parseDouble(ss[8].trim());
        } else {
            this.minScale = Double.NaN;
            this.maxScale = Double.NaN;
        }
        if (ss.length == 10) {
            this.priority = Integer.parseInt(ss[9].trim());
        }
    }

    public GeoImage(String root, String is) {
        this(is);
        this.filename = root + File.separatorChar + this.filename;
    }

    private void loadImage() {
        if (this.filename.equals("memory")) {
            return;
        }
        CodeTimer ct = new CodeTimer("imageLoad: " + this.filename);
        try {
            if (this.filename.toLowerCase().endsWith("jpg")) {
                JPEGImageDecoder codec = JPEGCodec.createJPEGDecoder((InputStream)new FileInputStream(this.filename));
                this.image = codec.decodeAsBufferedImage();
            } else {
                this.image = ImageIO.read(new File(this.filename));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ct.stop();
    }

    public void disposeImage() {
        if (!this.filename.equals("memory")) {
            this.image = null;
        }
    }

    public static GeoImage createMemoryImage(BufferedImage pi, GeoRange r) {
        GeoImage result = new GeoImage();
        result.filename = "memory";
        result.range = new GeoRange(r);
        result.image = pi;
        result.pixelWidth = pi.getWidth();
        result.pixelHeight = pi.getHeight();
        return result;
    }

    public String getFilename() {
        return this.filename;
    }

    public BufferedImage getImage() {
        if (this.image == null) {
            this.loadImage();
        }
        return this.image;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getPixelWidth() {
        return this.pixelWidth;
    }

    public int getPixelHeight() {
        return this.pixelHeight;
    }

    public int getPixelArea() {
        return this.pixelWidth * this.pixelHeight;
    }

    public double getLonPerPixel() {
        return this.range.getLonRange() / (double)this.pixelWidth;
    }

    public double getLatPerPixel() {
        return this.range.getLatRange() / (double)this.pixelHeight;
    }

    public double getLonLatArea() {
        return this.range.getLonRange() * this.range.getLatRange();
    }

    public double getPixelsPerLon() {
        return 1.0 / this.getLonPerPixel();
    }

    public double getPixelsPerLat() {
        return 1.0 / this.getLatPerPixel();
    }

    public double getMinScale() {
        return this.minScale;
    }

    public double getMaxScale() {
        return this.maxScale;
    }

    public boolean inScale(double sc, double area) {
        if (Double.isNaN(this.minScale) && Double.isNaN(this.maxScale)) {
            return area > 0.8;
        }
        return sc >= this.minScale && sc < this.maxScale;
    }

    public String toString() {
        return this.filename + ": " + this.range.toString();
    }

    public double[] getProjectedExtents(Projection proj) {
        return this.range.getProjectedExtents(proj);
    }

    public GeoRange getRange() {
        return this.range;
    }

    @Override
    public int compareTo(GeoImage o) {
        return this.priority - o.priority;
    }
}

