/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import gov.usgs.util.Util;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartTick {
    private static final TimeTicker[] tickers = new TimeTicker[]{new YearTicker(10), new YearTicker(5), new YearTicker(4), new YearTicker(3), new YearTicker(2), new YearTicker(1), new MonthTicker(6), new MonthTicker(4), new MonthTicker(3), new MonthTicker(2), new MonthTicker(1), new DayTicker(20), new DayTicker(10), new DayTicker(7), new DayTicker(3), new DayTicker(2), new DayTicker(1), new HourTicker(12), new HourTicker(6), new HourTicker(4), new HourTicker(3), new HourTicker(2), new HourTicker(1), new MinuteTicker(30), new MinuteTicker(15), new MinuteTicker(10), new MinuteTicker(6), new MinuteTicker(5), new MinuteTicker(4), new MinuteTicker(3), new MinuteTicker(2), new MinuteTicker(1), new SecondTicker(30), new SecondTicker(15), new SecondTicker(10), new SecondTicker(6), new SecondTicker(5), new SecondTicker(4), new SecondTicker(3), new SecondTicker(2), new SecondTicker(1), new MillisecondTicker(500L), new MillisecondTicker(200L), new MillisecondTicker(100L), new MillisecondTicker(50L), new MillisecondTicker(20L), new MillisecondTicker(10L), new MillisecondTicker(5L), new MillisecondTicker(2L), new MillisecondTicker(1L)};

    public static double[] autoTick(double min, double max, int ticks, boolean expand) {
        return SmartTick.autoTick(min, max, ticks, expand, false);
    }

    public static double[] autoTick(double min, double max, int ticks, boolean expand, boolean clip) {
        double dr = max - min;
        double de = gov.usgs.math.Util.getExp((double)dr);
        double[] step = new double[]{0.1, 0.2, 0.5, 1.0, 2.0, 5.0};
        int[] nt = new int[step.length];
        double[] gMins = new double[step.length];
        double[] gMaxes = new double[step.length];
        double[] steps = new double[step.length];
        for (int i = 0; i < step.length; ++i) {
            double s = step[i];
            double gMin = !expand ? Math.ceil(min / s) * s : Math.floor(min / (s *= Math.pow(10.0, de))) * s;
            double gMax = !expand ? Math.floor(max / s) * s : Math.ceil(max / s) * s;
            nt[i] = (int)Math.round((gMax - gMin) / s) + 1;
            gMins[i] = gMin;
            gMaxes[i] = gMax;
            steps[i] = s;
        }
        int mindt = 10000;
        int mindti = -1;
        for (int i = 0; i < nt.length; ++i) {
            int dt = Math.abs(ticks - nt[i]);
            if (dt >= mindt) continue;
            mindti = i;
            mindt = dt;
        }
        int ti = mindti;
        if (ti == -1) {
            return null;
        }
        double[] result = new double[nt[ti]];
        for (int i = 0; i < nt[ti]; ++i) {
            result[i] = gMins[ti] + (double)i * steps[ti];
            if (clip && result[i] < min) {
                result[i] = min;
            }
            if (!clip || !(result[i] > max)) continue;
            result[i] = max;
        }
        return result;
    }

    public static double[] intervalTick(double min, double max, int ticks) {
        double interval = (max - min) / (double)ticks;
        double[] result = new double[ticks];
        for (int i = 0; i < ticks; ++i) {
            result[i] = min + interval * (double)(i + 1);
        }
        return result;
    }

    public static Object[] autoTimeTick(Date ts, Date te, int ticks) {
        return SmartTick.autoTimeTick(Util.dateToJ2K((Date)ts), Util.dateToJ2K((Date)te), ticks);
    }

    public static Object[] autoTimeTick(double ts, double te, int ticks) {
        int ti = -1;
        long mindt = Integer.MAX_VALUE;
        for (int i = 0; i < tickers.length; ++i) {
            if (Math.abs(tickers[i].numTicks(ts, te) - (long)ticks) >= mindt) continue;
            ti = i;
            mindt = Math.abs(tickers[i].numTicks(ts, te) - (long)ticks);
        }
        return tickers[ti].getTicks(ts, te);
    }

    private static void setLabelFormatString(Class<?> c, String s) {
        for (TimeTicker t : tickers) {
            if (!t.getClass().equals(c)) continue;
            t.setLabelFormatString(s);
        }
    }

    public static void setMonthTickerLabelFormatString(String s) {
        SmartTick.setLabelFormatString(MonthTicker.class, s);
    }

    private static class MillisecondTicker
    extends TimeTicker {
        public MillisecondTicker(long m) {
            super((double)m / 1000.0);
            this.setLabelFormatString("HH:mm:ss.SSS");
        }
    }

    private static class SecondTicker
    extends TimeTicker {
        public SecondTicker(int s) {
            super(s);
            this.setLabelFormatString("HH:mm:ss");
        }
    }

    private static class MinuteTicker
    extends TimeTicker {
        public MinuteTicker(int m) {
            super(m * 60);
            this.setLabelFormatString("HH:mm");
        }
    }

    private static class HourTicker
    extends TimeTicker {
        public HourTicker(int h) {
            super(h * 60 * 60);
            this.setLabelFormatString("HH:mm");
        }
    }

    private static class DayTicker
    extends TimeTicker {
        private int days;
        private Calendar cal;

        public DayTicker(int d) {
            super(d * 60 * 60 * 24);
            this.days = d;
            this.setLabelFormatString("MM/dd");
        }

        public double getMinTick(double ts) {
            Date d = Util.j2KToDate((double)ts);
            this.cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            this.cal.setTime(d);
            this.cal.set(11, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 0);
            this.cal.set(14, 0);
            this.cal.add(5, 1);
            return Util.dateToJ2K((Date)this.cal.getTime());
        }

        public long numTicks(double ts, double te) {
            double minTick = this.getMinTick(ts);
            this.cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            this.cal.setTime(Util.j2KToDate((double)minTick));
            int numTicks = 0;
            while (Util.dateToJ2K((Date)this.cal.getTime()) < te) {
                this.cal.add(6, this.days);
                ++numTicks;
            }
            return numTicks;
        }

        public Object[] getTicks(double ts, double te) {
            int nt = (int)this.numTicks(ts, te);
            double[] ticks = new double[nt];
            String[] labels = new String[nt];
            double minTick = this.getMinTick(ts);
            this.cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            this.cal.setTime(Util.j2KToDate((double)minTick));
            for (int i = 0; i < nt; ++i) {
                ticks[i] = Util.dateToJ2K((Date)this.cal.getTime());
                labels[i] = this.dateFormat.format(this.cal.getTime());
                this.cal.add(6, this.days);
            }
            return new Object[]{ticks, labels};
        }
    }

    private static class MonthTicker
    extends TimeTicker {
        private int months;
        private Calendar cal;

        public MonthTicker(int m) {
            super(m * 30 * 24 * 60 * 60);
            this.months = m;
            this.setLabelFormatString("MMM-yyyy");
        }

        public double getMinTick(double ts) {
            Date d = Util.j2KToDate((double)ts);
            this.cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            this.cal.setTime(d);
            this.cal.set(5, 1);
            this.cal.set(11, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 0);
            this.cal.set(14, 0);
            this.cal.add(2, 1);
            return Util.dateToJ2K((Date)this.cal.getTime());
        }

        public long numTicks(double ts, double te) {
            double minTick = this.getMinTick(ts);
            this.cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            this.cal.setTime(Util.j2KToDate((double)minTick));
            int numTicks = 0;
            while (Util.dateToJ2K((Date)this.cal.getTime()) < te) {
                this.cal.add(2, this.months);
                ++numTicks;
            }
            return numTicks;
        }

        public Object[] getTicks(double ts, double te) {
            int nt = (int)this.numTicks(ts, te);
            double[] ticks = new double[nt];
            String[] labels = new String[nt];
            double minTick = this.getMinTick(ts);
            this.cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            this.cal.setTime(Util.j2KToDate((double)minTick));
            for (int i = 0; i < nt; ++i) {
                ticks[i] = Util.dateToJ2K((Date)this.cal.getTime());
                labels[i] = this.dateFormat.format(this.cal.getTime());
                this.cal.add(2, this.months);
            }
            return new Object[]{ticks, labels};
        }
    }

    private static class YearTicker
    extends TimeTicker {
        private int years;
        private Calendar cal;

        public YearTicker(int y) {
            super((double)y * 365.24 * 24.0 * 60.0 * 60.0);
            this.years = y;
            this.setLabelFormatString("yyyy");
        }

        public double getMinTick(double ts) {
            Date d = Util.j2KToDate((double)ts);
            this.cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            this.cal.setTime(d);
            this.cal.set(2, 0);
            this.cal.set(5, 1);
            this.cal.set(11, 0);
            this.cal.set(12, 0);
            this.cal.set(13, 0);
            this.cal.set(14, 0);
            this.cal.add(1, 1);
            return Util.dateToJ2K((Date)this.cal.getTime());
        }

        public long numTicks(double ts, double te) {
            double minTick = this.getMinTick(ts);
            this.cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            this.cal.setTime(Util.j2KToDate((double)minTick));
            int numTicks = 0;
            while (Util.dateToJ2K((Date)this.cal.getTime()) < te) {
                this.cal.add(1, this.years);
                ++numTicks;
            }
            return numTicks;
        }

        public Object[] getTicks(double ts, double te) {
            int nt = (int)this.numTicks(ts, te);
            double[] ticks = new double[nt];
            String[] labels = new String[nt];
            double minTick = this.getMinTick(ts);
            this.cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            this.cal.setTime(Util.j2KToDate((double)minTick));
            for (int i = 0; i < nt; ++i) {
                ticks[i] = Util.dateToJ2K((Date)this.cal.getTime());
                labels[i] = this.dateFormat.format(this.cal.getTime());
                this.cal.add(1, this.years);
            }
            return new Object[]{ticks, labels};
        }
    }

    private static abstract class TimeTicker {
        protected double interval;
        protected SimpleDateFormat dateFormat;
        protected String labelFormatString;

        public TimeTicker(double i) {
            this.interval = i;
        }

        public void setLabelFormatString(String s) {
            this.labelFormatString = s;
            this.dateFormat = new SimpleDateFormat(this.labelFormatString);
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }

        public long numTicks(double ts, double te) {
            return Math.round((this.getMaxTick(te) - this.getMinTick(ts)) / this.interval) + 1L;
        }

        public double getMinTick(double ts) {
            return Math.ceil(ts / this.interval) * this.interval;
        }

        public double getMaxTick(double te) {
            return Math.floor(te / this.interval) * this.interval;
        }

        public Object[] getTicks(double ts, double te) {
            double minTick = this.getMinTick(ts);
            int nt = (int)this.numTicks(ts, te);
            double[] ticks = new double[nt];
            String[] labels = new String[nt];
            for (int i = 0; i < nt; ++i) {
                ticks[i] = minTick + (double)i * this.interval;
                labels[i] = this.dateFormat.format(Util.j2KToDate((double)ticks[i]));
            }
            return new Object[]{ticks, labels};
        }

        public String toString() {
            return this.getClass().getName() + ", interval: " + this.interval;
        }
    }
}

