/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.plot.BasicFrameRenderer;
import gov.usgs.plot.ColorCycler;
import gov.usgs.plot.DataPointRenderer;
import gov.usgs.plot.LegendRenderer;
import gov.usgs.plot.Plot;
import gov.usgs.plot.PointRenderer;
import gov.usgs.plot.ShapeRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Arrays;

public class MatrixRenderer
extends BasicFrameRenderer {
    protected DoubleMatrix2D data;
    protected boolean[] visible;
    protected int offset;
    protected ShapeRenderer[] lineRenderers;
    protected DataPointRenderer[] pointRenderers;

    protected MatrixRenderer() {
    }

    public MatrixRenderer(DoubleMatrix2D d, boolean ranks) {
        this.offset = ranks ? 2 : 1;
        this.setData(d);
    }

    public void setData(DoubleMatrix2D d) {
        if (d == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        this.data = d;
        this.visible = new boolean[this.data.columns() - this.offset];
        Arrays.fill(this.visible, true);
    }

    public void setAllVisible(boolean b) {
        Arrays.fill(this.visible, b);
    }

    public void setVisible(int col, boolean v) {
        if (col < this.data.columns() - this.offset) {
            this.visible[col] = v;
        }
    }

    public ShapeRenderer[] getLineRenderers() {
        return this.lineRenderers;
    }

    public void setLineRenderers(ShapeRenderer[] r) {
        this.lineRenderers = r;
    }

    public void setLineRenderer(int col, ShapeRenderer r) {
        if (col < this.data.columns() - this.offset) {
            this.lineRenderers[col] = r;
        }
    }

    public void setPointRenderers(PointRenderer[] r) {
        this.pointRenderers = (DataPointRenderer[])r;
    }

    public void setPointRenderer(int col, PointRenderer r) {
        if (col < this.data.columns() - this.offset) {
            this.pointRenderers[col] = (DataPointRenderer)r;
        }
    }

    public void createLineRenderer(int col, Stroke s, Color color) {
        if (this.visible[col]) {
            int ic = 1000;
            if (this.data != null) {
                ic = this.data.rows() + 1;
            }
            ShapeRenderer sr = new ShapeRenderer(new GeneralPath(1, ic));
            sr.antiAlias = true;
            sr.color = color;
            sr.stroke = s;
            this.lineRenderers[col] = sr;
        }
    }

    public void createPointRenderer(int col, DataPointRenderer dr) {
        if (this.visible[col]) {
            dr.transformer = this;
            this.pointRenderers[col] = dr;
        }
    }

    public void createDefaultLineRenderers() {
        this.createDefaultLineRenderers(0);
    }

    public void createDefaultLineRenderers(int start) {
        this.lineRenderers = new ShapeRenderer[this.data.columns() - this.offset];
        ColorCycler cc = new ColorCycler(start);
        for (int i = 0; i < this.data.columns() - this.offset; ++i) {
            if (!this.visible[i]) continue;
            int ic = 1000;
            if (this.data != null) {
                ic = this.data.rows() + 1;
            }
            ShapeRenderer sr = new ShapeRenderer(new GeneralPath(1, ic));
            sr.color = cc.getNextColor();
            this.lineRenderers[i] = sr;
        }
    }

    public void createDefaultPointRenderers() {
        this.createDefaultPointRenderers(0, 'o');
    }

    public void createDefaultPointRenderers(char shape) {
        this.createDefaultPointRenderers(0, shape);
    }

    public void createDefaultPointRenderers(int start) {
        this.createDefaultPointRenderers(start, 'o');
    }

    public void createDefaultPointRenderers(int start, char shape) {
        this.pointRenderers = new DataPointRenderer[this.data.columns() - this.offset];
        ColorCycler cc = new ColorCycler(start);
        for (int i = 0; i < this.data.columns() - this.offset; ++i) {
            if (!this.visible[i]) continue;
            DataPointRenderer dpr = new DataPointRenderer(shape, 8.0f);
            dpr.color = cc.getNextColor();
            dpr.transformer = this;
            this.pointRenderers[i] = dpr;
        }
    }

    public void createDefaultLegendRenderer(String[] s) {
        this.createDefaultLegendRenderer(s, 0);
    }

    public void createDefaultLegendRenderer(String[] s, int leftLines) {
        double additionalYOffset = 0.0;
        if (leftLines > 0) {
            additionalYOffset = ((double)leftLines + 0.5) * 16.0;
        }
        this.legendRenderer = new LegendRenderer();
        this.legendRenderer.x = this.graphX + 6;
        this.legendRenderer.y = (double)(this.graphY + 6) + additionalYOffset;
        for (int i = 0; i < this.data.columns() - this.offset; ++i) {
            if (!this.visible[i]) continue;
            ShapeRenderer sr = null;
            if (this.lineRenderers != null) {
                sr = this.lineRenderers[i];
            }
            DataPointRenderer dpr = null;
            if (this.pointRenderers != null) {
                dpr = this.pointRenderers[i];
            }
            this.legendRenderer.addLine(sr, dpr, s[i]);
        }
    }

    public void render(Graphics2D g) {
        AffineTransform origAT = g.getTransform();
        Color origColor = g.getColor();
        Stroke origStroke = g.getStroke();
        Shape origClip = g.getClip();
        if (this.axis != null) {
            this.axis.render(g);
        }
        g.clip(new Rectangle(this.graphX + 1, this.graphY + 1, this.graphWidth - 1, this.graphHeight - 1));
        for (int j = 0; j < this.data.columns() - this.offset; ++j) {
            if (!this.visible[j]) continue;
            ShapeRenderer sr = null;
            if (this.lineRenderers != null) {
                sr = this.lineRenderers[j];
            }
            DataPointRenderer dpr = null;
            if (this.pointRenderers != null) {
                dpr = this.pointRenderers[j];
            }
            GeneralPath gp = null;
            if (sr != null) {
                gp = (GeneralPath)sr.shape;
                gp.reset();
                gp.moveTo((float)this.getXPixel(this.data.getQuick(0, 0)), (float)this.getYPixel(this.data.getQuick(0, j + this.offset)));
            }
            boolean lastnd = false;
            for (int i = 0; i < this.data.rows(); ++i) {
                double x = this.data.getQuick(i, 0);
                double y = this.data.getQuick(i, j + this.offset);
                if (dpr != null && !Double.isNaN(y)) {
                    dpr.x = x;
                    dpr.y = y;
                    dpr.render(g);
                }
                if (gp == null) continue;
                if (!Double.isNaN(y)) {
                    if (lastnd || i == 0) {
                        gp.moveTo((float)this.getXPixel(x), (float)this.getYPixel(y));
                    } else {
                        gp.lineTo((float)this.getXPixel(x), (float)this.getYPixel(y));
                    }
                    lastnd = false;
                    continue;
                }
                lastnd = true;
            }
            if (sr == null) continue;
            sr.render(g);
        }
        if (this.legendRenderer != null) {
            this.legendRenderer.render(g);
        }
        g.setClip(origClip);
        if (this.axis != null) {
            this.axis.postRender(g);
        }
        g.setStroke(origStroke);
        g.setColor(origColor);
        g.setTransform(origAT);
    }

    public static void main(String[] args) {
        int size = 100000;
        DoubleMatrix2D d = DoubleFactory2D.dense.make(size, 4);
        for (int i = 0; i < size; ++i) {
            d.setQuick(i, 0, (double)(i * 60));
            d.setQuick(i, 1, Math.sin(Math.PI * 8 * ((double)i / (double)size)));
            d.setQuick(i, 2, Math.cos(Math.PI * 8 * ((double)i / (double)size)));
            d.setQuick(i, 3, Math.cos(Math.PI * 8 * ((double)i / (double)size)) + 0.25 * Math.sin(87.96459430051421 * ((double)i / (double)size)));
        }
        Plot plot = new Plot();
        plot.setSize(1000, 250);
        MatrixRenderer mr = new MatrixRenderer(d, false);
        mr.setLocation(50, 20, 900, 210);
        mr.setExtents(0.0, size * 60, -1.1, 1.1);
        mr.createDefaultAxis();
        mr.setVisible(1, false);
        mr.setXAxisToTime(8);
        mr.createDefaultLineRenderers();
        plot.addRenderer(mr);
        for (int i = 0; i < 10; ++i) {
            plot.writePNG("c:\\test.png");
        }
    }
}

