/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot;

import gov.usgs.math.Util;
import gov.usgs.plot.AxisRenderer;
import gov.usgs.plot.LegendRenderer;
import gov.usgs.plot.Renderer;
import gov.usgs.plot.SmartTick;
import gov.usgs.plot.Transformer;
import java.awt.Color;
import java.text.NumberFormat;

public abstract class FrameRenderer
implements Renderer,
Transformer {
    protected String unit;
    protected int graphX;
    protected int graphY;
    protected int graphWidth;
    protected int graphHeight;
    protected double minX;
    protected double maxX;
    protected double minY;
    protected double maxY;
    protected double yAxisMult = 1.0;
    protected double yAxisOffset = 0.0;
    protected double xAxisMult = 1.0;
    protected double xAxisOffset = 0.0;
    protected AxisRenderer axis;
    protected LegendRenderer legendRenderer;
    private static NumberFormat numberFormat = NumberFormat.getInstance();

    public void setUnit(String u) {
        this.unit = u;
    }

    public String getUnit() {
        return this.unit;
    }

    public AxisRenderer getAxis() {
        return this.axis;
    }

    public void setAxis(AxisRenderer a) {
        this.axis = a;
    }

    public void createEmptyAxis() {
        this.axis = new AxisRenderer(this);
    }

    public double getYAxisMult() {
        return this.yAxisMult;
    }

    public double getXAxisMult() {
        return this.xAxisMult;
    }

    public double getXAxisOffset() {
        return this.xAxisOffset;
    }

    public double getYAxisOffset() {
        return this.yAxisOffset;
    }

    public double getMinXAxis() {
        return this.minX * this.xAxisMult + this.xAxisOffset;
    }

    public double getMaxXAxis() {
        return this.maxX * this.xAxisMult + this.xAxisOffset;
    }

    public double getMinYAxis() {
        return this.minY * this.yAxisMult + this.yAxisOffset;
    }

    public double getMaxYAxis() {
        return this.maxY * this.yAxisMult + this.yAxisOffset;
    }

    public void setXAxisCoefficients(double m, double b) {
        this.xAxisMult = m;
        this.xAxisOffset = b;
    }

    public void setYAxisCoefficients(double m, double b) {
        this.yAxisMult = m;
        this.yAxisOffset = b;
    }

    public void createDefaultAxis() {
        this.createDefaultAxis(8, 8, false, false);
    }

    public void createDefaultAxis(boolean hExpand, boolean vExpand) {
        this.createDefaultAxis(8, 8, hExpand, vExpand);
    }

    public void createDefaultAxis(int hTicks, int vTicks) {
        this.createDefaultAxis(hTicks, vTicks, false, false);
    }

    public void createDefaultAxis(int hTicks, int vTicks, boolean hExpand, boolean vExpand) {
        if (this.axis == null) {
            this.axis = new AxisRenderer(this);
        }
        this.axis.createDefault();
        if (hTicks > 0 || vTicks > 0) {
            this.createDefaultYAxis(vTicks, vExpand);
            double[] t = SmartTick.autoTick(this.getMinXAxis(), this.getMaxXAxis(), hTicks, hExpand);
            if (hExpand) {
                this.minX = t[0];
                this.maxX = t[t.length - 1];
            }
            this.axis.createTopTicks(t);
            this.axis.createBottomTicks(t);
            this.axis.createBottomTickLabels(t, null);
            this.axis.createVerticalGridLines(t);
        }
        this.axis.setBackgroundColor(Color.white);
    }

    public void createDefaultLongitudeAxis(int hTicks, int vTicks, boolean hExpand, boolean vExpand) {
        this.axis = new AxisRenderer(this);
        this.axis.createDefault();
        this.createDefaultYAxis(vTicks, vExpand);
        double[] t = SmartTick.autoTick(this.getMinXAxis(), this.getMaxXAxis(), hTicks, hExpand);
        if (hExpand) {
            this.minX = t[0];
            this.maxX = t[t.length - 1];
        }
        this.axis.createTopTicks(t);
        this.axis.createBottomTicks(t);
        this.axis.createBottomLongitudeTickLabels(t, null);
        this.axis.createVerticalGridLines(t);
        this.axis.setBackgroundColor(Color.white);
    }

    public void createDefaultYAxis(int vTicks, boolean vExpand) {
        double[] t = SmartTick.autoTick(this.getMinYAxis(), this.getMaxYAxis(), vTicks, vExpand);
        if (vExpand) {
            this.minY = t[0];
            this.maxY = t[t.length - 1];
        }
        String[] labels = null;
        if (this.yAxisMult != 1.0 || this.yAxisOffset != 0.0) {
            labels = new String[t.length];
            for (int i = 0; i < t.length; ++i) {
                double exp = Util.getExp((double)t[i]);
                labels[i] = exp >= 5.0 ? numberFormat.format(t[i] / Math.pow(10.0, exp)) + "e" + numberFormat.format(exp) : numberFormat.format(t[i]);
                t[i] = (t[i] - this.yAxisOffset) / this.yAxisMult;
            }
        }
        this.axis.createLeftTicks(t);
        this.axis.createLeftTickLabels(t, labels);
        this.axis.createRightTicks(t);
        this.axis.createHorizontalGridLines(t);
    }

    public void createDefaultLogXAxis(int hTicks) {
        double[] t = SmartTick.autoTick(this.getMinXAxis(), this.getMaxXAxis(), hTicks, false);
        String[] s = new String[t.length];
        for (int i = 0; i < t.length; ++i) {
            s[i] = String.format("%.2f", Math.pow(10.0, t[i]));
        }
        this.axis.createBottomTicks(t);
        this.axis.createTopTicks(t);
        this.axis.createBottomTickLabels(t, s);
        this.axis.createVerticalGridLines(t);
    }

    public void createDefaultLogYAxis(int vTicks) {
        double[] t = SmartTick.autoTick(this.getMinYAxis(), this.getMaxYAxis(), vTicks, false);
        String[] s = new String[t.length];
        for (int i = 0; i < t.length; ++i) {
            s[i] = String.format("%.0f", Math.pow(10.0, t[i]));
        }
        this.axis.createLeftTicks(t);
        this.axis.createRightTicks(t);
        this.axis.createLeftTickLabels(t, s);
        this.axis.createHorizontalGridLines(t);
    }

    public void setXAxisToTime(int ticks) {
        this.setXAxisToTime(ticks, true);
    }

    public void setXAxisToTime(int ticks, boolean labels) {
        Object[] stt = SmartTick.autoTimeTick(this.getMinXAxis(), this.getMaxXAxis(), ticks);
        if (stt != null) {
            this.axis.createBottomTicks((double[])stt[0]);
            this.axis.createTopTicks((double[])stt[0]);
            this.axis.createVerticalGridLines((double[])stt[0]);
            if (labels) {
                this.axis.createBottomTickLabels((double[])stt[0], (String[])stt[1]);
            }
        }
    }

    public void setLocation(FrameRenderer fr) {
        this.graphX = fr.getGraphX();
        this.graphY = fr.getGraphY();
        this.graphWidth = fr.getGraphWidth();
        this.graphHeight = fr.getGraphHeight();
    }

    public void setLocation(int x, int y, int w, int h) {
        this.graphX = x;
        this.graphY = y;
        this.graphWidth = w;
        this.graphHeight = h;
    }

    public void setGraphWidth(int w) {
        this.graphWidth = w;
    }

    public void setGraphHeight(int h) {
        this.graphHeight = h;
    }

    public void setYAspect(double asp) {
        this.graphHeight = (int)Math.round((double)this.graphHeight * asp);
    }

    public void setAspectRatio(double aspect, int yMax, int plotWidth) {
        double xr = this.maxX - this.minX;
        double yr = this.maxY - this.minY;
        double ratio = yr / xr;
        this.graphHeight = (int)Math.round((double)this.graphWidth * ratio * aspect);
        if (this.graphHeight > yMax) {
            double xs = (double)this.graphWidth / (double)this.graphHeight;
            int newWidth = (int)Math.round((double)yMax * xs);
            this.setLocation(plotWidth / 2 - newWidth / 2, this.graphY, newWidth, yMax);
        }
    }

    public void setExtents(double loX, double hiX, double loY, double hiY) {
        this.minX = loX;
        this.maxX = hiX;
        this.minY = loY;
        this.maxY = hiY;
        if (this.minY == this.maxY) {
            this.minY = loY - 1.0;
            this.maxY = hiY + 1.0;
        }
    }

    public void setMinX(double x) {
        this.minX = x;
    }

    public void setMaxX(double x) {
        this.maxX = x;
    }

    public void setMinY(double y) {
        this.minY = y;
    }

    public void setMaxY(double y) {
        this.maxY = y;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getXScale() {
        return (double)this.graphWidth / (this.maxX - this.minX);
    }

    public double getYScale() {
        return (double)this.graphHeight / (this.maxY - this.minY);
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getHeight() {
        return this.maxY - this.minY;
    }

    public double getXPixel(double x) {
        return (x - this.minX) * this.getXScale() + (double)this.graphX;
    }

    public double getYPixel(double y) {
        return (double)this.graphHeight - (y - this.minY) * this.getYScale() + (double)this.graphY;
    }

    public int getGraphX() {
        return this.graphX;
    }

    public int getGraphY() {
        return this.graphY;
    }

    public int getGraphWidth() {
        return this.graphWidth;
    }

    public int getGraphHeight() {
        return this.graphHeight;
    }

    public void createDefaultLegendRenderer(String[] s) {
        this.legendRenderer = new LegendRenderer();
        this.legendRenderer.x = this.graphX + 6;
        this.legendRenderer.y = this.graphY + 6;
        for (int i = 0; i < s.length; ++i) {
            if (s[i] == null) continue;
            this.legendRenderer.addLine(null, null, s[i]);
        }
    }

    public double[] getDefaultTranslation() {
        double dx = (this.maxX - this.minX) / (double)this.graphWidth;
        double dy = (this.maxY - this.minY) / (double)this.graphHeight;
        double[] translation = new double[]{dx, this.minX - dx * (double)this.graphX, dy, this.maxY + dy * (double)this.graphY, this.minX, this.maxX, this.minY, this.maxY};
        return translation;
    }

    public double[] getDefaultTranslation(int plotHeight) {
        double dx = (this.maxX - this.minX) / (double)this.graphWidth;
        double dy = (this.maxY - this.minY) / (double)this.graphHeight;
        double[] translation = new double[]{dx, this.minX - dx * (double)this.graphX, dy, this.minY - dy * (double)(plotHeight - this.graphHeight - this.graphY), this.minX, this.maxX, this.minY, this.maxY};
        return translation;
    }

    static {
        numberFormat.setMaximumFractionDigits(3);
    }
}

