/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util.valid;

import gov.usgs.util.valid.Constraint;
import gov.usgs.util.valid.Invalid;

public class DoubleConstraint
implements Constraint {
    public double minimum = -1.7976931348623157E308;
    public double maximum = Double.MAX_VALUE;
    public double defaultValue = Double.NaN;
    public boolean allowNull = false;

    public DoubleConstraint(double min, double max, double def, boolean n) {
        this.minimum = min;
        this.maximum = max;
        this.defaultValue = def;
        this.allowNull = n;
    }

    public Object isValid(String input) {
        if (input == null) {
            return this.allowNull ? new Double(this.defaultValue) : new Invalid("null value");
        }
        int i = 0;
        try {
            i = Integer.parseInt(input);
        }
        catch (NumberFormatException e) {
            return new Invalid("illegal number format");
        }
        if ((double)i < this.minimum) {
            return new Invalid("number less than minimum");
        }
        if ((double)i > this.maximum) {
            return new Invalid("number greater than maximum");
        }
        return new Integer(i);
    }
}

