/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util;

import gov.usgs.util.Log;
import gov.usgs.util.ProgressInputStream;
import gov.usgs.util.ProgressListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;

public class ResourceReader {
    private BufferedReader in;
    private URLConnection conn;
    private InputStream inputStream;

    private ResourceReader(URL url, ProgressListener pl) throws IOException {
        this.conn = url.openConnection();
        this.inputStream = url.openStream();
        if (pl != null) {
            ProgressInputStream pis = new ProgressInputStream(this.inputStream, this.conn.getContentLength());
            pis.addProgressListener(pl);
            this.inputStream = pis;
        }
    }

    public static ResourceReader getResourceReader(String resource) {
        return ResourceReader.getResourceReader(resource, null);
    }

    public static ResourceReader getResourceReader(URL url) {
        return ResourceReader.getResourceReader(url, null);
    }

    public static ResourceReader getResourceReader(String resource, ProgressListener pl) {
        try {
            URL url = resource.contains("://") ? new URL(resource) : new File(resource).toURI().toURL();
            return ResourceReader.getResourceReader(url, pl);
        }
        catch (Exception e) {
            Log.getLogger("gov.usgs.util").warning("Could not open resource: " + resource + ", " + e.getMessage());
            return null;
        }
    }

    public static ResourceReader getResourceReader(URL url, ProgressListener pl) {
        ResourceReader rr = null;
        try {
            rr = new ResourceReader(url, pl);
        }
        catch (Exception e) {
            Log.getLogger("gov.usgs.util").warning("Could not open resource: " + url + ", " + e.getMessage());
        }
        return rr;
    }

    public InputStream getInputStream() {
        if (this.in != null) {
            throw new IllegalStateException("Can not use input stream after the reader has been used.");
        }
        return this.inputStream;
    }

    public Reader getReader() {
        if (this.in == null) {
            this.in = new BufferedReader(new InputStreamReader(this.inputStream));
        }
        return this.in;
    }

    public String nextLine() {
        if (this.in == null) {
            this.in = new BufferedReader(new InputStreamReader(this.inputStream));
        }
        String line = null;
        try {
            line = this.in.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return line;
    }

    public void close() {
        try {
            this.inputStream.close();
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

