/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class Log {
    private Log() {
    }

    public static Logger getLogger(String key) {
        return Logger.getLogger(key);
    }

    public static String getStackTraceString(Throwable t) {
        StackTraceElement[] stack = t.getStackTrace();
        StringBuffer sb = new StringBuffer(500);
        for (int i = 0; i < stack.length; ++i) {
            sb.append("  ^---- Stack Trace: ");
            int ln = stack[i].getLineNumber();
            sb.append(stack[i].getClassName());
            sb.append(".");
            sb.append(stack[i].getMethodName());
            sb.append("/");
            sb.append(stack[i].getFileName());
            sb.append(":");
            if (ln > 0) {
                sb.append(ln);
            } else {
                sb.append("???");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static void attachSystemErrLogger(Logger logger) {
        ConsoleHandler errHandler = new ConsoleHandler();
        errHandler.setLevel(Level.ALL);
        errHandler.setFormatter(new LogFormatter());
        logger.addHandler(errHandler);
    }

    public static void attachFileLogger(Logger log, String fn, int size, int count, boolean append) {
        try {
            FileHandler fh = new FileHandler(fn, size, count, append);
            fh.setLevel(Log.findLevel(log, Level.ALL));
            fh.setFormatter(new LogFormatter());
            log.addHandler(fh);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Level findLevel(Logger l, Level d) {
        Logger ll = l;
        while (ll.getLevel() == null && ll.getParent() != null) {
            ll = ll.getParent();
        }
        return ll.getLevel() == null ? d : ll.getLevel();
    }

    static {
        Handler[] hs;
        Logger logger = Logger.getLogger("gov.usgs");
        logger.setUseParentHandlers(false);
        for (Handler h : hs = logger.getHandlers()) {
            logger.removeHandler(h);
        }
        Log.attachSystemErrLogger(logger);
    }

    private static class LogFormatter
    extends Formatter {
        private SimpleDateFormat dateOut;
        private Date date;

        public LogFormatter() {
            if (this.dateOut == null) {
                this.dateOut = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.date = new Date();
            }
        }

        public String format(LogRecord logRecord) {
            StringBuffer sb = new StringBuffer(100);
            this.date.setTime(logRecord.getMillis());
            sb.append(this.dateOut.format(this.date));
            sb.append(": (" + logRecord.getLevel() + ") ");
            sb.append(logRecord.getMessage() + "\n");
            Throwable t = logRecord.getThrown();
            Object[] params = logRecord.getParameters();
            String param = null;
            if (params != null && params.length > 0) {
                param = (String)params[0];
            }
            if (t != null) {
                sb.append(" ^------- Exception: " + t.getClass().getName() + "/" + t.getMessage() + "\n");
                sb.append(Log.getStackTraceString(t));
            } else if (param != null) {
                sb.append(" ^------- Exception: " + param + "\n");
            }
            return sb.toString();
        }
    }
}

