/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLPlatform;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bridj.BridJ;
import org.bridj.Platform;
import org.bridj.Pointer;
import org.bridj.ann.Convention;
import org.bridj.ann.Library;
import org.bridj.ann.Optional;
import org.bridj.util.ProcessUtils;
import org.bridj.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCL {
    static final boolean debug;
    static final boolean verbose;
    static final int minLogLevel;
    static final String JAVACL_DEBUG_COMPILER_FLAGS_PROP = "JAVACL_DEBUG_COMPILER_FLAGS";
    static List<String> DEBUG_COMPILER_FLAGS;
    static final OpenCLLibrary CL;
    static File userJavaCLDir;
    static File userCacheDir;

    static boolean shouldLog(Level level) {
        return verbose || level.intValue() >= minLogLevel;
    }

    static boolean log(Level level, String message, Throwable ex) {
        if (!JavaCL.shouldLog(level)) {
            return true;
        }
        Logger.getLogger(JavaCL.class.getSimpleName()).log(level, message, ex);
        return true;
    }

    static boolean log(Level level, String message) {
        JavaCL.log(level, message, null);
        return true;
    }

    private static int getPlatformIDs(int count, Pointer<OpenCLLibrary.cl_platform_id> out, Pointer<Integer> pCount) {
        try {
            return OpenCLLibrary.clIcdGetPlatformIDsKHR((int)count, out, pCount);
        }
        catch (Throwable th) {
            return OpenCLLibrary.clGetPlatformIDs((int)count, out, pCount);
        }
    }

    public static CLPlatform[] listGPUPoweredPlatforms() {
        CLPlatform[] platforms = JavaCL.listPlatforms();
        ArrayList<CLPlatform> out = new ArrayList<CLPlatform>(platforms.length);
        for (CLPlatform platform : platforms) {
            if (platform.listGPUDevices(true).length <= 0) continue;
            out.add(platform);
        }
        return out.toArray(new CLPlatform[out.size()]);
    }

    public static CLPlatform[] listPlatforms() {
        Pointer pCount = Pointer.allocateInt();
        CLException.error(JavaCL.getPlatformIDs(0, null, (Pointer<Integer>)pCount));
        int nPlats = (Integer)pCount.get();
        if (nPlats == 0) {
            return new CLPlatform[0];
        }
        Pointer ids = Pointer.allocateTypedPointers(OpenCLLibrary.cl_platform_id.class, (long)nPlats);
        CLException.error(JavaCL.getPlatformIDs(nPlats, (Pointer<OpenCLLibrary.cl_platform_id>)ids, null));
        CLPlatform[] platforms = new CLPlatform[nPlats];
        for (int i = 0; i < nPlats; ++i) {
            platforms[i] = new CLPlatform((OpenCLLibrary.cl_platform_id)ids.get((long)i));
        }
        return platforms;
    }

    public static CLContext createContext(Map<CLPlatform.ContextProperties, Object> contextProperties, CLDevice ... devices) {
        return devices[0].getPlatform().createContext(contextProperties, devices);
    }

    public static void unloadCompiler() {
        CLException.error(CL.clUnloadCompiler());
    }

    public static CLDevice getBestDevice() {
        return JavaCL.getBestDevice(CLPlatform.DeviceFeature.MaxComputeUnits);
    }

    public static CLDevice getBestDevice(CLPlatform.DeviceFeature ... preferredFeatures) {
        ArrayList<CLDevice> devices = new ArrayList<CLDevice>();
        for (CLPlatform platform : JavaCL.listPlatforms()) {
            devices.addAll(Arrays.asList(platform.listAllDevices(true)));
        }
        return CLPlatform.getBestDevice(Arrays.asList(preferredFeatures), devices);
    }

    public static CLContext createBestContext() {
        return JavaCL.createBestContext(CLPlatform.DeviceFeature.MaxComputeUnits);
    }

    public static CLContext createBestContext(CLPlatform.DeviceFeature ... preferredFeatures) {
        CLDevice device = JavaCL.getBestDevice(preferredFeatures);
        return device.getPlatform().createContext(null, device);
    }

    public static CLContext createContextFromCurrentGL() {
        RuntimeException first = null;
        for (CLPlatform platform : JavaCL.listPlatforms()) {
            try {
                CLContext ctx = platform.createContextFromCurrentGL();
                if (ctx == null) continue;
                return ctx;
            }
            catch (RuntimeException ex) {
                if (first != null) continue;
                first = ex;
            }
        }
        throw new RuntimeException("Failed to create an OpenCL context based on the current OpenGL context", first);
    }

    static synchronized File createTempFile(String prefix, String suffix, String category) {
        File dir = new File(userJavaCLDir, category);
        dir.mkdirs();
        try {
            return File.createTempFile(prefix, suffix, dir);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to create a temporary directory for category '" + category + "' in " + userJavaCLDir + ": " + ex.getMessage(), ex);
        }
    }

    static synchronized File createTempDirectory(String prefix, String suffix, String category) {
        File file = JavaCL.createTempFile(prefix, suffix, category);
        file.delete();
        file.mkdir();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block8: {
            debug = "true".equals(System.getProperty("javacl.debug")) || "1".equals(System.getenv("JAVACL_DEBUG"));
            verbose = debug || "true".equals(System.getProperty("javacl.verbose")) || "1".equals(System.getenv("JAVACL_VERBOSE"));
            minLogLevel = Level.WARNING.intValue();
            OpenCLProbeLibrary probe = new OpenCLProbeLibrary();
            try {
                String alt;
                block10: {
                    block9: {
                        if (probe.isValid()) break block8;
                        if (!Platform.is64Bits()) break block9;
                        alt = "atiocl64";
                        if (BridJ.getNativeLibraryFile((String)"atiocl64") != null) break block10;
                    }
                    alt = "atiocl32";
                    if (BridJ.getNativeLibraryFile((String)"atiocl32") == null) {
                        alt = "atiocl";
                        if (BridJ.getNativeLibraryFile((String)"atiocl") == null) break block8;
                    }
                }
                JavaCL.log(Level.INFO, "Hacking around ATI's weird driver bugs (using atiocl library instead of OpenCL)", null);
                BridJ.setNativeLibraryActualName((String)"OpenCL", (String)alt);
            }
            finally {
                probe = null;
                BridJ.unregister(OpenCLProbeLibrary.class);
            }
        }
        if (debug) {
            String debugArgs = System.getenv(JAVACL_DEBUG_COMPILER_FLAGS_PROP);
            DEBUG_COMPILER_FLAGS = debugArgs != null ? Arrays.asList(debugArgs.split(" ")) : (Platform.isMacOSX() ? Arrays.asList("-g") : Arrays.asList("-O0", "-g"));
            int pid = ProcessUtils.getCurrentProcessId();
            JavaCL.log(Level.INFO, "Debug mode enabled with compiler flags \"" + StringUtils.implode(DEBUG_COMPILER_FLAGS, (Object)" ") + "\" (can be overridden with env. var. JAVACL_DEBUG_COMPILER_FLAGS_PROP)");
            JavaCL.log(Level.INFO, "You can debug your kernels with GDB using one of the following commands :\n\tsudo gdb --tui --pid=" + pid + "\n" + "\tsudo ddd --debugger \"gdb --pid=" + pid + "\"\n" + "More info here :\n" + "\thttp://code.google.com/p/javacl/wiki/DebuggingKernels");
        }
        CL = new OpenCLLibrary();
        userJavaCLDir = new File(new File(System.getProperty("user.home")), ".javacl");
        userCacheDir = new File(userJavaCLDir, "cache");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Library(value="OpenCLProbe")
    @Convention(value=Convention.Style.StdCall)
    public static class OpenCLProbeLibrary {
        @Optional
        public static synchronized native int clGetPlatformIDs(int var0, Pointer<OpenCLLibrary.cl_platform_id> var1, Pointer<Integer> var2);

        @Optional
        public static synchronized native int clIcdGetPlatformIDsKHR(int var0, Pointer<OpenCLLibrary.cl_platform_id> var1, Pointer<Integer> var2);

        public boolean isValid() {
            int err;
            Pointer pCount = Pointer.allocateInt();
            try {
                err = OpenCLProbeLibrary.clIcdGetPlatformIDsKHR(0, null, (Pointer<Integer>)pCount);
            }
            catch (Throwable th) {
                try {
                    err = OpenCLProbeLibrary.clGetPlatformIDs(0, null, (Pointer<Integer>)pCount);
                }
                catch (Throwable th2) {
                    return false;
                }
            }
            return err == 0 && (Integer)pCount.get() > 0;
        }

        static {
            BridJ.setNativeLibraryActualName((String)"OpenCLProbe", (String)"OpenCL");
            BridJ.register();
        }
    }
}

