/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLInfoGetter;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.InfoName;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import java.util.EnumSet;
import org.bridj.Pointer;
import org.bridj.SizeT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLQueue
extends CLAbstractEntity<OpenCLLibrary.cl_command_queue> {
    private CLInfoGetter<OpenCLLibrary.cl_command_queue> infos = new CLInfoGetter<OpenCLLibrary.cl_command_queue>(){

        @Override
        protected int getInfo(OpenCLLibrary.cl_command_queue entity, int infoTypeEnum, long size, Pointer out, Pointer<SizeT> sizeOut) {
            return OpenCLLibrary.clGetCommandQueueInfo((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)CLQueue.this.getEntity()), (int)infoTypeEnum, (long)size, (Pointer)out, sizeOut);
        }
    };
    final CLContext context;
    final CLDevice device;
    volatile Boolean outOfOrder;

    CLQueue(CLContext context, OpenCLLibrary.cl_command_queue entity, CLDevice device) {
        super(entity);
        this.context = context;
        this.device = device;
    }

    public CLContext getContext() {
        return this.context;
    }

    public CLDevice getDevice() {
        return this.device;
    }

    public synchronized boolean isOutOfOrder() {
        if (this.outOfOrder == null) {
            this.outOfOrder = this.getProperties().contains((Object)CLDevice.QueueProperties.OutOfOrderExecModeEnable);
        }
        return this.outOfOrder;
    }

    @InfoName(value="CL_QUEUE_PROPERTIES")
    public EnumSet<CLDevice.QueueProperties> getProperties() {
        return CLDevice.QueueProperties.getEnumSet(this.infos.getIntOrLong((OpenCLLibrary.cl_command_queue)this.getEntity(), 4243));
    }

    public void setProperty(CLDevice.QueueProperties property, boolean enabled) {
        CLException.error(OpenCLLibrary.clSetCommandQueueProperty((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)this.getEntity()), (long)property.value(), (int)(enabled ? 1 : 0), (Pointer)null));
    }

    @Override
    protected void clear() {
        CLException.error(OpenCLLibrary.clReleaseCommandQueue((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)this.getEntity())));
    }

    public void finish() {
        CLException.error(OpenCLLibrary.clFinish((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)this.getEntity())));
    }

    public void flush() {
        CLException.error(OpenCLLibrary.clFlush((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)this.getEntity())));
    }

    public void enqueueWaitForEvents(CLEvent ... events) {
        Pointer<OpenCLLibrary.cl_event> evts = CLEvent.to_cl_event_array(events);
        CLException.error(OpenCLLibrary.clEnqueueWaitForEvents((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)this.getEntity()), (int)(evts == null ? 0 : (int)evts.getValidElements()), evts));
    }

    public void enqueueBarrier() {
        CLException.error(OpenCLLibrary.clEnqueueBarrier((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)this.getEntity())));
    }

    public CLEvent enqueueMarker() {
        Pointer eventOut = Pointer.allocateTypedPointer(OpenCLLibrary.cl_event.class);
        CLException.error(OpenCLLibrary.clEnqueueMarker((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)this.getEntity()), (Pointer)eventOut));
        return CLEvent.createEventFromPointer(this, (Pointer<OpenCLLibrary.cl_event>)eventOut);
    }

    public CLEvent enqueueAcquireGLObjects(CLMem[] objects, CLEvent ... eventsToWaitFor) {
        Pointer<OpenCLLibrary.cl_event> eventOut = CLEvent.new_event_out(eventsToWaitFor);
        Pointer mems = Pointer.allocateTypedPointers(OpenCLLibrary.cl_mem.class, (long)objects.length);
        for (int i = 0; i < objects.length; ++i) {
            mems.set((long)i, objects[i].getEntity());
        }
        Pointer<OpenCLLibrary.cl_event> evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(OpenCLLibrary.clEnqueueAcquireGLObjects((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)this.getEntity()), (int)objects.length, (Pointer)mems, (int)(evts == null ? 0 : (int)evts.getValidElements()), evts, eventOut));
        return CLEvent.createEventFromPointer(this, eventOut);
    }

    public CLEvent enqueueReleaseGLObjects(CLMem[] objects, CLEvent ... eventsToWaitFor) {
        Pointer<OpenCLLibrary.cl_event> eventOut = CLEvent.new_event_out(eventsToWaitFor);
        Pointer mems = CLQueue.getEntities((CLAbstractEntity[])objects, (Pointer)Pointer.allocateTypedPointers(OpenCLLibrary.cl_mem.class, (long)objects.length));
        Pointer<OpenCLLibrary.cl_event> evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(OpenCLLibrary.clEnqueueReleaseGLObjects((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)this.getEntity()), (int)objects.length, (Pointer)mems, (int)(evts == null ? 0 : (int)evts.getValidElements()), evts, eventOut));
        return CLEvent.createEventFromPointer(this, eventOut);
    }
}

