/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLBuildException;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLInfoGetter;
import com.nativelibs4java.opencl.CLKernel;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.nativelibs4java.util.IOUtils;
import com.nativelibs4java.util.Pair;
import com.ochafik.util.string.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.bridj.Platform;
import org.bridj.Pointer;
import org.bridj.SizeT;
import org.bridj.util.DefaultParameterizedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLProgram
extends CLAbstractEntity<OpenCLLibrary.cl_program> {
    protected final CLContext context;
    private static CLInfoGetter<OpenCLLibrary.cl_program> infos = new CLInfoGetter<OpenCLLibrary.cl_program>(){

        @Override
        protected int getInfo(OpenCLLibrary.cl_program entity, int infoTypeEnum, long size, Pointer out, Pointer<SizeT> sizeOut) {
            return OpenCLLibrary.clGetProgramInfo((OpenCLLibrary.cl_program)entity, (int)infoTypeEnum, (long)size, (Pointer)out, sizeOut);
        }
    };
    CLDevice[] devices;
    private static final String BinariesSignatureZipEntryName = "SIGNATURE";
    private static final String SourceZipEntryName = "SOURCE";
    private static final String textEncoding = "utf-8";
    List<String> sources = new ArrayList<String>();
    Map<CLDevice, OpenCLLibrary.cl_program> programByDevice = new HashMap<CLDevice, OpenCLLibrary.cl_program>();
    public static boolean passMacrosAsSources = true;
    List<String> includes;
    Map<String, URL> resolvedInclusions;
    static Pattern includePattern = Pattern.compile("#\\s*include\\s*\"([^\"]+)\"");
    String source;
    Map<String, Object> macros;
    List<String> extraBuildOptions;
    private volatile Boolean cached;
    private final String[] propsToIncludeInSignature = new String[]{"os.version", "os.name"};
    boolean built;

    CLProgram(CLContext context, CLDevice ... devices) {
        super(null, true);
        this.context = context;
        this.devices = devices == null || devices.length == 0 ? context.getDevices() : devices;
    }

    CLProgram(CLContext context, Map<CLDevice, byte[]> binaries, String source) {
        super(null, true);
        this.context = context;
        this.source = source;
        this.setBinaries(binaries);
    }

    protected void setBinaries(Map<CLDevice, byte[]> binaries) {
        if (this.devices == null) {
            this.devices = new CLDevice[binaries.size()];
            int iDevice = 0;
            for (CLDevice device : binaries.keySet()) {
                this.devices[iDevice++] = device;
            }
        }
        int nDevices = this.devices.length;
        if (binaries.size() != nDevices) {
            throw new IllegalArgumentException("Not enough binaries in provided map : expected " + nDevices + " (devices = " + Arrays.asList(this.devices) + "), got " + binaries.size() + " (" + binaries.keySet() + ")");
        }
        Pointer lengths = Pointer.allocateSizeTs((long)nDevices);
        Pointer deviceIds = Pointer.allocateTypedPointers(OpenCLLibrary.cl_device_id.class, (long)nDevices);
        Pointer binariesArray = Pointer.allocatePointers((Type)DefaultParameterizedType.paramType(Pointer.class, (Type[])new Type[]{Byte.class}), (int)nDevices);
        Pointer[] binariesMems = new Pointer[nDevices];
        int iDevice = 0;
        for (CLDevice device : this.devices) {
            byte[] binary = binaries.get(device);
            if (binary == null) {
                throw new IllegalArgumentException("No binary for device " + device + " in provided binaries");
            }
            binariesMems[iDevice] = Pointer.pointerToBytes((byte[])binary);
            binariesArray.set((long)iDevice, (Object)binariesMems[iDevice]);
            lengths.set((long)iDevice, (Object)new SizeT((long)binary.length));
            deviceIds.set((long)iDevice, device.getEntity());
            ++iDevice;
        }
        nDevices = iDevice;
        if (nDevices == 0) {
            return;
        }
        Pointer errBuff = Pointer.allocateInt();
        int previousAttempts = 0;
        Pointer statuses = Pointer.allocateInts((long)nDevices);
        do {
            this.entity = OpenCLLibrary.clCreateProgramWithBinary((OpenCLLibrary.cl_context)((OpenCLLibrary.cl_context)this.context.getEntity()), (int)nDevices, (Pointer)deviceIds, (Pointer)lengths, (Pointer)binariesArray, (Pointer)statuses, (Pointer)errBuff);
        } while (CLException.failedForLackOfMemory((Integer)errBuff.get(), previousAttempts++));
    }

    public void store(OutputStream out) throws CLBuildException, IOException {
        CLProgram.writeBinaries(this.getBinaries(), this.getSource(), null, out);
    }

    private static final void addStoredEntry(ZipOutputStream zout, String name, byte[] data) throws IOException {
        ZipEntry ze = new ZipEntry(name);
        ze.setMethod(0);
        ze.setSize(data.length);
        CRC32 crc = new CRC32();
        crc.update(data, 0, data.length);
        ze.setCrc(crc.getValue());
        zout.putNextEntry(ze);
        zout.write(data);
        zout.closeEntry();
    }

    public static void writeBinaries(Map<CLDevice, byte[]> binaries, String source, String contentSignatureString, OutputStream out) throws IOException {
        HashMap<String, byte[]> binaryBySignature = new HashMap<String, byte[]>();
        for (Map.Entry<CLDevice, byte[]> e : binaries.entrySet()) {
            binaryBySignature.put(e.getKey().createSignature(), e.getValue());
        }
        ZipOutputStream zout = new ZipOutputStream(new GZIPOutputStream(new BufferedOutputStream(out)));
        if (contentSignatureString != null) {
            CLProgram.addStoredEntry(zout, BinariesSignatureZipEntryName, contentSignatureString.getBytes(textEncoding));
        }
        if (source != null) {
            CLProgram.addStoredEntry(zout, SourceZipEntryName, source.getBytes(textEncoding));
        }
        for (Map.Entry e : binaryBySignature.entrySet()) {
            CLProgram.addStoredEntry(zout, (String)e.getKey(), (byte[])e.getValue());
        }
        zout.close();
    }

    public static Pair<Map<CLDevice, byte[]>, String> readBinaries(List<CLDevice> allowedDevices, String expectedContentSignatureString, InputStream in) throws IOException {
        ZipEntry ze;
        HashMap<CLDevice, byte[]> ret = new HashMap<CLDevice, byte[]>();
        Map<String, List<CLDevice>> devicesBySignature = CLDevice.getDevicesBySignature(allowedDevices);
        ZipInputStream zin = new ZipInputStream(new GZIPInputStream(new BufferedInputStream(in)));
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        String source = null;
        boolean first = true;
        byte[] b = new byte[65536];
        while ((ze = zin.getNextEntry()) != null) {
            int len;
            String signature = ze.getName();
            boolean isSignature = signature.equals(BinariesSignatureZipEntryName);
            if (first && !isSignature && expectedContentSignatureString != null || !first && isSignature) {
                throw new IOException("Expected signature to be the first zip entry, got '" + signature + "' instead !");
            }
            first = false;
            bout.reset();
            while ((len = zin.read(b)) > 0) {
                bout.write(b, 0, len);
            }
            byte[] data = bout.toByteArray();
            if (isSignature) {
                String contentSignatureString;
                if (expectedContentSignatureString == null || expectedContentSignatureString.equals(contentSignatureString = new String(data, textEncoding))) continue;
                throw new IOException("Content signature does not match expected one :\nExpected '" + expectedContentSignatureString + "',\nGot '" + contentSignatureString + "'");
            }
            if (signature.equals(SourceZipEntryName)) {
                source = new String(data, textEncoding);
                continue;
            }
            List<CLDevice> devices = devicesBySignature.get(signature);
            for (CLDevice device : devices) {
                ret.put(device, data);
            }
        }
        zin.close();
        return new Pair(ret, source);
    }

    public CLDevice[] getDevices() {
        return (CLDevice[])this.devices.clone();
    }

    public synchronized void allocate() {
        OpenCLLibrary.cl_program program;
        if (this.entity != null) {
            throw new IllegalThreadStateException("Program was already allocated !");
        }
        if (passMacrosAsSources && this.macros != null && !this.macros.isEmpty()) {
            StringBuilder b = new StringBuilder();
            for (Map.Entry<String, Object> m : this.macros.entrySet()) {
                b.append("#define " + m.getKey() + " " + m.getValue() + "\n");
            }
            this.sources.add(0, b.toString());
        }
        if (!"false".equals(System.getProperty("javacl.adjustDoubleExtension")) && !"0".equals(System.getenv("JAVACL_ADJUST_DOUBLE_EXTENSION"))) {
            int len = this.sources.size();
            for (int i = 0; i < len; ++i) {
                String source = this.sources.get(i);
                for (CLDevice device : this.getDevices()) {
                    source = device.replaceDoubleExtensionByExtensionActuallyAvailable(source);
                }
                this.sources.set(i, source);
            }
        }
        String[] sources = this.sources.toArray(new String[this.sources.size()]);
        long[] lengths = new long[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            lengths[i] = sources[i].length();
        }
        Pointer errBuff = Pointer.allocateInt();
        int previousAttempts = 0;
        do {
            program = OpenCLLibrary.clCreateProgramWithSource((OpenCLLibrary.cl_context)((OpenCLLibrary.cl_context)this.context.getEntity()), (int)sources.length, (Pointer)Pointer.pointerToCStrings((String[])sources), (Pointer)Pointer.pointerToSizeTs((long[])lengths), (Pointer)errBuff);
        } while (CLException.failedForLackOfMemory((Integer)errBuff.get(0L), previousAttempts++));
        this.entity = program;
    }

    @Override
    protected synchronized OpenCLLibrary.cl_program getEntity() {
        if (this.entity == null) {
            this.allocate();
        }
        return (OpenCLLibrary.cl_program)this.entity;
    }

    public synchronized void addInclude(String path) {
        if (this.includes == null) {
            this.includes = new ArrayList<String>();
        }
        this.includes.add(path);
        this.resolvedInclusions = null;
    }

    public synchronized void addSource(String src) {
        if (this.entity != null) {
            throw new IllegalThreadStateException("Program was already allocated : cannot add sources anymore.");
        }
        this.sources.add(src);
        this.resolvedInclusions = null;
    }

    protected Runnable copyIncludesToTemporaryDirectory() throws IOException {
        Map<String, URL> inclusions = this.resolveInclusions();
        File includesDir = JavaCL.createTempDirectory("includes", "", "includes");
        final ArrayList<File> filesToDelete = new ArrayList<File>();
        for (Map.Entry<String, URL> e : inclusions.entrySet()) {
            assert (JavaCL.log(Level.INFO, "Copying include '" + e.getKey() + "' from '" + e.getValue() + "' to '" + includesDir + "'"));
            File f = new File(includesDir, e.getKey().replace('/', File.separatorChar));
            File p = f.getParentFile();
            filesToDelete.add(f);
            if (p != null) {
                p.mkdirs();
                filesToDelete.add(p);
            }
            InputStream in = e.getValue().openStream();
            FileOutputStream out = new FileOutputStream(f);
            IOUtils.readWrite((InputStream)in, (OutputStream)out);
            in.close();
            ((OutputStream)out).close();
            f.deleteOnExit();
        }
        filesToDelete.add(includesDir);
        this.addInclude(includesDir.toString());
        return new Runnable(){

            public void run() {
                for (File f : filesToDelete) {
                    f.delete();
                }
            }
        };
    }

    public Map<String, URL> resolveInclusions() throws IOException {
        if (this.resolvedInclusions == null) {
            this.resolvedInclusions = new HashMap<String, URL>();
            for (String source : this.sources) {
                this.resolveInclusions(source, this.resolvedInclusions);
            }
        }
        return this.resolvedInclusions;
    }

    private void resolveInclusions(String source, Map<String, URL> ret) throws IOException {
        ArrayList<String> includedPaths = new ArrayList<String>();
        Matcher m = includePattern.matcher(source);
        while (m.find()) {
            includedPaths.add(m.group(1));
        }
        for (String includedPath : includedPaths) {
            if (ret.containsKey(includedPath)) continue;
            URL url = this.getIncludedSourceURL(includedPath);
            if (url == null) {
                assert (JavaCL.log(Level.SEVERE, "Failed to resolve include '" + includedPath + "'"));
                continue;
            }
            String s = IOUtils.readText((URL)url);
            ret.put(includedPath, url);
            this.resolveInclusions(s, ret);
        }
    }

    public String getIncludedSourceContent(String path) throws IOException {
        URL url = this.getIncludedSourceURL(path);
        if (url == null) {
            return null;
        }
        String src = IOUtils.readText((URL)url);
        return src;
    }

    public URL getIncludedSourceURL(String path) throws MalformedURLException {
        File f = new File(path);
        if (f.exists()) {
            return f.toURI().toURL();
        }
        URL url = Platform.getClassLoader(this.getClass()).getResource(path);
        if (url != null) {
            return url;
        }
        if (this.includes != null) {
            for (String include : this.includes) {
                f = new File(new File(include), path);
                if (f.exists()) {
                    return f.toURI().toURL();
                }
                url = Platform.getClassLoader(this.getClass()).getResource(f.toString());
                if (url != null) {
                    return url;
                }
                try {
                    url = new URL(include + (include.endsWith("/") ? "" : "/") + path);
                    url.openStream().close();
                    return url;
                }
                catch (IOException ex) {
                }
            }
        }
        return null;
    }

    public synchronized String getSource() {
        if (this.source == null) {
            this.source = infos.getString(this.getEntity(), 4452);
        }
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<CLDevice, byte[]> getBinaries() throws CLBuildException {
        CLProgram cLProgram = this;
        synchronized (cLProgram) {
            if (!this.built) {
                this.build();
            }
        }
        Pointer<?> s = infos.getMemory(this.getEntity(), 4453);
        int n = (int)s.getValidBytes() / Platform.SIZE_T_SIZE;
        long[] sizes = s.getSizeTs(n);
        Pointer[] binMems = new Pointer[n];
        Pointer ptrs = Pointer.allocatePointers((int)n);
        for (int i = 0; i < n; ++i) {
            binMems[i] = Pointer.allocateBytes((long)sizes[i]);
            ptrs.set((long)i, (Object)binMems[i]);
        }
        CLException.error(infos.getInfo(this.getEntity(), 4454, ptrs.getValidBytes(), ptrs, null));
        HashMap<CLDevice, byte[]> ret = new HashMap<CLDevice, byte[]>(this.devices.length);
        int iBin = n == this.devices.length + 1 ? 1 : 0;
        for (int i = 0; i < this.devices.length; ++i) {
            CLDevice device = this.devices[i];
            Pointer bytes = binMems[iBin + i];
            if (bytes == null) continue;
            ret.put(device, bytes.getBytes((int)sizes[iBin + i]));
        }
        return ret;
    }

    public CLContext getContext() {
        return this.context;
    }

    public CLProgram defineMacro(String name, Object value) {
        this.createMacros();
        this.macros.put(name, value);
        return this;
    }

    public CLProgram undefineMacro(String name) {
        if (this.macros != null) {
            this.macros.remove(name);
        }
        return this;
    }

    private void createMacros() {
        if (this.macros == null) {
            this.macros = new LinkedHashMap<String, Object>();
        }
    }

    public void defineMacros(Map<String, Object> macros) {
        this.createMacros();
        this.macros.putAll(macros);
    }

    public void setFastRelaxedMath() {
        this.addBuildOption("-cl-fast-relaxed-math");
    }

    public void setNoSignedZero() {
        this.addBuildOption("-cl-no-signed-zero");
    }

    public void setMadEnable() {
        this.addBuildOption("-cl-mad-enable");
    }

    public void setFiniteMathOnly() {
        this.addBuildOption("-cl-finite-math-only");
    }

    public void setUnsafeMathOptimizations() {
        this.addBuildOption("-cl-unsafe-math-optimizations");
    }

    public void setNVVerbose() {
        this.addBuildOption("-cl-nv-verbose");
    }

    public void setNVMaximumRegistryCount(int N) {
        this.addBuildOption("-cl-nv-maxrregcount=" + N);
    }

    public void setNVOptimizationLevel(int N) {
        this.addBuildOption("-cl-nv-opt-level=" + N);
    }

    public synchronized void addBuildOption(String option) {
        if (option.startsWith("-I")) {
            this.addInclude(option.substring(2));
            return;
        }
        if (this.extraBuildOptions == null) {
            this.extraBuildOptions = new ArrayList<String>();
        }
        this.extraBuildOptions.add(option);
    }

    protected String getOptionsString() {
        StringBuilder b = new StringBuilder("-DJAVACL=1 ");
        if (this.extraBuildOptions != null) {
            if (JavaCL.debug) {
                boolean isCPUOnly = true;
                for (CLDevice device : this.getDevices()) {
                    if (device.getType().contains((Object)CLDevice.Type.CPU)) continue;
                    isCPUOnly = false;
                    break;
                }
                if (!isCPUOnly) {
                    JavaCL.log(Level.WARNING, "Debug mode : cannot only compile with debug flags on a CPU-only context");
                } else {
                    Iterator<String> iterator = this.extraBuildOptions.iterator();
                    while (iterator.hasNext()) {
                        String opt = iterator.next();
                        if (!opt.startsWith("-O") && !opt.startsWith("-g:") || JavaCL.DEBUG_COMPILER_FLAGS.contains(opt)) continue;
                        JavaCL.log(Level.WARNING, "Debug mode : removed argument \"" + opt + "\" from OpenCL compiler command-line arguments");
                        iterator.remove();
                    }
                    this.extraBuildOptions.addAll(JavaCL.DEBUG_COMPILER_FLAGS);
                    JavaCL.log(Level.ALL, "Debug mode : added OpenCL compiler command-line arguments \"" + StringUtils.implode(JavaCL.DEBUG_COMPILER_FLAGS, (Object)" ") + "\"");
                }
            }
            for (String string : this.extraBuildOptions) {
                b.append(string.contains(" ") || string.contains("\"") ? "\"" + string.replaceAll("\"", "\\\"") + "\"" : string).append(' ');
            }
        }
        if (!passMacrosAsSources && this.macros != null && !this.macros.isEmpty()) {
            for (Map.Entry entry : this.macros.entrySet()) {
                b.append("-D" + (String)entry.getKey() + "=" + entry.getValue() + " ");
            }
        }
        if (this.includes != null) {
            for (String string : this.includes) {
                if (!new File(string).exists()) continue;
                b.append("-I").append(string).append(' ');
            }
        }
        return b.toString();
    }

    public synchronized void setCached(boolean cached) {
        this.cached = cached;
    }

    public synchronized boolean isCached() {
        if (this.cached == null) {
            this.cached = this.context.getCacheBinaries();
        }
        return this.cached;
    }

    protected String computeCacheSignature() throws IOException {
        Map<String, URL> inclusions;
        StringBuilder b = new StringBuilder(16384);
        this.getContext().getPlatform().toString(b);
        b.append('\n');
        for (CLDevice device : this.getDevices()) {
            b.append(device).append('\n');
        }
        b.append(this.getOptionsString()).append('\n');
        if (this.macros != null && !this.macros.isEmpty()) {
            for (Map.Entry entry : this.macros.entrySet()) {
                b.append("-D").append((String)entry.getKey()).append('=').append(entry.getValue()).append('\n');
            }
        }
        if (this.includes != null && !this.includes.isEmpty()) {
            for (String string : this.includes) {
                b.append("-I").append(string).append('\n');
            }
        }
        if (this.sources != null && !this.sources.isEmpty()) {
            for (String string : this.sources) {
                b.append(string).append('\n');
            }
        }
        if ((inclusions = this.resolveInclusions()) != null && !inclusions.isEmpty()) {
            for (Map.Entry<String, URL> e : inclusions.entrySet()) {
                URLConnection con = e.getValue().openConnection();
                InputStream in = con.getInputStream();
                b.append('#').append(e.getKey()).append(con.getLastModified()).append('\n');
                in.close();
            }
        }
        for (String name : this.propsToIncludeInSignature) {
            b.append(name).append('=').append(System.getProperty(name)).append('\n');
        }
        return b.toString();
    }

    protected Set<String> getProgramBuildInfo(OpenCLLibrary.cl_program pgm, Pointer<OpenCLLibrary.cl_device_id> deviceIds) {
        Pointer len = Pointer.allocateSizeT();
        int bufLen = 65536;
        Pointer buffer = Pointer.allocateBytes((long)bufLen);
        HashSet<String> errs = new HashSet<String>();
        if (deviceIds == null) {
            CLException.error(OpenCLLibrary.clGetProgramBuildInfo((OpenCLLibrary.cl_program)pgm, null, (int)4483, (long)bufLen, (Pointer)buffer, (Pointer)len));
            String s = buffer.getCString();
            errs.add(s);
        } else {
            for (OpenCLLibrary.cl_device_id device : deviceIds) {
                CLException.error(OpenCLLibrary.clGetProgramBuildInfo((OpenCLLibrary.cl_program)pgm, (OpenCLLibrary.cl_device_id)device, (int)4483, (long)bufLen, (Pointer)buffer, (Pointer)len));
                String s = buffer.getCString();
                errs.add(s);
            }
        }
        return errs;
    }

    public synchronized CLProgram build() throws CLBuildException {
        if (this.built) {
            throw new IllegalThreadStateException("Program was already built !");
        }
        String contentSignature = null;
        File cacheFile = null;
        boolean readBinaries = false;
        if (this.isCached()) {
            try {
                contentSignature = this.computeCacheSignature();
                byte[] sha = MessageDigest.getInstance("MD5").digest(contentSignature.getBytes(textEncoding));
                StringBuilder shab = new StringBuilder();
                for (byte b : sha) {
                    shab.append(Integer.toHexString(b & 0xFF));
                }
                String hash = shab.toString();
                cacheFile = new File(JavaCL.userCacheDir, hash);
                if (cacheFile.exists()) {
                    Pair<Map<CLDevice, byte[]>, String> bins = CLProgram.readBinaries(Arrays.asList(this.getDevices()), contentSignature, new FileInputStream(cacheFile));
                    this.setBinaries((Map)bins.getFirst());
                    this.source = (String)bins.getSecond();
                    assert (JavaCL.log(Level.INFO, "Read binaries cache from '" + cacheFile + "'"));
                    readBinaries = true;
                }
            }
            catch (Throwable ex) {
                assert (JavaCL.log(Level.WARNING, "Failed to load cached program : " + ex.getMessage()));
                this.entity = null;
            }
        }
        if (this.entity == null) {
            this.allocate();
        }
        Runnable deleteTempFiles = null;
        if (!readBinaries) {
            try {
                deleteTempFiles = this.copyIncludesToTemporaryDirectory();
            }
            catch (IOException ex) {
                throw new CLBuildException(this, ex.toString(), Collections.EMPTY_LIST);
            }
        }
        int nDevices = this.devices.length;
        Pointer deviceIds = null;
        if (nDevices != 0) {
            deviceIds = Pointer.allocateTypedPointers(OpenCLLibrary.cl_device_id.class, (long)nDevices);
            for (int i = 0; i < nDevices; ++i) {
                deviceIds.set((long)i, this.devices[i].getEntity());
            }
        }
        int err = OpenCLLibrary.clBuildProgram((OpenCLLibrary.cl_program)this.getEntity(), (int)nDevices, (Pointer)deviceIds, (Pointer)Pointer.pointerToCString((String)this.getOptionsString()), null, null);
        Set<String> errors = this.getProgramBuildInfo(this.getEntity(), (Pointer<OpenCLLibrary.cl_device_id>)deviceIds);
        if (err != 0) {
            throw new CLBuildException(this, "Compilation failure : " + CLException.errorString(err), errors);
        }
        if (!errors.isEmpty()) {
            JavaCL.log(Level.INFO, "Build info :\n\t" + StringUtils.implode(errors, (Object)"\n\t"));
        }
        this.built = true;
        if (deleteTempFiles != null) {
            deleteTempFiles.run();
        }
        if (this.isCached() && !readBinaries) {
            JavaCL.userCacheDir.mkdirs();
            try {
                Map<CLDevice, byte[]> binaries = this.getBinaries();
                if (!binaries.isEmpty()) {
                    CLProgram.writeBinaries(this.getBinaries(), this.getSource(), contentSignature, new FileOutputStream(cacheFile));
                    assert (JavaCL.log(Level.INFO, "Wrote binaries cache to '" + cacheFile + "'"));
                }
            }
            catch (Exception ex) {
                new IOException("[JavaCL] Failed to cache program", ex).printStackTrace();
            }
        }
        return this;
    }

    @Override
    protected void clear() {
        CLException.error(OpenCLLibrary.clReleaseProgram((OpenCLLibrary.cl_program)this.getEntity()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLKernel[] createKernels() throws CLBuildException {
        CLProgram cLProgram = this;
        synchronized (cLProgram) {
            if (!this.built) {
                this.build();
            }
        }
        Pointer pCount = Pointer.allocateInt();
        int previousAttempts = 0;
        do {
        } while (CLException.failedForLackOfMemory(OpenCLLibrary.clCreateKernelsInProgram((OpenCLLibrary.cl_program)this.getEntity(), (int)0, null, (Pointer)pCount), previousAttempts++));
        int count = (Integer)pCount.get();
        Pointer kerns = Pointer.allocateTypedPointers(OpenCLLibrary.cl_kernel.class, (long)count);
        previousAttempts = 0;
        do {
        } while (CLException.failedForLackOfMemory(OpenCLLibrary.clCreateKernelsInProgram((OpenCLLibrary.cl_program)this.getEntity(), (int)count, (Pointer)kerns, (Pointer)pCount), previousAttempts++));
        CLKernel[] kernels = new CLKernel[count];
        for (int i = 0; i < count; ++i) {
            kernels[i] = new CLKernel(this, null, (OpenCLLibrary.cl_kernel)kerns.get((long)i));
        }
        return kernels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLKernel createKernel(String name, Object ... args) throws CLBuildException {
        OpenCLLibrary.cl_kernel kernel;
        CLProgram cLProgram = this;
        synchronized (cLProgram) {
            if (!this.built) {
                this.build();
            }
        }
        Pointer errBuff = Pointer.allocateInt();
        int previousAttempts = 0;
        do {
            kernel = OpenCLLibrary.clCreateKernel((OpenCLLibrary.cl_program)this.getEntity(), (Pointer)Pointer.pointerToCString((String)name), (Pointer)errBuff);
        } while (CLException.failedForLackOfMemory((Integer)errBuff.get(0L), previousAttempts++));
        CLKernel kn = new CLKernel(this, name, kernel);
        kn.setArgs(args);
        return kn;
    }
}

