/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLInfoGetter;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLProgram;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.CLSampler;
import com.nativelibs4java.opencl.InfoName;
import com.nativelibs4java.opencl.LocalSize;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import java.nio.Buffer;
import java.util.HashMap;
import java.util.Map;
import org.bridj.Pointer;
import org.bridj.SizeT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLKernel
extends CLAbstractEntity<OpenCLLibrary.cl_kernel> {
    protected final CLProgram program;
    protected String name;
    private static CLInfoGetter<OpenCLLibrary.cl_kernel> infos = new CLInfoGetter<OpenCLLibrary.cl_kernel>(){

        @Override
        protected int getInfo(OpenCLLibrary.cl_kernel entity, int infoTypeEnum, long size, Pointer out, Pointer<SizeT> sizeOut) {
            return OpenCLLibrary.clGetKernelInfo((OpenCLLibrary.cl_kernel)entity, (int)infoTypeEnum, (long)size, (Pointer)out, sizeOut);
        }
    };
    private volatile CLInfoGetter<OpenCLLibrary.cl_device_id> kernelInfos;
    public static final Object NULL_POINTER_KERNEL_ARGUMENT = new Object(){};
    private static final Pointer<SizeT> oneNL = Pointer.pointerToSizeT((long)1L);

    protected synchronized CLInfoGetter<OpenCLLibrary.cl_device_id> getKernelInfos() {
        if (this.kernelInfos == null) {
            this.kernelInfos = new CLInfoGetter<OpenCLLibrary.cl_device_id>(){

                @Override
                protected int getInfo(OpenCLLibrary.cl_device_id entity, int infoTypeEnum, long size, Pointer out, Pointer<SizeT> sizeOut) {
                    return OpenCLLibrary.clGetKernelWorkGroupInfo((OpenCLLibrary.cl_kernel)((OpenCLLibrary.cl_kernel)CLKernel.this.getEntity()), (OpenCLLibrary.cl_device_id)entity, (int)infoTypeEnum, (long)size, (Pointer)out, sizeOut);
                }
            };
        }
        return this.kernelInfos;
    }

    CLKernel(CLProgram program, String name, OpenCLLibrary.cl_kernel entity) {
        super(entity);
        this.program = program;
        this.name = name;
    }

    public CLProgram getProgram() {
        return this.program;
    }

    public String toString() {
        return this.getFunctionName() + " {args: " + this.getNumArgs() + "}";
    }

    public Map<CLDevice, Long> getPreferredWorkGroupSizeMultiple() {
        try {
            CLDevice[] devices = this.program.getDevices();
            HashMap<CLDevice, Long> ret = new HashMap<CLDevice, Long>(devices.length);
            for (CLDevice device : devices) {
                ret.put(device, this.getKernelInfos().getIntOrLong((OpenCLLibrary.cl_device_id)device.getEntity(), 4531));
            }
            return ret;
        }
        catch (Throwable th) {
            throw new UnsupportedOperationException("Cannot get CL_KERNEL_PREFERRED_WORK_GROUP_SIZE_MULTIPLE (OpenCL 1.1 feature).", th);
        }
    }

    public Map<CLDevice, Long> getWorkGroupSize() {
        CLDevice[] devices = this.program.getDevices();
        HashMap<CLDevice, Long> ret = new HashMap<CLDevice, Long>(devices.length);
        for (CLDevice device : devices) {
            ret.put(device, this.getKernelInfos().getIntOrLong((OpenCLLibrary.cl_device_id)device.getEntity(), 4528));
        }
        return ret;
    }

    public Map<CLDevice, long[]> getCompileWorkGroupSize() {
        CLDevice[] devices = this.program.getDevices();
        HashMap<CLDevice, long[]> ret = new HashMap<CLDevice, long[]>(devices.length);
        for (CLDevice device : devices) {
            ret.put(device, this.getKernelInfos().getNativeSizes((OpenCLLibrary.cl_device_id)device.getEntity(), 4529, 3));
        }
        return ret;
    }

    public Map<CLDevice, Long> getLocalMemSize() {
        CLDevice[] devices = this.program.getDevices();
        HashMap<CLDevice, Long> ret = new HashMap<CLDevice, Long>(devices.length);
        for (CLDevice device : devices) {
            ret.put(device, this.getKernelInfos().getIntOrLong((OpenCLLibrary.cl_device_id)device.getEntity(), 4530));
        }
        return ret;
    }

    public void setArgs(Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            this.setObjectArg(i, args[i]);
        }
    }

    public void setObjectArg(int iArg, Object arg) {
        if (arg == null) {
            throw new IllegalArgumentException("Null arguments are not accepted. Please use CLKernel.NULL_POINTER_KERNEL_ARGUMENT instead.");
        }
        if (arg == NULL_POINTER_KERNEL_ARGUMENT) {
            this.setArg(iArg, new SizeT(0L));
        } else if (arg instanceof SizeT) {
            this.setArg(iArg, (SizeT)arg);
        } else if (arg instanceof CLMem) {
            this.setArg(iArg, (CLMem)arg);
        } else if (arg instanceof CLEvent) {
            this.setArg(iArg, (CLEvent)arg);
        } else if (arg instanceof CLSampler) {
            this.setArg(iArg, (CLSampler)arg);
        } else if (arg instanceof Integer) {
            this.setArg(iArg, (Integer)arg);
        } else if (arg instanceof LocalSize) {
            this.setArg(iArg, (LocalSize)arg);
        } else if (arg instanceof Long) {
            this.setArg(iArg, (Long)arg);
        } else if (arg instanceof Short) {
            this.setArg(iArg, (Short)arg);
        } else if (arg instanceof Byte) {
            this.setArg(iArg, (Byte)arg);
        } else if (arg instanceof Float) {
            this.setArg(iArg, ((Float)arg).floatValue());
        } else if (arg instanceof Double) {
            this.setArg(iArg, (Double)arg);
        } else if (arg instanceof Boolean) {
            this.setArg(iArg, (byte)(Boolean.TRUE.equals(arg) ? 1 : 0));
        } else if (arg instanceof Pointer) {
            this.setArg(iArg, (Pointer)arg);
        } else if (arg instanceof Buffer) {
            this.setArg(iArg, Pointer.pointerToBuffer((Buffer)((Buffer)arg)));
        } else if (arg instanceof int[]) {
            this.setArg(iArg, Pointer.pointerToArray((Object)((int[])arg)));
        } else if (arg instanceof long[]) {
            this.setArg(iArg, Pointer.pointerToArray((Object)((long[])arg)));
        } else if (arg instanceof short[]) {
            this.setArg(iArg, Pointer.pointerToArray((Object)((short[])arg)));
        } else if (arg instanceof double[]) {
            this.setArg(iArg, Pointer.pointerToArray((Object)((double[])arg)));
        } else if (arg instanceof float[]) {
            this.setArg(iArg, Pointer.pointerToArray((Object)((float[])arg)));
        } else if (arg instanceof byte[]) {
            this.setArg(iArg, Pointer.pointerToArray((Object)((byte[])arg)));
        } else if (arg instanceof boolean[]) {
            this.setArg(iArg, Pointer.pointerToArray((Object)((boolean[])arg)));
        } else {
            throw new IllegalArgumentException("Cannot handle kernel arguments of type " + arg.getClass().getName() + ". Use CLKernel.get() and OpenCL4Java directly.");
        }
    }

    public void setArg(int i, LocalSize arg) {
        this.setLocalArg(i, arg.size);
    }

    public void setLocalArg(int argIndex, long localArgByteLength) {
        this.setKernelArg(argIndex, localArgByteLength, null);
    }

    public void setArg(int i, float[] arg) {
        this.setArg(i, Pointer.pointerToArray((Object)arg));
    }

    public void setArg(int i, int[] arg) {
        this.setArg(i, Pointer.pointerToArray((Object)arg));
    }

    public void setArg(int i, double[] arg) {
        this.setArg(i, Pointer.pointerToArray((Object)arg));
    }

    public void setArg(int i, long[] arg) {
        this.setArg(i, Pointer.pointerToArray((Object)arg));
    }

    public void setArg(int i, short[] arg) {
        this.setArg(i, Pointer.pointerToArray((Object)arg));
    }

    public void setArg(int i, byte[] arg) {
        this.setArg(i, Pointer.pointerToArray((Object)arg));
    }

    public void setArg(int i, char[] arg) {
        this.setArg(i, Pointer.pointerToArray((Object)arg));
    }

    public void setArg(int i, Pointer<?> ptr) {
        this.setKernelArg(i, ptr.getValidBytes(), ptr);
    }

    protected void setKernelArg(int i, long size, Pointer<?> ptr) {
        try {
            CLException.error(OpenCLLibrary.clSetKernelArg((OpenCLLibrary.cl_kernel)((OpenCLLibrary.cl_kernel)this.getEntity()), (int)i, (long)size, ptr));
        }
        catch (CLException.CLTypedException ex) {
            ex.setKernelArg(this, i);
            throw ex;
        }
    }

    public void setArg(int i, SizeT arg) {
        switch (this.getProgram().getContext().getAddressBits()) {
            case 32: {
                this.setKernelArg(i, 4L, Pointer.pointerToInts((int[])new int[]{arg.intValue()}));
                break;
            }
            case 64: {
                this.setKernelArg(i, 8L, Pointer.pointerToLongs((long[])new long[]{arg.longValue()}));
                break;
            }
            default: {
                this.setKernelArg(i, SizeT.SIZE, Pointer.pointerToSizeT((long)arg.longValue()));
            }
        }
    }

    void test(int a) {
    }

    void test(int ... as) {
    }

    void ddo() {
        this.test(12);
    }

    public void setArg(int i, int arg) {
        this.setKernelArg(i, 4L, Pointer.pointerToInts((int[])new int[]{arg}));
    }

    public void setArg(int i, long arg) {
        this.setKernelArg(i, 8L, Pointer.pointerToLongs((long[])new long[]{arg}));
    }

    public void setArg(int i, short arg) {
        this.setKernelArg(i, 2L, Pointer.pointerToShorts((short[])new short[]{arg}));
    }

    public void setArg(int i, byte arg) {
        this.setKernelArg(i, 1L, Pointer.pointerToBytes((byte[])new byte[]{arg}));
    }

    public void setArg(int i, float arg) {
        this.setKernelArg(i, 4L, Pointer.pointerToFloats((float[])new float[]{arg}));
    }

    public void setArg(int i, double arg) {
        this.setKernelArg(i, 8L, Pointer.pointerToDoubles((double[])new double[]{arg}));
    }

    public void setArg(int index, CLMem mem) {
        this.setKernelArg(index, Pointer.SIZE, Pointer.pointerToPointer(mem.getEntity()));
    }

    public void setArg(int index, CLEvent event) {
        this.setKernelArg(index, Pointer.SIZE, Pointer.pointerToPointer(event.getEntity()));
    }

    public void setArg(int index, CLSampler sampler) {
        this.setKernelArg(index, Pointer.SIZE, Pointer.pointerToPointer(sampler.getEntity()));
    }

    @Override
    protected void clear() {
        CLException.error(OpenCLLibrary.clReleaseKernel((OpenCLLibrary.cl_kernel)((OpenCLLibrary.cl_kernel)this.getEntity())));
    }

    public CLEvent enqueueTask(CLQueue queue, CLEvent ... eventsToWaitFor) {
        Pointer<OpenCLLibrary.cl_event> eventOut = CLEvent.new_event_out(eventsToWaitFor);
        Pointer<OpenCLLibrary.cl_event> evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(OpenCLLibrary.clEnqueueNDRangeKernel((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)queue.getEntity()), (OpenCLLibrary.cl_kernel)((OpenCLLibrary.cl_kernel)this.getEntity()), (int)1, null, oneNL, oneNL, (int)(evts == null ? 0 : (int)evts.getValidElements()), evts, eventOut));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    public CLEvent enqueueNDRange(CLQueue queue, int[] globalWorkSizes, int[] localWorkSizes, CLEvent ... eventsToWaitFor) {
        return this.enqueueNDRange(queue, null, globalWorkSizes, localWorkSizes, eventsToWaitFor);
    }

    public CLEvent enqueueNDRange(CLQueue queue, int[] globalWorkSizes, CLEvent ... eventsToWaitFor) {
        return this.enqueueNDRange(queue, (int[])null, globalWorkSizes, (int[])null, eventsToWaitFor);
    }

    public CLEvent enqueueNDRange(CLQueue queue, int[] globalOffsets, int[] globalWorkSizes, int[] localWorkSizes, CLEvent ... eventsToWaitFor) {
        int nDims = globalWorkSizes.length;
        if (localWorkSizes != null && localWorkSizes.length != nDims) {
            throw new IllegalArgumentException("Global and local sizes must have same dimensions, given " + globalWorkSizes.length + " vs. " + localWorkSizes.length);
        }
        Pointer<OpenCLLibrary.cl_event> eventOut = CLEvent.new_event_out(eventsToWaitFor);
        Pointer<OpenCLLibrary.cl_event> evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(OpenCLLibrary.clEnqueueNDRangeKernel((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)queue.getEntity()), (OpenCLLibrary.cl_kernel)((OpenCLLibrary.cl_kernel)this.getEntity()), (int)nDims, (Pointer)Pointer.pointerToSizeTs((int[])globalOffsets), (Pointer)Pointer.pointerToSizeTs((int[])globalWorkSizes), (Pointer)Pointer.pointerToSizeTs((int[])localWorkSizes), (int)(evts == null ? 0 : (int)evts.getValidElements()), evts, eventOut));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    @InfoName(value="CL_KERNEL_NUM_ARGS")
    public int getNumArgs() {
        int numArgs = infos.getInt((OpenCLLibrary.cl_kernel)this.getEntity(), 4497);
        return numArgs;
    }

    @InfoName(value="CL_KERNEL_FUNCTION_NAME")
    public String getFunctionName() {
        if (this.name == null) {
            this.name = infos.getString((OpenCLLibrary.cl_kernel)this.getEntity(), 4496);
        }
        return this.name;
    }
}

