/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLImageFormat;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.InfoName;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.nativelibs4java.opencl.library.cl_image_format;
import com.nativelibs4java.util.Pair;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.bridj.Pointer;
import org.bridj.SizeT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CLImage
extends CLMem {
    CLImageFormat format;

    CLImage(CLContext context, OpenCLLibrary.cl_mem entity, CLImageFormat format) {
        super(context, -1L, entity);
        this.format = format;
    }

    @InfoName(value="CL_IMAGE_FORMAT")
    public CLImageFormat getFormat() {
        if (this.format == null) {
            this.format = new CLImageFormat(new cl_image_format(infos.getMemory(this.getEntity(), 4368)));
        }
        return this.format;
    }

    @InfoName(value="CL_IMAGE_ELEMENT_SIZE")
    public long getElementSize() {
        return infos.getIntOrLong(this.getEntity(), 4369);
    }

    protected CLEvent read(CLQueue queue, Pointer<SizeT> origin, Pointer<SizeT> region, long rowPitch, long slicePitch, Buffer out, boolean blocking, CLEvent ... eventsToWaitFor) {
        return this.read(queue, origin, region, rowPitch, slicePitch, Pointer.pointerToBuffer((Buffer)out), blocking, eventsToWaitFor);
    }

    protected CLEvent read(CLQueue queue, Pointer<SizeT> origin, Pointer<SizeT> region, long rowPitch, long slicePitch, Pointer<?> out, boolean blocking, CLEvent ... eventsToWaitFor) {
        Pointer<OpenCLLibrary.cl_event> eventOut = blocking ? null : CLEvent.new_event_out(eventsToWaitFor);
        Pointer<OpenCLLibrary.cl_event> evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(OpenCLLibrary.clEnqueueReadImage((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)queue.getEntity()), (OpenCLLibrary.cl_mem)((OpenCLLibrary.cl_mem)this.getEntity()), (int)(blocking ? 1 : 0), origin, region, (long)rowPitch, (long)slicePitch, out, (int)(evts == null ? 0 : (int)evts.getValidElements()), evts, eventOut));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    protected CLEvent write(CLQueue queue, Pointer<SizeT> origin, Pointer<SizeT> region, long rowPitch, long slicePitch, Buffer in, boolean blocking, CLEvent ... eventsToWaitFor) {
        return this.write(queue, origin, region, rowPitch, slicePitch, Pointer.pointerToBuffer((Buffer)in), blocking, eventsToWaitFor);
    }

    protected CLEvent write(CLQueue queue, Pointer<SizeT> origin, Pointer<SizeT> region, long rowPitch, long slicePitch, Pointer<?> in, boolean blocking, CLEvent ... eventsToWaitFor) {
        Pointer<OpenCLLibrary.cl_event> eventOut = blocking ? null : CLEvent.new_event_out(eventsToWaitFor);
        Pointer<OpenCLLibrary.cl_event> evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(OpenCLLibrary.clEnqueueWriteImage((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)queue.getEntity()), (OpenCLLibrary.cl_mem)((OpenCLLibrary.cl_mem)this.getEntity()), (int)(blocking ? 1 : 0), origin, region, (long)rowPitch, (long)slicePitch, in, (int)(evts == null ? 0 : (int)evts.getValidElements()), evts, eventOut));
        CLEvent evt = CLEvent.createEventFromPointer(queue, eventOut);
        if (!blocking) {
            final Pointer<?> toHold = in;
            evt.invokeUponCompletion(new Runnable(){

                public void run() {
                    toHold.order();
                }
            });
        }
        return evt;
    }

    protected Pair<ByteBuffer, CLEvent> map(CLQueue queue, CLMem.MapFlags flags, Pointer<SizeT> offset3, Pointer<SizeT> length3, Long imageRowPitch, Long imageSlicePitch, boolean blocking, CLEvent ... eventsToWaitFor) {
        Pointer<OpenCLLibrary.cl_event> eventOut = blocking ? null : CLEvent.new_event_out(eventsToWaitFor);
        Pointer pErr = Pointer.allocateInt();
        Pointer<OpenCLLibrary.cl_event> evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        Pointer p = OpenCLLibrary.clEnqueueMapImage((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)queue.getEntity()), (OpenCLLibrary.cl_mem)((OpenCLLibrary.cl_mem)this.getEntity()), (int)(blocking ? 1 : 0), (long)flags.value(), offset3, length3, (Pointer)(imageRowPitch == null ? null : Pointer.pointerToSizeT((long)imageRowPitch)), (Pointer)(imageSlicePitch == null ? null : Pointer.pointerToSizeT((long)imageSlicePitch)), (int)(evts == null ? 0 : (int)evts.getValidElements()), evts, eventOut, (Pointer)pErr);
        CLException.error((Integer)pErr.get());
        return new Pair((Object)p.getByteBuffer(this.getByteCount()), (Object)CLEvent.createEventFromPointer(queue, eventOut));
    }

    public CLEvent unmap(CLQueue queue, ByteBuffer buffer, CLEvent ... eventsToWaitFor) {
        Pointer<OpenCLLibrary.cl_event> eventOut = CLEvent.new_event_out(eventsToWaitFor);
        Pointer<OpenCLLibrary.cl_event> evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(OpenCLLibrary.clEnqueueUnmapMemObject((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)queue.getEntity()), (OpenCLLibrary.cl_mem)((OpenCLLibrary.cl_mem)this.getEntity()), (Pointer)Pointer.pointerToBuffer((Buffer)buffer), (int)(evts == null ? 0 : (int)evts.getValidElements()), evts, eventOut));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }
}

