/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLBuffer;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLImage2D;
import com.nativelibs4java.opencl.CLImage3D;
import com.nativelibs4java.opencl.CLImageFormat;
import com.nativelibs4java.opencl.CLInfoGetter;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLPlatform;
import com.nativelibs4java.opencl.CLProgram;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.CLSampler;
import com.nativelibs4java.opencl.ImageIOUtils;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.nativelibs4java.opencl.library.OpenGLContextUtils;
import com.nativelibs4java.opencl.library.cl_image_format;
import com.nativelibs4java.util.EnumValues;
import com.nativelibs4java.util.Pair;
import com.nativelibs4java.util.ValuedEnum;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.bridj.NativeObject;
import org.bridj.Platform;
import org.bridj.Pointer;
import org.bridj.PointerIO;
import org.bridj.SizeT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLContext
extends CLAbstractEntity<OpenCLLibrary.cl_context> {
    volatile Boolean cacheBinaries;
    private static CLInfoGetter<OpenCLLibrary.cl_context> infos = new CLInfoGetter<OpenCLLibrary.cl_context>(){

        @Override
        protected int getInfo(OpenCLLibrary.cl_context entity, int infoTypeEnum, long size, Pointer out, Pointer<SizeT> sizeOut) {
            return OpenCLLibrary.clGetContextInfo((OpenCLLibrary.cl_context)entity, (int)infoTypeEnum, (long)size, (Pointer)out, sizeOut);
        }
    };
    CLPlatform platform;
    protected Pointer<OpenCLLibrary.cl_device_id> deviceIds;
    private static final int GL_TEXTURE_2D = 3553;
    private static final int GL_TEXTURE_3D = 32879;
    private static final int GL_TEXTURE_CUBE_MAP_POSITIVE_X = 34069;
    private static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_X = 34070;
    private static final int GL_TEXTURE_CUBE_MAP_POSITIVE_Y = 34071;
    private static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 34072;
    private static final int GL_TEXTURE_CUBE_MAP_POSITIVE_Z = 34073;
    private static final int GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 34074;
    private static final int GL_TEXTURE_RECTANGLE = 34037;
    private volatile int addressBits = -2;

    public long getMaxMemAllocSize() {
        long min = Long.MAX_VALUE;
        for (CLDevice device : this.getDevices()) {
            long m = device.getMaxMemAllocSize();
            if (m >= min) continue;
            min = m;
        }
        return min;
    }

    public synchronized void setCacheBinaries(boolean cacheBinaries) {
        this.cacheBinaries = cacheBinaries;
    }

    public synchronized boolean getCacheBinaries() {
        if (this.cacheBinaries == null) {
            String plat;
            String prop = System.getProperty("javacl.cacheBinaries");
            String env = System.getenv("JAVACL_CACHE_BINARIES");
            this.cacheBinaries = "true".equals(prop) || "1".equals(env) ? Boolean.valueOf(true) : ("false".equals(prop) || "0".equals(env) ? Boolean.valueOf(false) : Boolean.valueOf(!"ATI Stream".equals(plat = this.getPlatform().getName()) && !"AMD Accelerated Parallel Processing".equals(plat)));
        }
        return this.cacheBinaries;
    }

    CLContext(CLPlatform platform, Pointer<OpenCLLibrary.cl_device_id> deviceIds, OpenCLLibrary.cl_context context) {
        super(context);
        this.platform = platform;
        this.deviceIds = deviceIds;
        if (this.getByteOrder() == null) {
            JavaCL.log(Level.WARNING, "The devices in this context have mismatching byte orders. This mandates the use of __attribute__((endian(host))) in kernel sources or *very* careful use of buffers to avoid facing endianness issues");
        }
    }

    public CLEvent createUserEvent() {
        try {
            Pointer pErr = Pointer.allocateInt();
            OpenCLLibrary.cl_event evt = OpenCLLibrary.clCreateUserEvent((OpenCLLibrary.cl_context)((OpenCLLibrary.cl_context)this.getEntity()), (Pointer)pErr);
            CLException.error((Integer)pErr.get());
            return CLEvent.createEvent(null, evt, true);
        }
        catch (Throwable th) {
            return null;
        }
    }

    public CLQueue createDefaultQueue(CLDevice.QueueProperties ... queueProperties) {
        return new CLDevice(this.platform, (OpenCLLibrary.cl_device_id)this.deviceIds.get(0L)).createQueue(this, queueProperties);
    }

    public CLQueue createDefaultOutOfOrderQueue() {
        return new CLDevice(this.platform, (OpenCLLibrary.cl_device_id)this.deviceIds.get(0L)).createOutOfOrderQueue(this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("CLContext(platform = ").append(this.getPlatform().getName()).append("; devices = ");
        boolean first = true;
        for (CLDevice d : this.getDevices()) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            b.append(d.getName());
        }
        b.append(")");
        return b.toString();
    }

    public CLQueue createDefaultOutOfOrderQueueIfPossible() {
        try {
            return this.createDefaultOutOfOrderQueue();
        }
        catch (Throwable th) {
            return this.createDefaultQueue(new CLDevice.QueueProperties[0]);
        }
    }

    public CLQueue createDefaultProfilingQueue() {
        return new CLDevice(this.platform, (OpenCLLibrary.cl_device_id)this.deviceIds.get(0L)).createProfilingQueue(this);
    }

    public CLImageFormat[] getSupportedImageFormats(CLMem.Flags flags, CLMem.ObjectType imageType) {
        cl_image_format ft;
        Pointer pCount = Pointer.allocateInt();
        int memFlags = (int)flags.value();
        int imTyp = (int)imageType.value();
        OpenCLLibrary.clGetSupportedImageFormats((OpenCLLibrary.cl_context)((OpenCLLibrary.cl_context)this.getEntity()), (long)memFlags, (int)imTyp, (int)0, null, (Pointer)pCount);
        int n = (Integer)pCount.get();
        if (n == 0) {
            n = 30;
        }
        Pointer formats = Pointer.allocateArray(cl_image_format.class, (long)n);
        OpenCLLibrary.clGetSupportedImageFormats((OpenCLLibrary.cl_context)((OpenCLLibrary.cl_context)this.getEntity()), (long)memFlags, (int)imTyp, (int)n, (Pointer)formats, (Pointer)null);
        ArrayList<CLImageFormat> ret = new ArrayList<CLImageFormat>(n);
        Iterator i$ = formats.iterator();
        while (i$.hasNext() && ((ft = (cl_image_format)i$.next()).image_channel_data_type() != 0 || ft.image_channel_order() != 0)) {
            ret.add(new CLImageFormat(ft));
        }
        return ret.toArray(new CLImageFormat[ret.size()]);
    }

    public CLSampler createSampler(boolean normalized_coords, CLSampler.AddressingMode addressing_mode, CLSampler.FilterMode filter_mode) {
        Pointer pErr = Pointer.allocateInt();
        OpenCLLibrary.cl_sampler sampler = OpenCLLibrary.clCreateSampler((OpenCLLibrary.cl_context)((OpenCLLibrary.cl_context)this.getEntity()), (int)(normalized_coords ? 1 : 0), (int)((int)addressing_mode.value()), (int)((int)filter_mode.value()), (Pointer)pErr);
        CLException.error((Integer)pErr.get());
        return new CLSampler(sampler);
    }

    public int getDeviceCount() {
        return infos.getOptionalFeatureInt((OpenCLLibrary.cl_context)this.getEntity(), 4227);
    }

    public synchronized CLDevice[] getDevices() {
        if (this.deviceIds == null) {
            this.deviceIds = infos.getMemory((OpenCLLibrary.cl_context)this.getEntity(), 4225).as(OpenCLLibrary.cl_device_id.class);
        }
        int n = (int)this.deviceIds.getValidElements();
        CLDevice[] devices = new CLDevice[n];
        int i = n;
        while (i-- != 0) {
            devices[i] = new CLDevice(this.platform, (OpenCLLibrary.cl_device_id)this.deviceIds.get((long)i));
        }
        return devices;
    }

    public CLProgram createProgram(String ... srcs) {
        return this.createProgram((CLDevice[])null, srcs);
    }

    public CLProgram createProgram(CLDevice[] devices, String ... srcs) {
        CLProgram program = new CLProgram(this, devices);
        for (String src : srcs) {
            program.addSource(src);
        }
        return program;
    }

    public CLProgram loadProgram(InputStream in) throws IOException {
        Pair<Map<CLDevice, byte[]>, String> binaries = CLProgram.readBinaries(Arrays.asList(this.getDevices()), null, in);
        return this.createProgram((Map)binaries.getFirst(), (String)binaries.getSecond());
    }

    public CLProgram createProgram(Map<CLDevice, byte[]> binaries, String source) {
        return new CLProgram(this, binaries, source);
    }

    @Override
    protected void clear() {
        CLException.error(OpenCLLibrary.clReleaseContext((OpenCLLibrary.cl_context)((OpenCLLibrary.cl_context)this.getEntity())));
    }

    @Deprecated
    public CLDevice guessCurrentGLDevice() {
        long[] props = CLPlatform.getContextProps(CLPlatform.getGLContextProperties(this.getPlatform()));
        Pointer propsRef = Pointer.pointerToSizeTs((long[])props);
        Pointer pCount = Pointer.allocateSizeT();
        Pointer mem = Pointer.allocatePointer();
        if (Platform.isMacOSX()) {
            CLException.error(OpenCLLibrary.clGetGLContextInfoAPPLE((OpenCLLibrary.cl_context)((OpenCLLibrary.cl_context)this.getEntity()), (Pointer)OpenGLContextUtils.CGLGetCurrentContext(), (int)8198, (long)Pointer.SIZE, (Pointer)mem, (Pointer)pCount));
        } else {
            CLException.error(OpenCLLibrary.clGetGLContextInfoKHR((Pointer)propsRef, (int)8198, (long)Pointer.SIZE, (Pointer)mem, (Pointer)pCount));
        }
        if (((SizeT)pCount.get()).intValue() != Pointer.SIZE) {
            throw new RuntimeException("Not a device : len = " + ((SizeT)pCount.get()).intValue());
        }
        Pointer p = mem.getPointer();
        if (p.equals((Object)Pointer.NULL)) {
            return null;
        }
        return new CLDevice(null, new OpenCLLibrary.cl_device_id(p));
    }

    private static <T extends CLMem> T markAsGL(T mem) {
        mem.isGL = true;
        return mem;
    }

    public CLBuffer<Byte> createBufferFromGLBuffer(CLMem.Usage usage, int openGLBufferObject) {
        OpenCLLibrary.cl_mem mem;
        Pointer pErr = Pointer.allocateInt();
        int previousAttempts = 0;
        do {
            mem = OpenCLLibrary.clCreateFromGLBuffer((OpenCLLibrary.cl_context)((OpenCLLibrary.cl_context)this.getEntity()), (long)usage.getIntFlags(), (int)openGLBufferObject, (Pointer)pErr);
        } while (CLException.failedForLackOfMemory((Integer)pErr.get(), previousAttempts++));
        return CLContext.markAsGL(new CLBuffer(this, -1L, mem, null, PointerIO.getByteInstance()));
    }

    public CLImage2D createImage2DFromGLRenderBuffer(CLMem.Usage usage, int openGLRenderBuffer) {
        OpenCLLibrary.cl_mem mem;
        Pointer pErr = Pointer.allocateInt();
        int previousAttempts = 0;
        do {
            mem = OpenCLLibrary.clCreateFromGLRenderbuffer((OpenCLLibrary.cl_context)((OpenCLLibrary.cl_context)this.getEntity()), (long)usage.getIntFlags(), (int)openGLRenderBuffer, (Pointer)pErr);
        } while (CLException.failedForLackOfMemory((Integer)pErr.get(), previousAttempts++));
        return CLContext.markAsGL(new CLImage2D(this, mem, null));
    }

    public CLImage2D createImage2DFromGLTexture2D(CLMem.Usage usage, GLTextureTarget textureTarget, int texture, int mipLevel) {
        OpenCLLibrary.cl_mem mem;
        Pointer pErr = Pointer.allocateInt();
        int previousAttempts = 0;
        do {
            mem = OpenCLLibrary.clCreateFromGLTexture2D((OpenCLLibrary.cl_context)((OpenCLLibrary.cl_context)this.getEntity()), (long)usage.getIntFlags(), (int)((int)textureTarget.value()), (int)mipLevel, (int)texture, (Pointer)pErr);
        } while (CLException.failedForLackOfMemory((Integer)pErr.get(), previousAttempts++));
        return CLContext.markAsGL(new CLImage2D(this, mem, null));
    }

    public CLPlatform getPlatform() {
        return this.platform;
    }

    public CLImage3D createImage3DFromGLTexture3D(CLMem.Usage usage, int texture, int mipLevel) {
        OpenCLLibrary.cl_mem mem;
        Pointer pErr = Pointer.allocateInt();
        int previousAttempts = 0;
        do {
            mem = OpenCLLibrary.clCreateFromGLTexture3D((OpenCLLibrary.cl_context)((OpenCLLibrary.cl_context)this.getEntity()), (long)usage.getIntFlags(), (int)32879, (int)mipLevel, (int)texture, (Pointer)pErr);
        } while (CLException.failedForLackOfMemory((Integer)pErr.get(), previousAttempts++));
        return CLContext.markAsGL(new CLImage3D(this, mem, null));
    }

    public CLImage2D createImage2D(CLMem.Usage usage, Image image, boolean allowUnoptimizingDirectRead) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        ImageIOUtils.ImageInfo<?> info = ImageIOUtils.getImageInfo(image);
        return this.createImage2D(usage, info.clImageFormat, width, height, 0L, info.dataGetter.getData(image, null, true, allowUnoptimizingDirectRead, this.getByteOrder()), true);
    }

    public CLImage2D createImage2D(CLMem.Usage usage, CLImageFormat format, long width, long height, long rowPitch, Buffer buffer, boolean copy) {
        OpenCLLibrary.cl_mem mem;
        long memFlags = usage.getIntFlags();
        if (buffer != null) {
            memFlags |= copy ? 32L : 8L;
        }
        Pointer pErr = Pointer.allocateInt();
        int previousAttempts = 0;
        do {
            mem = OpenCLLibrary.clCreateImage2D((OpenCLLibrary.cl_context)((OpenCLLibrary.cl_context)this.getEntity()), (long)memFlags, (Pointer)Pointer.pointerTo((NativeObject)format.to_cl_image_format()), (long)width, (long)height, (long)rowPitch, (Pointer)(buffer == null ? null : Pointer.pointerToBuffer((Buffer)buffer)), (Pointer)pErr);
        } while (CLException.failedForLackOfMemory((Integer)pErr.get(), previousAttempts++));
        return new CLImage2D(this, mem, format);
    }

    public CLImage2D createImage2D(CLMem.Usage usage, CLImageFormat format, long width, long height, long rowPitch) {
        return this.createImage2D(usage, format, width, height, rowPitch, null, false);
    }

    public CLImage2D createImage2D(CLMem.Usage usage, CLImageFormat format, long width, long height) {
        return this.createImage2D(usage, format, width, height, 0L, null, false);
    }

    public CLImage3D createImage3D(CLMem.Usage usage, CLImageFormat format, long width, long height, long depth, long rowPitch, long slicePitch, Buffer buffer, boolean copy) {
        OpenCLLibrary.cl_mem mem;
        long memFlags = usage.getIntFlags();
        if (buffer != null) {
            memFlags |= copy ? 32L : 8L;
        }
        Pointer pErr = Pointer.allocateInt();
        int previousAttempts = 0;
        do {
            mem = OpenCLLibrary.clCreateImage3D((OpenCLLibrary.cl_context)((OpenCLLibrary.cl_context)this.getEntity()), (long)memFlags, (Pointer)Pointer.pointerTo((NativeObject)format.to_cl_image_format()), (long)width, (long)height, (long)depth, (long)rowPitch, (long)slicePitch, (Pointer)(buffer == null ? null : Pointer.pointerToBuffer((Buffer)buffer)), (Pointer)pErr);
        } while (CLException.failedForLackOfMemory((Integer)pErr.get(), previousAttempts++));
        return new CLImage3D(this, mem, format);
    }

    public CLImage3D createImage3D(CLMem.Usage usage, CLImageFormat format, long width, long height, long depth, long rowPitch, long slicePitch) {
        return this.createImage3D(usage, format, width, height, depth, rowPitch, slicePitch, null, false);
    }

    public CLImage3D createImage3D(CLMem.Usage usage, CLImageFormat format, long width, long height, long depth) {
        return this.createImage3D(usage, format, width, height, depth, 0L, 0L, null, false);
    }

    public CLBuffer<Integer> createIntBuffer(CLMem.Usage kind, IntBuffer data, boolean copy) {
        return this.createBuffer(kind, Pointer.pointerToInts((IntBuffer)data), copy);
    }

    public CLBuffer<Integer> createIntBuffer(CLMem.Usage kind, Pointer<Integer> data) {
        return this.createIntBuffer(kind, data, true);
    }

    public CLBuffer<Integer> createIntBuffer(CLMem.Usage kind, Pointer<Integer> data, boolean copy) {
        return this.createBuffer(kind, data, copy);
    }

    public CLBuffer<Integer> createIntBuffer(CLMem.Usage kind, long elementCount) {
        return this.createBuffer(kind, Integer.class, elementCount);
    }

    public CLBuffer<Long> createLongBuffer(CLMem.Usage kind, LongBuffer data, boolean copy) {
        return this.createBuffer(kind, Pointer.pointerToLongs((LongBuffer)data), copy);
    }

    public CLBuffer<Long> createLongBuffer(CLMem.Usage kind, Pointer<Long> data) {
        return this.createLongBuffer(kind, data, true);
    }

    public CLBuffer<Long> createLongBuffer(CLMem.Usage kind, Pointer<Long> data, boolean copy) {
        return this.createBuffer(kind, data, copy);
    }

    public CLBuffer<Long> createLongBuffer(CLMem.Usage kind, long elementCount) {
        return this.createBuffer(kind, Long.class, elementCount);
    }

    public CLBuffer<Short> createShortBuffer(CLMem.Usage kind, ShortBuffer data, boolean copy) {
        return this.createBuffer(kind, Pointer.pointerToShorts((ShortBuffer)data), copy);
    }

    public CLBuffer<Short> createShortBuffer(CLMem.Usage kind, Pointer<Short> data) {
        return this.createShortBuffer(kind, data, true);
    }

    public CLBuffer<Short> createShortBuffer(CLMem.Usage kind, Pointer<Short> data, boolean copy) {
        return this.createBuffer(kind, data, copy);
    }

    public CLBuffer<Short> createShortBuffer(CLMem.Usage kind, long elementCount) {
        return this.createBuffer(kind, Short.class, elementCount);
    }

    public CLBuffer<Byte> createByteBuffer(CLMem.Usage kind, Buffer data, boolean copy) {
        return this.createBuffer(kind, Pointer.pointerToBuffer((Buffer)data).as(Byte.class), copy);
    }

    public CLBuffer<Byte> createByteBuffer(CLMem.Usage kind, Pointer<Byte> data) {
        return this.createByteBuffer(kind, data, true);
    }

    public CLBuffer<Byte> createByteBuffer(CLMem.Usage kind, Pointer<Byte> data, boolean copy) {
        return this.createBuffer(kind, data, copy);
    }

    public CLBuffer<Byte> createByteBuffer(CLMem.Usage kind, long elementCount) {
        return this.createBuffer(kind, Byte.class, elementCount);
    }

    public CLBuffer<Character> createCharBuffer(CLMem.Usage kind, CharBuffer data, boolean copy) {
        return this.createBuffer(kind, Pointer.pointerToChars((CharBuffer)data), copy);
    }

    public CLBuffer<Character> createCharBuffer(CLMem.Usage kind, Pointer<Character> data) {
        return this.createCharBuffer(kind, data, true);
    }

    public CLBuffer<Character> createCharBuffer(CLMem.Usage kind, Pointer<Character> data, boolean copy) {
        return this.createBuffer(kind, data, copy);
    }

    public CLBuffer<Character> createCharBuffer(CLMem.Usage kind, long elementCount) {
        return this.createBuffer(kind, Character.class, elementCount);
    }

    public CLBuffer<Float> createFloatBuffer(CLMem.Usage kind, FloatBuffer data, boolean copy) {
        return this.createBuffer(kind, Pointer.pointerToFloats((FloatBuffer)data), copy);
    }

    public CLBuffer<Float> createFloatBuffer(CLMem.Usage kind, Pointer<Float> data) {
        return this.createFloatBuffer(kind, data, true);
    }

    public CLBuffer<Float> createFloatBuffer(CLMem.Usage kind, Pointer<Float> data, boolean copy) {
        return this.createBuffer(kind, data, copy);
    }

    public CLBuffer<Float> createFloatBuffer(CLMem.Usage kind, long elementCount) {
        return this.createBuffer(kind, Float.class, elementCount);
    }

    public CLBuffer<Double> createDoubleBuffer(CLMem.Usage kind, DoubleBuffer data, boolean copy) {
        return this.createBuffer(kind, Pointer.pointerToDoubles((DoubleBuffer)data), copy);
    }

    public CLBuffer<Double> createDoubleBuffer(CLMem.Usage kind, Pointer<Double> data) {
        return this.createDoubleBuffer(kind, data, true);
    }

    public CLBuffer<Double> createDoubleBuffer(CLMem.Usage kind, Pointer<Double> data, boolean copy) {
        return this.createBuffer(kind, data, copy);
    }

    public CLBuffer<Double> createDoubleBuffer(CLMem.Usage kind, long elementCount) {
        return this.createBuffer(kind, Double.class, elementCount);
    }

    public <T> CLBuffer<T> createBuffer(CLMem.Usage kind, Pointer<T> data) {
        return this.createBuffer(kind, data, true);
    }

    public <T> CLBuffer<T> createBuffer(CLMem.Usage kind, Pointer<T> data, boolean copy) {
        return this.createBuffer(data.getIO(), data, data.getValidBytes(), kind.getIntFlags() | (copy ? 32 : 8), copy);
    }

    public <T> CLBuffer<T> createBuffer(CLMem.Usage kind, Class<T> elementClass, long elementCount) {
        PointerIO io = PointerIO.getInstance(elementClass);
        if (io == null) {
            throw new IllegalArgumentException("Unknown target type : " + elementClass.getName());
        }
        return this.createBuffer(kind, io, elementCount);
    }

    @Deprecated
    public <T> CLBuffer<T> createBuffer(CLMem.Usage kind, PointerIO<T> io, long elementCount) {
        return this.createBuffer(io, null, io.getTargetSize() * elementCount, kind.getIntFlags(), false);
    }

    private <T> CLBuffer<T> createBuffer(PointerIO<T> io, Pointer<T> data, long byteCount, int CLBufferFlags, boolean retainBufferReference) {
        OpenCLLibrary.cl_mem mem;
        if (byteCount <= 0L) {
            throw new IllegalArgumentException("Buffer size must be greater than zero (asked for size " + byteCount + ")");
        }
        if (byteCount > this.getMaxMemAllocSize()) {
            throw new OutOfMemoryError("Requested size for buffer allocation is more than the maximum for this context : " + byteCount + " > " + this.getMaxMemAllocSize());
        }
        if (data != null) {
            ByteOrder contextOrder = this.getByteOrder();
            ByteOrder dataOrder = data.order();
            if (contextOrder != null && !dataOrder.equals(contextOrder)) {
                throw new IllegalArgumentException("Byte order of this context is " + contextOrder + ", but was given pointer to data with order " + dataOrder + ". Please create a pointer with correct byte order (Pointer.order(CLContext.getKernelsDefaultByteOrder())).");
            }
        }
        Pointer pErr = Pointer.allocateInt();
        int previousAttempts = 0;
        do {
            mem = OpenCLLibrary.clCreateBuffer((OpenCLLibrary.cl_context)((OpenCLLibrary.cl_context)this.getEntity()), (long)CLBufferFlags, (long)byteCount, data, (Pointer)pErr);
        } while (CLException.failedForLackOfMemory((Integer)pErr.get(), previousAttempts++));
        return new CLBuffer<T>(this, byteCount, mem, retainBufferReference ? data : null, io);
    }

    @Deprecated
    public ByteOrder getKernelsDefaultByteOrder() {
        return this.getByteOrder();
    }

    public ByteOrder getByteOrder() {
        ByteOrder order = null;
        for (CLDevice device : this.getDevices()) {
            ByteOrder devOrder = device.getByteOrder();
            if (order != null && devOrder != order) {
                return null;
            }
            order = devOrder;
        }
        return order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAddressBits() {
        if (this.addressBits == -2) {
            CLContext cLContext = this;
            synchronized (cLContext) {
                if (this.addressBits == -2) {
                    for (CLDevice device : this.getDevices()) {
                        int bits = device.getAddressBits();
                        if (this.addressBits != -2 && bits != this.addressBits) {
                            this.addressBits = -1;
                            break;
                        }
                        this.addressBits = bits;
                    }
                }
            }
        }
        return this.addressBits;
    }

    public boolean isDoubleSupported() {
        for (CLDevice device : this.getDevices()) {
            if (device.isDoubleSupported()) continue;
            return false;
        }
        return true;
    }

    public boolean isHalfSupported() {
        for (CLDevice device : this.getDevices()) {
            if (device.isHalfSupported()) continue;
            return false;
        }
        return true;
    }

    public boolean isByteAddressableStoreSupported() {
        for (CLDevice device : this.getDevices()) {
            if (device.isByteAddressableStoreSupported()) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GLTextureTarget implements ValuedEnum
    {
        Texture2D(3553L),
        CubeMapPositiveX(34069L),
        CubeMapNegativeX(34070L),
        CubeMapPositiveY(34071L),
        CubeMapNegativeY(34072L),
        CubeMapPositiveZ(34073L),
        CubeMapNegativeZ(34074L),
        Rectangle(34037L);

        long value;

        private GLTextureTarget(long value) {
            this.value = value;
        }

        public long value() {
            return this.value;
        }

        public static GLTextureTarget getEnum(int v) {
            return (GLTextureTarget)EnumValues.getEnum((long)v, GLTextureTarget.class);
        }
    }
}

