/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.nativelibs4java.opencl.library.cl_buffer_region;
import com.nativelibs4java.util.NIOUtils;
import com.nativelibs4java.util.Pair;
import java.lang.reflect.Type;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.bridj.PointerIO;
import org.bridj.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLBuffer<T>
extends CLMem {
    final Object owner;
    final PointerIO<T> io;

    CLBuffer(CLContext context, long byteCount, OpenCLLibrary.cl_mem entity, Object owner, PointerIO<T> io) {
        super(context, byteCount, entity);
        this.owner = owner;
        this.io = io;
    }

    public Class<T> getElementClass() {
        return Utils.getClass((Type)this.io.getTargetType());
    }

    public int getElementSize() {
        return (int)this.io.getTargetSize();
    }

    public long getElementCount() {
        return this.getByteCount() / (long)this.getElementSize();
    }

    public Pointer<T> map(CLQueue queue, CLMem.MapFlags flags, CLEvent ... eventsToWaitFor) throws CLException.MapFailure {
        return (Pointer)this.map(queue, flags, 0L, this.getElementCount(), true, eventsToWaitFor).getFirst();
    }

    public Pointer<T> map(CLQueue queue, CLMem.MapFlags flags, long offset, long length, CLEvent ... eventsToWaitFor) throws CLException.MapFailure {
        return (Pointer)this.map(queue, flags, offset, length, true, eventsToWaitFor).getFirst();
    }

    public Pair<Pointer<T>, CLEvent> mapLater(CLQueue queue, CLMem.MapFlags flags, CLEvent ... eventsToWaitFor) throws CLException.MapFailure {
        return this.map(queue, flags, 0L, this.getElementCount(), false, eventsToWaitFor);
    }

    public Pair<Pointer<T>, CLEvent> mapLater(CLQueue queue, CLMem.MapFlags flags, long offset, long length, CLEvent ... eventsToWaitFor) throws CLException.MapFailure {
        return this.map(queue, flags, offset, length, false, eventsToWaitFor);
    }

    public Pointer<T> read(CLQueue queue, CLEvent ... eventsToWaitFor) {
        Pointer out = Pointer.allocateArray(this.io, (long)this.getElementCount()).order(queue.getDevice().getKernelsDefaultByteOrder());
        this.read(queue, out, true, eventsToWaitFor);
        return out;
    }

    public Pointer<T> read(CLQueue queue, long offset, long length, CLEvent ... eventsToWaitFor) {
        Pointer out = Pointer.allocateArray(this.io, (long)this.getElementCount()).order(queue.getDevice().getKernelsDefaultByteOrder());
        this.read(queue, offset, length, out, true, eventsToWaitFor);
        return out;
    }

    protected void checkBounds(long offset, long length) {
        if (offset + length * (long)this.getElementSize() > this.getByteCount()) {
            throw new IndexOutOfBoundsException("Trying to map a region of memory object outside allocated range");
        }
    }

    public CLBuffer<T> createSubBuffer(CLMem.Usage usage, long offset, long length) {
        try {
            int s = this.getElementSize();
            cl_buffer_region region = new cl_buffer_region().origin((long)s * offset).size((long)s * length);
            Pointer pErr = Pointer.allocateInt();
            OpenCLLibrary.cl_mem mem = OpenCLLibrary.clCreateSubBuffer((OpenCLLibrary.cl_mem)((OpenCLLibrary.cl_mem)this.getEntity()), (long)usage.getIntFlags(), (int)4640, (Pointer)Pointer.pointerTo((NativeObject)region), (Pointer)pErr);
            CLException.error((Integer)pErr.get());
            return mem == null ? null : new CLBuffer<T>(this.context, length * (long)s, mem, null, this.io);
        }
        catch (Throwable th) {
            throw new UnsupportedOperationException("Cannot create sub-buffer (OpenCL 1.1 feature).", th);
        }
    }

    public CLEvent copyTo(CLQueue queue, CLMem destination, CLEvent ... eventsToWaitFor) {
        return this.copyTo(queue, 0L, this.getElementCount(), destination, 0L, eventsToWaitFor);
    }

    public CLEvent copyTo(CLQueue queue, long srcOffset, long length, CLMem destination, long destOffset, CLEvent ... eventsToWaitFor) {
        Pointer<OpenCLLibrary.cl_event> eventOut = CLEvent.new_event_out(eventsToWaitFor);
        long byteCount = this.getByteCount();
        long destByteCount = destination.getByteCount();
        long eltSize = this.getElementSize();
        long actualSrcOffset = srcOffset * eltSize;
        long actualDestOffset = destOffset * eltSize;
        long actualLength = length * eltSize;
        if (actualSrcOffset < 0L || actualSrcOffset >= byteCount || actualSrcOffset + actualLength > byteCount || actualDestOffset < 0L || actualDestOffset >= destByteCount || actualDestOffset + actualLength > destByteCount) {
            throw new IndexOutOfBoundsException("Invalid copy parameters : srcOffset = " + srcOffset + ", destOffset = " + destOffset + ", length = " + length + " (element size = " + eltSize + ", source byte count = " + byteCount + ", destination byte count = " + destByteCount + ")");
        }
        Pointer<OpenCLLibrary.cl_event> evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(OpenCLLibrary.clEnqueueCopyBuffer((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)queue.getEntity()), (OpenCLLibrary.cl_mem)((OpenCLLibrary.cl_mem)this.getEntity()), (OpenCLLibrary.cl_mem)((OpenCLLibrary.cl_mem)destination.getEntity()), (long)actualSrcOffset, (long)actualDestOffset, (long)actualLength, (int)(evts == null ? 0 : (int)evts.getValidElements()), evts, eventOut));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    protected Pair<Pointer<T>, CLEvent> map(CLQueue queue, CLMem.MapFlags flags, long offset, long length, boolean blocking, CLEvent ... eventsToWaitFor) {
        this.checkBounds(offset, length);
        Pointer<OpenCLLibrary.cl_event> eventOut = blocking ? null : CLEvent.new_event_out(eventsToWaitFor);
        Pointer pErr = Pointer.allocateInt();
        Pointer<OpenCLLibrary.cl_event> evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        Pointer p = OpenCLLibrary.clEnqueueMapBuffer((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)queue.getEntity()), (OpenCLLibrary.cl_mem)((OpenCLLibrary.cl_mem)this.getEntity()), (int)(blocking ? 1 : 0), (long)flags.value(), (long)(offset * (long)this.getElementSize()), (long)(length * (long)this.getElementSize()), (int)(evts == null ? 0 : (int)evts.getValidElements()), evts, eventOut, (Pointer)pErr);
        CLException.error((Integer)pErr.get());
        return new Pair((Object)p.as(this.io).validElements(length).order(queue.getDevice().getKernelsDefaultByteOrder()), (Object)CLEvent.createEventFromPointer(queue, eventOut));
    }

    public CLEvent unmap(CLQueue queue, Pointer<T> buffer, CLEvent ... eventsToWaitFor) {
        Pointer<OpenCLLibrary.cl_event> eventOut = CLEvent.new_event_out(eventsToWaitFor);
        Pointer<OpenCLLibrary.cl_event> evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(OpenCLLibrary.clEnqueueUnmapMemObject((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)queue.getEntity()), (OpenCLLibrary.cl_mem)((OpenCLLibrary.cl_mem)this.getEntity()), buffer, (int)(evts == null ? 0 : (int)evts.getValidElements()), evts, eventOut));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    @Deprecated
    public CLEvent read(CLQueue queue, Buffer out, boolean blocking, CLEvent ... eventsToWaitFor) {
        return this.read(queue, 0L, -1L, out, blocking, eventsToWaitFor);
    }

    public CLEvent read(CLQueue queue, Pointer<T> out, boolean blocking, CLEvent ... eventsToWaitFor) {
        return this.read(queue, 0L, -1L, out, blocking, eventsToWaitFor);
    }

    @Deprecated
    public CLEvent read(CLQueue queue, long offset, long length, Buffer out, boolean blocking, CLEvent ... eventsToWaitFor) {
        if (out == null) {
            throw new IllegalArgumentException("Null output buffer !");
        }
        if (out.isReadOnly()) {
            throw new IllegalArgumentException("Output buffer for read operation is read-only !");
        }
        boolean indirect = !out.isDirect();
        Pointer ptr = null;
        if (indirect) {
            ptr = Pointer.allocateArray(this.io, (long)length).order(queue.getDevice().getKernelsDefaultByteOrder());
            blocking = true;
        } else {
            ptr = Pointer.pointerToBuffer((Buffer)out);
        }
        CLEvent ret = this.read(queue, offset, length, ptr, blocking, eventsToWaitFor);
        if (indirect) {
            NIOUtils.put((Buffer)ptr.getBuffer(), (Buffer)out);
        }
        return ret;
    }

    public CLEvent read(CLQueue queue, long offset, long length, Pointer<T> out, boolean blocking, CLEvent ... eventsToWaitFor) {
        if (out == null) {
            throw new IllegalArgumentException("Null output pointer !");
        }
        if (length < 0L) {
            long s;
            if (this.isGL) {
                length = out.getValidElements();
            }
            if (length < 0L && (length = this.getElementCount()) > (s = out.getValidElements()) && s >= 0L) {
                length = s;
            }
        }
        Pointer<OpenCLLibrary.cl_event> eventOut = blocking ? null : CLEvent.new_event_out(eventsToWaitFor);
        Pointer<OpenCLLibrary.cl_event> evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(OpenCLLibrary.clEnqueueReadBuffer((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)queue.getEntity()), (OpenCLLibrary.cl_mem)((OpenCLLibrary.cl_mem)this.getEntity()), (int)(blocking ? 1 : 0), (long)(offset * (long)this.getElementSize()), (long)(length * (long)this.getElementSize()), out, (int)(evts == null ? 0 : (int)evts.getValidElements()), evts, eventOut));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    @Deprecated
    public CLEvent write(CLQueue queue, Buffer in, boolean blocking, CLEvent ... eventsToWaitFor) {
        return this.write(queue, 0L, -1L, in, blocking, eventsToWaitFor);
    }

    public CLEvent write(CLQueue queue, Pointer<T> in, boolean blocking, CLEvent ... eventsToWaitFor) {
        return this.write(queue, 0L, -1L, in, blocking, eventsToWaitFor);
    }

    @Deprecated
    public CLEvent write(CLQueue queue, long offset, long length, Buffer in, boolean blocking, CLEvent ... eventsToWaitFor) {
        if (in == null) {
            throw new IllegalArgumentException("Null input buffer !");
        }
        boolean indirect = !in.isDirect();
        Pointer ptr = null;
        if (indirect) {
            ptr = Pointer.allocateArray(this.io, (long)length).order(queue.getDevice().getKernelsDefaultByteOrder());
            ptr.setValues(in);
            blocking = true;
        } else {
            ptr = Pointer.pointerToBuffer((Buffer)in);
        }
        return this.write(queue, offset, length, ptr, blocking, eventsToWaitFor);
    }

    public CLEvent write(CLQueue queue, long offset, long length, Pointer<T> in, boolean blocking, CLEvent ... eventsToWaitFor) {
        if (length == 0L) {
            return null;
        }
        if (in == null) {
            throw new IllegalArgumentException("Null input pointer !");
        }
        if (length < 0L) {
            long s;
            if (this.isGL) {
                length = in.getValidElements();
            }
            if (length < 0L && (length = this.getElementCount()) > (s = in.getValidElements()) && s >= 0L) {
                length = s;
            }
        }
        Pointer<OpenCLLibrary.cl_event> eventOut = blocking ? null : CLEvent.new_event_out(eventsToWaitFor);
        Pointer<OpenCLLibrary.cl_event> evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(OpenCLLibrary.clEnqueueWriteBuffer((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)queue.getEntity()), (OpenCLLibrary.cl_mem)((OpenCLLibrary.cl_mem)this.getEntity()), (int)(blocking ? 1 : 0), (long)(offset * (long)this.getElementSize()), (long)(length * (long)this.getElementSize()), in, (int)(evts == null ? 0 : (int)evts.getValidElements()), evts, eventOut));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    public CLEvent writeBytes(CLQueue queue, long offset, long length, ByteBuffer in, boolean blocking, CLEvent ... eventsToWaitFor) {
        return this.writeBytes(queue, offset, length, Pointer.pointerToBuffer((Buffer)in), blocking, eventsToWaitFor);
    }

    public CLEvent writeBytes(CLQueue queue, long offset, long length, Pointer<?> in, boolean blocking, CLEvent ... eventsToWaitFor) {
        if (in == null) {
            throw new IllegalArgumentException("Null input pointer !");
        }
        Pointer<OpenCLLibrary.cl_event> eventOut = blocking ? null : CLEvent.new_event_out(eventsToWaitFor);
        Pointer<OpenCLLibrary.cl_event> evts = CLEvent.to_cl_event_array(eventsToWaitFor);
        CLException.error(OpenCLLibrary.clEnqueueWriteBuffer((OpenCLLibrary.cl_command_queue)((OpenCLLibrary.cl_command_queue)queue.getEntity()), (OpenCLLibrary.cl_mem)((OpenCLLibrary.cl_mem)this.getEntity()), (int)(blocking ? 1 : 0), (long)offset, (long)length, in, (int)(evts == null ? 0 : (int)evts.getValidElements()), evts, eventOut));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    private <T extends CLMem> T copyGLMark(T mem) {
        mem.isGL = this.isGL;
        return mem;
    }

    public CLBuffer<T> emptyClone(CLMem.Usage usage) {
        return this.getContext().createBuffer(usage, this.io, this.getElementCount());
    }

    public CLBuffer<Integer> asCLIntBuffer() {
        return this.as(Integer.class);
    }

    public CLBuffer<Long> asCLLongBuffer() {
        return this.as(Long.class);
    }

    public CLBuffer<Short> asCLShortBuffer() {
        return this.as(Short.class);
    }

    public CLBuffer<Byte> asCLByteBuffer() {
        return this.as(Byte.class);
    }

    public CLBuffer<Character> asCLCharBuffer() {
        return this.as(Character.class);
    }

    public CLBuffer<Float> asCLFloatBuffer() {
        return this.as(Float.class);
    }

    public CLBuffer<Double> asCLDoubleBuffer() {
        return this.as(Double.class);
    }

    public <T> CLBuffer<T> as(Class<T> newTargetType) {
        OpenCLLibrary.cl_mem mem = (OpenCLLibrary.cl_mem)this.getEntity();
        OpenCLLibrary.clRetainMemObject((OpenCLLibrary.cl_mem)mem);
        PointerIO newIo = PointerIO.getInstance(newTargetType);
        return this.copyGLMark(new CLBuffer<T>(this.context, this.getByteCount(), mem, this.owner, newIo));
    }
}

