package edu.sc.seis.simple;

import java.util.Properties;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.varia.NullAppender;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkDCOperations;
import edu.iris.Fissures.IfNetwork.NetworkFinder;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.model.AllVTFactory;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import edu.sc.seis.fissuresUtil.sac.FissuresToSac;
import edu.sc.seis.fissuresUtil.sac.SacPoleZero;

public class SacPoleZeroClient {

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure(new NullAppender());
        logger.addAppender(new ConsoleAppender(new SimpleLayout()));
        // Initialize the ORB. This must be done before the corba system can be
        // used.
        org.omg.CORBA_2_3.ORB orb = (org.omg.CORBA_2_3.ORB)org.omg.CORBA.ORB.init(new String[] {},
                                                                                  new Properties());
        // Registers the FISSURES classes with the ORB
        new AllVTFactory().register(orb);
        // Pick a name server to get FISSURES servers.
        FissuresNamingService namingService = new FissuresNamingService(orb);
        namingService.setNameServiceCorbaLoc("corbaloc:iiop:dmc.iris.washington.edu:6371/NameService");
        NetworkDCOperations netDC = namingService.getNetworkDC("edu/iris/dmc",
                                                               "IRIS_NetworkDC");
        NetworkFinder netFinder = netDC.a_finder();
        NetworkAccess net = netFinder.retrieve_by_code("II")[0];
        Station[] stations = net.retrieve_stations();
        logger.info("Got " + stations.length + " stations");
        Channel[] channels = net.retrieve_for_station(stations[0].get_id());
        logger.info("Got " + channels.length + " channels from "
                + stations[0].get_code());
        Instrumentation inst = net.retrieve_instrumentation(channels[0].get_id(),
                                                            channels[0].effective_time.start_time);
        SacPoleZero sac = FissuresToSac.getPoleZero(inst.the_response);
        logger.info("Channel: " + ChannelIdUtil.toString(channels[0].get_id()));
        logger.info("PoleZero:\n"+sac.toString());
    }

    private static final org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(SacPoleZeroClient.class);
}
