package edu.sc.seis.simple;

import java.util.Properties;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.varia.NullAppender;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkDCOperations;
import edu.iris.Fissures.IfNetwork.NetworkFinder;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.model.AllVTFactory;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;

public class NetworkClient {

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure(new NullAppender());
        logger.addAppender(new ConsoleAppender(new SimpleLayout()));
        // Initialize the ORB. This must be done before the corba system can be
        // used.
        org.omg.CORBA_2_3.ORB orb = (org.omg.CORBA_2_3.ORB)org.omg.CORBA.ORB.init(new String[] {},
                                                                                  new Properties());
        // Registers the FISSURES classes with the ORB
        new AllVTFactory().register(orb);
        // Pick a name server to get FISSURES servers.
        FissuresNamingService namingService = new FissuresNamingService(orb);
        namingService.setNameServiceCorbaLoc("corbaloc:iiop:dmc.iris.washington.edu:6371/NameService");
        NetworkDCOperations netDC = namingService.getNetworkDC("edu/iris/dmc",
                                                               "IRIS_NetworkDC");
        NetworkFinder netFinder = netDC.a_finder();
        String networkCode = "II";
        NetworkAccess net = netFinder.retrieve_by_code(networkCode)[0];
        Station[] stations = net.retrieve_stations();
        logger.info("Network "+networkCode+" has "+stations.length+" stations");
        logger.info(stations[0].get_code()+", "+stations[0].name+" is located at "+stations[0].my_location.latitude+", "+stations[0].my_location.longitude);
        Channel[] channels = net.retrieve_for_station(stations[0].get_id());
        logger.info("Station "+stations[0].get_id().network_id.network_code+"."+stations[0].get_code()+" has " + channels.length + " channels.");
    }

    private static Logger logger = Logger.getLogger(NetworkClient.class);
}
