package edu.sc.seis.simple;

import java.util.Properties;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.varia.NullAppender;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.IfEvent.EventAccess;
import edu.iris.Fissures.IfEvent.EventDCOperations;
import edu.iris.Fissures.IfEvent.EventFinder;
import edu.iris.Fissures.IfEvent.EventSeqIterHolder;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.model.AllVTFactory;
import edu.iris.Fissures.model.GlobalAreaImpl;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;

public class EventClient {

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure(new NullAppender());
        logger.addAppender(new ConsoleAppender(new SimpleLayout()));
        // Initialize the ORB. This must be done before the corba system can be
        // used.
        org.omg.CORBA_2_3.ORB orb = (org.omg.CORBA_2_3.ORB)org.omg.CORBA.ORB.init(new String[] {},
                                                                                  new Properties());
        // Registers the FISSURES classes with the ORB
        new AllVTFactory().register(orb);
        // Pick a name server to get FISSURES servers.
        FissuresNamingService namingService = new FissuresNamingService(orb);
        namingService.setNameServiceCorbaLoc("corbaloc:iiop:dmc.iris.washington.edu:6371/NameService");
        EventDCOperations eventDC = namingService.getEventDC("edu/iris/dmc",
                                                             "IRIS_EventDC");
        EventFinder finder = eventDC.a_finder();
        EventSeqIterHolder iter = new EventSeqIterHolder();
        MicroSecondDate now = ClockUtil.now();
        MicroSecondDate oneWeekAgo = now.subtract(new TimeInterval(7,
                                                                   UnitImpl.DAY));
        TimeRange oneWeek = new TimeRange(oneWeekAgo.getFissuresTime(),
                                          now.getFissuresTime());
        String[] magTypes = {};// Empty array accepts any type
        String[] catalogs = {};// Empty array accepts any catalog
        String[] contributors = {};// Empty array accepts any contributor
        EventAccess[] events = finder.query_events(new GlobalAreaImpl(),
                                                   new QuantityImpl(0,//min depth
                                                                    UnitImpl.KILOMETER),
                                                   new QuantityImpl(1000,//max depth
                                                                    UnitImpl.KILOMETER),
                                                   oneWeek,
                                                   magTypes,
                                                   5.0f,// min magnitude
                                                   10.0f,// max magnitude
                                                   catalogs,
                                                   contributors,
                                                   500,//Max number of events to return at once
                                                   iter);//Allows access to additional events
        logger.info("got " + events.length + " events");
        for(int i = 0; i < events.length; i++) {
            Origin origin = events[i].get_preferred_origin();
            Location originLocation = origin.my_location;
            logger.info(i+"th origin is at latitude " + originLocation.latitude
                    + " longitude " + originLocation.longitude+
                    " and its magnitude is " + origin.magnitudes[0].value);
        }
    }

    private static Logger logger = Logger.getLogger(EventClient.class);
}
