/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.simple;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkDC;
import edu.iris.Fissures.IfNetwork.NetworkFinder;
import edu.iris.Fissures.IfNetwork.Response;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.model.AllVTFactory;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import edu.sc.seis.fissuresUtil.sac.FissuresToSac;
import edu.sc.seis.fissuresUtil.sac.SacPoleZero;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.varia.NullAppender;
import org.omg.CORBA_2_3.ORB;

public class SacPoleZeroClient {
    private static final Logger logger = Logger.getLogger((Class)SacPoleZeroClient.class);

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure((Appender)new NullAppender());
        logger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        ORB orb = (ORB)org.omg.CORBA.ORB.init((String[])new String[0], (Properties)new Properties());
        new AllVTFactory().register(orb);
        FissuresNamingService namingService = new FissuresNamingService(orb);
        namingService.setNameServiceCorbaLoc("corbaloc:iiop:dmc.iris.washington.edu:6371/NameService");
        NetworkDC netDC = namingService.getNetworkDC("edu/iris/dmc", "IRIS_NetworkDC");
        NetworkFinder netFinder = netDC.a_finder();
        NetworkAccess net = netFinder.retrieve_by_code("II")[0];
        Station[] stations = net.retrieve_stations();
        logger.info((Object)("Got " + stations.length + " stations"));
        Channel[] channels = net.retrieve_for_station(stations[0].get_id());
        logger.info((Object)("Got " + channels.length + " channels from " + stations[0].get_code()));
        Instrumentation inst = net.retrieve_instrumentation(channels[0].get_id(), channels[0].effective_time.start_time);
        SacPoleZero sac = FissuresToSac.getPoleZero((Response)inst.the_response);
        logger.info((Object)("Channel: " + ChannelIdUtil.toString((ChannelId)channels[0].get_id())));
        logger.info((Object)("PoleZero:\n" + sac.toString()));
    }
}

