/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.simple;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkDC;
import edu.iris.Fissures.IfNetwork.NetworkFinder;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfSeismogramDC.DataCenter;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.AllVTFactory;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import edu.sc.seis.fissuresUtil.sac.FissuresToSac;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import edu.sc.seis.simple.SeismogramClient;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.varia.NullAppender;
import org.omg.CORBA_2_3.ORB;

public class SacFileClient {
    private static Logger logger = Logger.getLogger((Class)SeismogramClient.class);

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure((Appender)new NullAppender());
        logger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        ORB orb = (ORB)org.omg.CORBA.ORB.init((String[])new String[0], (Properties)new Properties());
        new AllVTFactory().register(orb);
        FissuresNamingService namingService = new FissuresNamingService(orb);
        namingService.setNameServiceCorbaLoc("corbaloc:iiop:dmc.iris.washington.edu:6371/NameService");
        NetworkDC netDC = namingService.getNetworkDC("edu/iris/dmc", "IRIS_NetworkDC");
        NetworkFinder netFinder = netDC.a_finder();
        NetworkAccess net = netFinder.retrieve_by_code("IU")[0];
        Station[] stations = net.retrieve_stations();
        Channel[] channels = net.retrieve_for_station(stations[0].get_id());
        DataCenter seisDC = namingService.getSeismogramDC("edu/iris/dmc", "IRIS_PondDataCenter");
        RequestFilter[] seismogramRequest = new RequestFilter[1];
        Time start = new Time("2003-06-20T06:23:25.0000Z", -1);
        Time end = new Time("2003-06-20T06:43:25.0000Z", -1);
        seismogramRequest[0] = new RequestFilter(channels[0].get_id(), start, end);
        logger.info((Object)("querying for " + seismogramRequest[0].channel_id.network_id.network_code + "." + seismogramRequest[0].channel_id.station_code + "." + seismogramRequest[0].channel_id.site_code + "." + seismogramRequest[0].channel_id.channel_code));
        LocalSeismogram[] seis = seisDC.retrieve_seismograms(seismogramRequest);
        String channelName = ChannelIdUtil.toStringNoDates((Channel)channels[0]).replaceAll(" ", "_");
        for (int i = 0; i < seis.length; ++i) {
            String filename = channelName + ".SAC." + i;
            logger.info((Object)("Saved seismogram to " + filename + " and it has " + seis[i].num_points + " points and starts at " + seis[i].begin_time.date_time));
            SacTimeSeries sac = FissuresToSac.getSAC((LocalSeismogramImpl)((LocalSeismogramImpl)seis[i]), (Channel)channels[0]);
            sac.write(filename);
        }
    }
}

