/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.simple;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkDC;
import edu.iris.Fissures.IfNetwork.NetworkFinder;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.model.AllVTFactory;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.varia.NullAppender;
import org.omg.CORBA_2_3.ORB;

public class NetworkClient {
    private static Logger logger = Logger.getLogger((Class)NetworkClient.class);

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure((Appender)new NullAppender());
        logger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        ORB orb = (ORB)org.omg.CORBA.ORB.init((String[])new String[0], (Properties)new Properties());
        new AllVTFactory().register(orb);
        FissuresNamingService namingService = new FissuresNamingService(orb);
        namingService.setNameServiceCorbaLoc("corbaloc:iiop:dmc.iris.washington.edu:6371/NameService");
        NetworkDC netDC = namingService.getNetworkDC("edu/iris/dmc", "IRIS_NetworkDC");
        NetworkFinder netFinder = netDC.a_finder();
        String networkCode = "II";
        NetworkAccess net = netFinder.retrieve_by_code(networkCode)[0];
        Station[] stations = net.retrieve_stations();
        logger.info((Object)("Network " + networkCode + " has " + stations.length + " stations"));
        logger.info((Object)(stations[0].get_code() + ", " + stations[0].name + " is located at " + stations[0].my_location.latitude + ", " + stations[0].my_location.longitude));
        Channel[] channels = net.retrieve_for_station(stations[0].get_id());
        logger.info((Object)("Station " + stations[0].get_id().network_id.network_code + "." + stations[0].get_code() + " has " + channels.length + " channels."));
    }
}

