/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.simple;

import edu.iris.Fissures.Area;
import edu.iris.Fissures.IfEvent.EventAccess;
import edu.iris.Fissures.IfEvent.EventDC;
import edu.iris.Fissures.IfEvent.EventFinder;
import edu.iris.Fissures.IfEvent.EventSeqIterHolder;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.AllVTFactory;
import edu.iris.Fissures.model.GlobalAreaImpl;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.varia.NullAppender;
import org.omg.CORBA_2_3.ORB;

public class EventClient {
    private static Logger logger = Logger.getLogger((Class)EventClient.class);

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure((Appender)new NullAppender());
        logger.addAppender((Appender)new ConsoleAppender((Layout)new SimpleLayout()));
        ORB orb = (ORB)org.omg.CORBA.ORB.init((String[])new String[0], (Properties)new Properties());
        new AllVTFactory().register(orb);
        FissuresNamingService namingService = new FissuresNamingService(orb);
        namingService.setNameServiceCorbaLoc("corbaloc:iiop:dmc.iris.washington.edu:6371/NameService");
        EventDC eventDC = namingService.getEventDC("edu/iris/dmc", "IRIS_EventDC");
        EventFinder finder = eventDC.a_finder();
        EventSeqIterHolder iter = new EventSeqIterHolder();
        MicroSecondDate now = ClockUtil.now();
        MicroSecondDate oneWeekAgo = now.subtract(new TimeInterval(7.0, UnitImpl.DAY));
        TimeRange oneWeek = new TimeRange(oneWeekAgo.getFissuresTime(), now.getFissuresTime());
        String[] magTypes = new String[]{};
        String[] catalogs = new String[]{};
        String[] contributors = new String[]{};
        EventAccess[] events = finder.query_events((Area)new GlobalAreaImpl(), (Quantity)new QuantityImpl(0.0, (Unit)UnitImpl.KILOMETER), (Quantity)new QuantityImpl(1000.0, (Unit)UnitImpl.KILOMETER), oneWeek, magTypes, 5.0f, 10.0f, catalogs, contributors, 500, iter);
        logger.info((Object)("got " + events.length + " events"));
        for (int i = 0; i < events.length; ++i) {
            Origin origin = events[i].get_preferred_origin();
            Location originLocation = origin.my_location;
            logger.info((Object)(i + "th origin is at latitude " + originLocation.latitude + " longitude " + originLocation.longitude + " and its magnitude is " + origin.magnitudes[0].value));
        }
    }
}

