/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import edu.iris.Fissures.Time;
import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import java.util.Calendar;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLTime {
    public static void insert(XMLStreamWriter writer, Time time) throws XMLStreamException {
        XMLUtil.writeTextElement(writer, "date_time", time.date_time);
        XMLUtil.writeTextElement(writer, "leap_seconds_version", "" + time.leap_seconds_version);
    }

    public static void insert(Element element, Time time) {
        Document doc = element.getOwnerDocument();
        element.appendChild(XMLUtil.createTextElement(doc, "date_time", time.date_time));
        element.appendChild(XMLUtil.createTextElement(doc, "leap_seconds_version", "" + time.leap_seconds_version));
    }

    public static Time getFissuresTime(Element element) {
        Date startTime = Calendar.getInstance().getTime();
        NodeList nodeList = element.getChildNodes();
        String date_time = "";
        int leap_seconds_version = 0;
        for (int counter = 0; counter < nodeList.getLength(); ++counter) {
            if (!(nodeList.item(counter) instanceof Element)) continue;
            Element elem = (Element)nodeList.item(counter);
            if (elem.getNodeName().equals("date_time")) {
                date_time = XMLUtil.getText(elem);
                continue;
            }
            if (!elem.getNodeName().equals("leap_seconds_version")) continue;
            leap_seconds_version = Integer.parseInt(XMLUtil.getText(elem));
        }
        Date endTime = Calendar.getInstance().getTime();
        return new Time(date_time, leap_seconds_version);
    }
}

