/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.sc.seis.fissuresUtil.xml.XMLNetworkId;
import edu.sc.seis.fissuresUtil.xml.XMLTimeRange;
import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLNetworkAttr {
    public static void insert(XMLStreamWriter writer, NetworkAttr networkAttr) throws XMLStreamException {
        XMLUtil.writeTextElement(writer, "name", networkAttr.name);
        XMLUtil.writeTextElement(writer, "description", networkAttr.description);
        XMLUtil.writeTextElement(writer, "owner", networkAttr.owner);
        writer.writeStartElement("id");
        XMLNetworkId.insert(writer, networkAttr.get_id());
        XMLUtil.writeEndElementWithNewLine(writer);
        writer.writeStartElement("effective_time");
        XMLTimeRange.insert(writer, networkAttr.effective_time);
        XMLUtil.writeEndElementWithNewLine(writer);
    }

    public static void insert(Element element, NetworkAttr networkAttr) {
        Document doc = element.getOwnerDocument();
        element.appendChild(XMLUtil.createTextElement(doc, "name", networkAttr.name));
        element.appendChild(XMLUtil.createTextElement(doc, "description", networkAttr.description));
        element.appendChild(XMLUtil.createTextElement(doc, "owner", networkAttr.owner));
        Element network_id = doc.createElement("id");
        XMLNetworkId.insert(network_id, networkAttr.get_id());
        element.appendChild(network_id);
        Element effective_time_range = doc.createElement("effective_time");
        XMLTimeRange.insert(effective_time_range, networkAttr.effective_time);
        element.appendChild(effective_time_range);
    }

    public static NetworkAttr getNetworkAttr(Element base) {
        String name = XMLUtil.getText(XMLUtil.getElement(base, "name"));
        String description = XMLUtil.getText(XMLUtil.getElement(base, "description"));
        String owner = XMLUtil.getText(XMLUtil.getElement(base, "owner"));
        NetworkId id = null;
        Element network_id_node = XMLUtil.getElement(base, "id");
        if (network_id_node != null) {
            id = XMLNetworkId.getNetworkId(network_id_node);
        }
        Element effective_time_node = XMLUtil.getElement(base, "effective_time");
        TimeRange effective_time = new TimeRange();
        if (effective_time_node != null) {
            effective_time = XMLTimeRange.getTimeRange(effective_time_node);
        }
        return new NetworkAttrImpl(id, name, description, owner, effective_time);
    }
}

