/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import edu.iris.Fissures.Location;
import edu.iris.Fissures.LocationType;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.model.QuantityImpl;
import edu.sc.seis.fissuresUtil.xml.XMLQuantity;
import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLLocation {
    public static void insert(XMLStreamWriter writer, Location loc) throws XMLStreamException {
        XMLUtil.writeTextElement(writer, "latitude", "" + loc.latitude);
        XMLUtil.writeTextElement(writer, "longitude", "" + loc.longitude);
        writer.writeStartElement("elevation");
        XMLQuantity.insert(writer, loc.elevation);
        XMLUtil.writeEndElementWithNewLine(writer);
        writer.writeStartElement("depth");
        XMLQuantity.insert(writer, loc.depth);
        XMLUtil.writeEndElementWithNewLine(writer);
        if (loc.type.equals(LocationType.GEOGRAPHIC)) {
            XMLUtil.writeTextElement(writer, "type", "GEOGRAPHIC");
        } else {
            XMLUtil.writeTextElement(writer, "type", "GEOCENTRIC");
        }
    }

    public static void insert(Element element, Location loc) {
        Document doc = element.getOwnerDocument();
        element.appendChild(XMLUtil.createTextElement(doc, "latitude", "" + loc.latitude));
        element.appendChild(XMLUtil.createTextElement(doc, "longitude", "" + loc.longitude));
        Element elevation = doc.createElement("elevation");
        XMLQuantity.insert(elevation, loc.elevation);
        element.appendChild(elevation);
        Element depth = doc.createElement("depth");
        XMLQuantity.insert(depth, loc.depth);
        element.appendChild(depth);
        if (loc.type.equals(LocationType.GEOGRAPHIC)) {
            element.appendChild(XMLUtil.createTextElement(doc, "type", "GEOGRAPHIC"));
        } else {
            element.appendChild(XMLUtil.createTextElement(doc, "type", "GEOCENTRIC"));
        }
    }

    public static Location getLocation(Element base) {
        String type;
        float latitude = Float.parseFloat(XMLUtil.getText(XMLUtil.getElement(base, "latitude")));
        float longitude = Float.parseFloat(XMLUtil.getText(XMLUtil.getElement(base, "longitude")));
        Element elevationNode = XMLUtil.getElement(base, "elevation");
        QuantityImpl elevation = null;
        if (elevationNode != null) {
            elevation = XMLQuantity.getQuantity(elevationNode);
        }
        Element depthNode = XMLUtil.getElement(base, "depth");
        QuantityImpl depth = null;
        if (depthNode != null) {
            depth = XMLQuantity.getQuantity(depthNode);
        }
        LocationType locationType = (type = XMLUtil.getText(XMLUtil.getElement(base, "type"))).equals("GEOGRAPHIC") ? LocationType.GEOGRAPHIC : LocationType.GEOCENTRIC;
        return new Location(latitude, longitude, (Quantity)elevation, (Quantity)depth, locationType);
    }
}

