/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.xml;

import edu.iris.Fissures.AuditInfo;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.IncomprehensibleDSMLException;
import edu.sc.seis.fissuresUtil.xml.MemoryDataSet;
import edu.sc.seis.fissuresUtil.xml.SeismogramFileTypes;
import edu.sc.seis.fissuresUtil.xml.URLDataSet;
import edu.sc.seis.fissuresUtil.xml.URLDataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.UnsupportedFileTypeException;
import edu.sc.seis.fissuresUtil.xml.Writer;
import edu.sc.seis.fissuresUtil.xml.XMLDataSet;
import edu.sc.seis.fissuresUtil.xml.XMLParameter;
import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DataSetToXML {
    public static final String DSML_SCHEMA2_0 = "http://www.seis.sc.edu/xschema/dataset/2.0 http://www.seis.sc.edu/xschema/dataset/2.0/dataset.xsd";
    protected boolean saveLocally = true;
    protected boolean useDataSetRef = true;
    static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$xml$DataSetToXML == null ? (class$edu$sc$seis$fissuresUtil$xml$DataSetToXML = DataSetToXML.class$("edu.sc.seis.fissuresUtil.xml.DataSetToXML")) : class$edu$sc$seis$fissuresUtil$xml$DataSetToXML));
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$xml$DataSetToXML;

    public File save(DataSet dataset, File saveDirectory) throws IOException, ParserConfigurationException, MalformedURLException {
        return this.save(dataset, saveDirectory, SeismogramFileTypes.SAC);
    }

    public File save(DataSet dataset, File saveDirectory, SeismogramFileTypes fileType) throws IOException, ParserConfigurationException, MalformedURLException {
        Element doc = this.createDocument(dataset, saveDirectory, fileType);
        String filename = DataSetToXML.createFileName(dataset);
        logger.debug((Object)("save to " + filename + " in " + saveDirectory.toString()));
        saveDirectory.mkdirs();
        File outFile = new File(saveDirectory, filename);
        this.writeToFile(doc, outFile);
        logger.debug((Object)("Done with save to " + saveDirectory.toString()));
        return outFile;
    }

    public static String createFileName(DataSet dataset) {
        String filename = dataset.getName() + ".dsml";
        filename = filename.replaceAll(" ", "_");
        filename = filename.replaceAll(",", "_");
        filename = filename.replaceAll("/", "_");
        filename = filename.replaceAll(":", "_");
        return filename;
    }

    public void writeToFile(Element datasetElement, File outFile) throws IOException, MalformedURLException {
        File tempFile = outFile.exists() ? File.createTempFile("Temp_" + outFile.getName(), "dsml", outFile.getParentFile()) : outFile;
        BufferedWriter buf = new BufferedWriter(new FileWriter(tempFile));
        Writer xmlWriter = new Writer(false, true);
        xmlWriter.setOutput(buf);
        xmlWriter.write(datasetElement);
        buf.close();
        if (outFile != tempFile && !tempFile.renameTo(outFile)) {
            if (outFile.delete()) {
                tempFile.renameTo(outFile);
            } else {
                throw new IOException("Unable to move temp file over old file");
            }
        }
    }

    public static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        return XMLDataSet.getDocumentBuilder();
    }

    public Element createDocument(DataSet dataset, File dataDirectory, SeismogramFileTypes fileType) throws IOException, ParserConfigurationException, MalformedURLException {
        if (!dataDirectory.exists()) {
            dataDirectory.mkdirs();
        }
        DocumentBuilder docBuilder = DataSetToXML.getDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element element = this.insert(doc, dataset, dataDirectory, fileType);
        return element;
    }

    public Element insert(Element parent, DataSet dataset, File directory, SeismogramFileTypes fileType) throws IOException, ParserConfigurationException, MalformedURLException {
        Element child = parent.getOwnerDocument().createElement("dataset");
        this.insertInto(child, dataset, directory, fileType);
        parent.appendChild(child);
        return child;
    }

    public Element insert(Document doc, DataSet dataset, File directory, SeismogramFileTypes fileType) throws IOException, ParserConfigurationException, MalformedURLException {
        Element element = doc.createElement("dataset");
        element.setAttribute("xmlns:dataset", "http://www.seis.sc.edu/xschema/dataset/2.0");
        element.setAttribute("xmlns", "http://www.seis.sc.edu/xschema/dataset/2.0");
        element.setAttribute("xsi:schemaLocation", DSML_SCHEMA2_0);
        element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        element.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        this.insertInto(element, dataset, directory, fileType);
        doc.appendChild(element);
        return element;
    }

    public void insertInto(Element element, DataSet dataset, File directory, SeismogramFileTypes fileType) throws IOException, ParserConfigurationException, MalformedURLException {
        Document doc = element.getOwnerDocument();
        element.setAttribute("datasetid", dataset.getId());
        element.appendChild(XMLUtil.createTextElement(doc, "name", dataset.getName()));
        element.appendChild(XMLUtil.createTextElement(doc, "owner", dataset.getOwner()));
        String[] childDataSets = dataset.getDataSetNames();
        for (int i = 0; i < childDataSets.length; ++i) {
            String childDirName = DataSetToXML.createFileName(dataset.getDataSet(childDataSets[i]));
            File childDirectory = new File(directory, childDirName);
            if (!childDirectory.exists()) {
                childDirectory.mkdirs();
            }
            if (this.useDataSetRef) {
                this.insertRef(element, dataset.getDataSet(childDataSets[i]), childDirectory);
                continue;
            }
            this.insert(element, dataset.getDataSet(childDataSets[i]), childDirectory, fileType);
        }
        String[] childDSS = dataset.getDataSetSeismogramNames();
        File dataDir = new File(directory, "data");
        dataDir.mkdirs();
        for (int i = 0; i < childDSS.length; ++i) {
            DataSetSeismogram dss = dataset.getDataSetSeismogram(childDSS[i]);
            URLDataSetSeismogram urlDSS = this.saveLocally || !(dss instanceof URLDataSetSeismogram) ? URLDataSetSeismogram.localize(dss, dataDir, fileType) : (URLDataSetSeismogram)dss;
            this.insert(element, urlDSS, directory.toURI().toURL());
        }
        String[] paramNames = dataset.getParameterNames();
        for (int i = 0; i < paramNames.length; ++i) {
            this.insert(element, paramNames[i], dataset.getParameter(paramNames[i]));
        }
    }

    public Element insert(Element parent, URLDataSetSeismogram urlDSS, URL base) {
        Element child = parent.getOwnerDocument().createElement("urlDataSetSeismogram");
        urlDSS.insertInto(child, base);
        parent.appendChild(child);
        return child;
    }

    public Element insertRef(Element element, DataSet dataset, File directory) throws IOException, ParserConfigurationException, MalformedURLException {
        File dsFile = this.save(dataset, directory);
        return this.insertRef(element, directory.getName() + "/" + dsFile.getName(), dataset.getName());
    }

    public Element insertRef(Element parent, String datasetURL, String linkTitle) throws IOException, ParserConfigurationException, MalformedURLException {
        Element element = parent.getOwnerDocument().createElement("datasetRef");
        element.setAttribute("xlink:href", datasetURL);
        element.setAttribute("xlink:type", "simple");
        element.setAttribute("xlink:title", linkTitle);
        parent.appendChild(element);
        return element;
    }

    public Element insert(Element parent, String name, Object parameter) {
        Element element = parent.getOwnerDocument().createElement("parameter");
        parent.appendChild(element);
        XMLParameter.insert(element, name, parameter);
        return element;
    }

    public Element insertParameter(Element parent, String name, String typeDef, String typeName, String value) {
        Element element = parent.getOwnerDocument().createElement("parameter");
        parent.appendChild(element);
        XMLParameter.insert(element, name, typeDef, typeName, value);
        return element;
    }

    public static DataSet load(URL datasetURL) throws IOException, ParserConfigurationException, IncomprehensibleDSMLException, UnsupportedFileTypeException {
        DataSet dataset = null;
        DocumentBuilder docBuilder = DataSetToXML.getDocumentBuilder();
        try {
            Document doc = docBuilder.parse(new BufferedInputStream(datasetURL.openStream()));
            Element docElement = doc.getDocumentElement();
            if (docElement.getTagName().equals("dataset")) {
                if (docElement.getAttribute("xsi:schemaLocation").equals(DSML_SCHEMA2_0)) {
                    DataSetToXML dataSetToXML = new DataSetToXML();
                    dataset = dataSetToXML.extract(datasetURL, docElement);
                } else {
                    logger.warn((Object)("Not a 2.0 dsml. " + docElement.getTagName() + "  " + docElement.getAttribute("xsi:schemaLocation")));
                    dataset = new XMLDataSet(docBuilder, datasetURL, docElement);
                    AuditInfo[] audit = new AuditInfo[]{new AuditInfo("loaded from " + datasetURL.toString(), System.getProperty("user.name"))};
                    dataset.addParameter("xml:base", datasetURL.toString(), audit);
                }
                return dataset;
            }
            throw new IncomprehensibleDSMLException("This does not appear to be a dsml file, starting tag is not dataset. " + datasetURL.toString());
        }
        catch (SAXException e) {
            throw new IncomprehensibleDSMLException("This does not appear to be a dsml file." + datasetURL.toString(), e);
        }
    }

    public DataSet extract(URL base, Element element) throws MalformedURLException, UnsupportedFileTypeException {
        String name = "";
        String owner = "";
        String id = element.getAttribute("datasetid");
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element child = (Element)children.item(i);
            if (child.getNodeName().equals("name")) {
                name = XMLUtil.getText(child);
                continue;
            }
            if (!child.getNodeName().equals("owner")) continue;
            owner = XMLUtil.getText(child);
        }
        AuditInfo[] audit = new AuditInfo[]{new AuditInfo("loaded from " + base.toString(), System.getProperty("user.name"))};
        if (id == null || id.length() == 0) {
            id = "autogen_id-" + Math.random();
        }
        MemoryDataSet dataset = new MemoryDataSet(id, name, owner, audit);
        dataset.addParameter("xml:base", base.toString(), audit);
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName().equals("dataset")) {
                dataset.addDataSet(this.extract(base, (Element)child), audit);
                continue;
            }
            if (child.getNodeName().equals("datasetRef")) {
                Element childElement = (Element)child;
                dataset.addDataSet(new URLDataSet(childElement.getAttribute("xlink:title"), new URL(base, childElement.getAttribute("xlink:href"))), audit);
                continue;
            }
            if (child.getNodeName().equals("urlDataSetSeismogram")) {
                dataset.addDataSetSeismogram(URLDataSetSeismogram.getURLDataSetSeismogram(base, (Element)child), audit);
                continue;
            }
            if (!child.getNodeName().equals("parameter")) continue;
            String paramName = XMLUtil.getText(XMLUtil.getElement((Element)child, "name"));
            Object o = XMLParameter.getParameter((Element)child);
            dataset.addParameter(paramName, o, audit);
        }
        return dataset;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

