/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.time;

import edu.iris.Fissures.Plottable;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.database.plottable.JDBCPlottable;
import edu.sc.seis.fissuresUtil.database.plottable.PlottableChunk;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.time.RangeTool;
import edu.sc.seis.fissuresUtil.time.SortTool;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class ReduceTool {
    private static final ReduceTool rt = new ReduceTool();
    private static final Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$time$ReduceTool == null ? (class$edu$sc$seis$fissuresUtil$time$ReduceTool = ReduceTool.class$("edu.sc.seis.fissuresUtil.time.ReduceTool")) : class$edu$sc$seis$fissuresUtil$time$ReduceTool));
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$time$ReduceTool;

    public static LocalSeismogramImpl[] removeContained(LocalSeismogramImpl[] seis) {
        SortTool.byLengthAscending(seis);
        ArrayList<LocalSeismogramImpl> results = new ArrayList<LocalSeismogramImpl>();
        for (int i = 0; i < seis.length; ++i) {
            MicroSecondDate iEnd = seis[i].getEndTime();
            MicroSecondDate iBegin = seis[i].getBeginTime();
            boolean contained = false;
            for (int j = i + 1; j < seis.length && !contained; ++j) {
                if (!ReduceTool.equalsOrAfter(iBegin, seis[j].getBeginTime()) || !ReduceTool.equalsOrBefore(iEnd, seis[j].getEndTime())) continue;
                contained = true;
            }
            if (contained) continue;
            results.add(seis[i]);
        }
        return results.toArray(new LocalSeismogramImpl[0]);
    }

    public static MicroSecondTimeRange[] merge(MicroSecondTimeRange[] ranges) {
        ReduceTool reduceTool = rt;
        reduceTool.getClass();
        return reduceTool.new MSTRMerger().merge(ranges);
    }

    public static PlottableChunk[] merge(PlottableChunk[] chunks) {
        ReduceTool reduceTool = rt;
        reduceTool.getClass();
        return reduceTool.new PlottableChunkMerger().merge(chunks);
    }

    public static boolean equalsOrAfter(MicroSecondDate first, MicroSecondDate second) {
        return first.equals((Object)second) || first.after((Date)second);
    }

    public static boolean equalsOrBefore(MicroSecondDate first, MicroSecondDate second) {
        return first.equals((Object)second) || first.before((Date)second);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PlottableChunkMerger
    extends Merger {
        private PlottableChunkMerger() {
        }

        public Object merge(Object one, Object two) {
            PlottableChunk chunk = this.cast(one);
            PlottableChunk chunk2 = this.cast(two);
            MicroSecondTimeRange fullRange = new MicroSecondTimeRange(chunk.getTimeRange(), chunk2.getTimeRange());
            logger.debug((Object)("Merging " + chunk + " and " + chunk2 + " into " + fullRange));
            int samples = (int)Math.floor((double)(chunk.getPixelsPerDay() * 2) * fullRange.getInterval().convertTo((UnitImpl)UnitImpl.DAY).value);
            int[] y = new int[samples];
            JDBCPlottable.fill(fullRange, y, chunk);
            JDBCPlottable.fill(fullRange, y, chunk2);
            Plottable mergedData = new Plottable(null, y);
            PlottableChunk earlier = chunk;
            if (chunk2.getBeginTime().before((Date)chunk.getBeginTime())) {
                earlier = chunk2;
            }
            return new PlottableChunk(mergedData, earlier.getBeginPixel(), earlier.getJDay(), earlier.getYear(), chunk.getPixelsPerDay(), chunk.getChannel());
        }

        public boolean areContiguous(Object one, Object two) {
            return RangeTool.areContiguous(this.cast(one), this.cast(two));
        }

        public boolean areOverlapping(Object one, Object two) {
            return RangeTool.areOverlapping(this.cast(one), this.cast(two));
        }

        public PlottableChunk cast(Object o) {
            return (PlottableChunk)o;
        }

        public PlottableChunk[] merge(PlottableChunk[] chunks) {
            return (PlottableChunk[])this.internalMerge(chunks, new PlottableChunk[0]);
        }
    }

    private class MSTRMerger
    extends Merger {
        private MSTRMerger() {
        }

        public Object merge(Object one, Object two) {
            return new MicroSecondTimeRange(this.cast(one), this.cast(two));
        }

        public boolean areContiguous(Object one, Object two) {
            return RangeTool.areContiguous(this.cast(one), this.cast(two));
        }

        public boolean areOverlapping(Object one, Object two) {
            return RangeTool.areOverlapping(this.cast(one), this.cast(two));
        }

        public MicroSecondTimeRange cast(Object o) {
            return (MicroSecondTimeRange)o;
        }

        public MicroSecondTimeRange[] merge(MicroSecondTimeRange[] ranges) {
            return (MicroSecondTimeRange[])this.internalMerge(ranges, new MicroSecondTimeRange[0]);
        }
    }

    private abstract class Merger {
        private Merger() {
        }

        public abstract Object merge(Object var1, Object var2);

        public abstract boolean areContiguous(Object var1, Object var2);

        public abstract boolean areOverlapping(Object var1, Object var2);

        public Object[] internalMerge(Object[] chunks, Object[] resultantTypeArray) {
            chunks = (Object[])chunks.clone();
            block0: for (int i = 0; i < chunks.length; ++i) {
                Object chunk = chunks[i];
                for (int j = i + 1; j < chunks.length; ++j) {
                    Object chunk2 = chunks[j];
                    if (!this.areContiguous(chunk, chunk2) && !this.areOverlapping(chunk, chunk2)) continue;
                    chunks[j] = this.merge(chunk, chunk2);
                    chunks[i] = null;
                    continue block0;
                }
            }
            ArrayList<Object> results = new ArrayList<Object>();
            for (int i = 0; i < chunks.length; ++i) {
                if (chunks[i] == null) continue;
                results.add(chunks[i]);
            }
            return results.toArray(resultantTypeArray);
        }
    }
}

