/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.time;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.database.plottable.PlottableChunk;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.time.SortTool;
import java.util.Date;

public class RangeTool {
    public static boolean areContiguous(PlottableChunk one, PlottableChunk two) {
        TimeInterval sampleInterval = new TimeInterval(1.0 / (double)one.getPixelsPerDay(), UnitImpl.DAY);
        return RangeTool.areContiguous(one.getTimeRange(), two.getTimeRange(), sampleInterval);
    }

    public static boolean areContiguous(LocalSeismogramImpl one, LocalSeismogramImpl two) {
        return RangeTool.areContiguous(new MicroSecondTimeRange(one), new MicroSecondTimeRange(two), one.getSampling().getPeriod());
    }

    public static boolean areContiguous(MicroSecondTimeRange one, MicroSecondTimeRange two, TimeInterval interval) {
        if (!RangeTool.areOverlapping(one, two)) {
            TimeInterval doubleInterval = (TimeInterval)interval.multiplyBy(2.0);
            if (one.getEndTime().before((Date)two.getBeginTime())) {
                return one.getEndTime().add(doubleInterval).after((Date)two.getBeginTime());
            }
            return two.getEndTime().add(doubleInterval).after((Date)one.getBeginTime());
        }
        return false;
    }

    public static boolean areContiguous(MicroSecondTimeRange one, MicroSecondTimeRange two) {
        return one.getEndTime().equals((Object)two.getBeginTime()) || one.getBeginTime().equals((Object)two.getEndTime());
    }

    public static boolean areOverlapping(PlottableChunk one, PlottableChunk two) {
        return RangeTool.areOverlapping(one.getTimeRange(), two.getTimeRange());
    }

    public static boolean areOverlapping(MicroSecondTimeRange one, MicroSecondTimeRange two) {
        return one.getBeginTime().before((Date)two.getEndTime()) && one.getEndTime().after((Date)two.getBeginTime());
    }

    public static boolean areOverlapping(LocalSeismogramImpl one, LocalSeismogramImpl two) {
        MicroSecondTimeRange oneTr = new MicroSecondTimeRange(one.getBeginTime(), one.getEndTime());
        MicroSecondTimeRange twoTr = new MicroSecondTimeRange(two.getBeginTime(), two.getEndTime());
        return RangeTool.areOverlapping(oneTr, twoTr);
    }

    public static MicroSecondTimeRange getFullTime(LocalSeismogramImpl[] seis) {
        if (seis.length == 0) {
            return DisplayUtils.ZERO_TIME;
        }
        MicroSecondDate beginTime = SortTool.byBeginTimeAscending(seis)[0].getBeginTime();
        MicroSecondDate endTime = new MicroSecondDate(0L);
        for (int i = 0; i < seis.length; ++i) {
            if (!seis[i].getEndTime().after((Date)endTime)) continue;
            endTime = seis[i].getEndTime();
        }
        return new MicroSecondTimeRange(beginTime, endTime);
    }

    public static MicroSecondTimeRange getFullTime(PlottableChunk[] pc) {
        if (pc.length == 0) {
            return DisplayUtils.ZERO_TIME;
        }
        MicroSecondDate beginTime = SortTool.byBeginTimeAscending(pc)[0].getBeginTime();
        MicroSecondDate endTime = new MicroSecondDate(0L);
        for (int i = 0; i < pc.length; ++i) {
            if (!pc[i].getEndTime().after((Date)endTime)) continue;
            endTime = pc[i].getEndTime();
        }
        return new MicroSecondTimeRange(beginTime, endTime);
    }
}

