/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.sound;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.display.SeismogramContainer;
import edu.sc.seis.fissuresUtil.display.SeismogramIterator;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.sound.PlayEvent;
import edu.sc.seis.fissuresUtil.sound.PlayEventListener;
import edu.sc.seis.seisFile.mseed.Utility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Category;

public class FissuresToWAV {
    private int chunkSize;
    private int numChannels;
    private int sampleRate;
    private int speedUp;
    private int bitsPerSample;
    private int blockAlign;
    private int byteRate;
    private int subchunk2Size;
    private Clip clip;
    private SeismogramContainer container;
    private EventListenerList listenerList = new EventListenerList();
    static Category logger = Category.getInstance((String)(class$edu$sc$seis$fissuresUtil$sound$FissuresToWAV == null ? (class$edu$sc$seis$fissuresUtil$sound$FissuresToWAV = FissuresToWAV.class$("edu.sc.seis.fissuresUtil.sound.FissuresToWAV")) : class$edu$sc$seis$fissuresUtil$sound$FissuresToWAV).getName());
    static /* synthetic */ Class class$javax$sound$sampled$Clip;
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$sound$PlayEventListener;
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$sound$FissuresToWAV;

    public FissuresToWAV(SeismogramContainer container, int speedUp) {
        this.container = container;
        this.speedUp = speedUp;
        this.numChannels = 1;
        this.bitsPerSample = 16;
        this.blockAlign = this.numChannels * (this.bitsPerSample / 8);
    }

    public void writeWAV(DataOutput out, MicroSecondTimeRange tr) throws IOException, FissuresException {
        this.updateInfo(this.container.getIterator(tr));
        this.writeChunkData(out);
        this.writeWAVData(out);
    }

    public void play(MicroSecondTimeRange tr) {
        PlayThread playThread = new PlayThread(tr);
        playThread.start();
    }

    private synchronized void playFromThread(MicroSecondTimeRange tr) {
        AudioFormat audioFormat;
        this.updateInfo();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            this.writeWAVData(dos, this.container.getIterator(tr));
        }
        catch (Exception e) {
            GlobalExceptionHandler.handle(e);
        }
        if (this.clip != null) {
            this.clip.close();
        }
        Clip clip = null;
        DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$Clip == null ? (class$javax$sound$sampled$Clip = FissuresToWAV.class$("javax.sound.sampled.Clip")) : class$javax$sound$sampled$Clip, audioFormat = new AudioFormat(this.sampleRate, 16, 1, true, false));
        if (!AudioSystem.isLineSupported(info)) {
            logger.debug((Object)"Line not supported, apparently...");
        }
        try {
            clip = (Clip)AudioSystem.getLine(info);
            byte[] data = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            AudioInputStream ais = new AudioInputStream(bais, audioFormat, data.length);
            try {
                clip.open(ais);
                this.firePlayEvent(FissuresToWAV.calculateTime(tr, this.speedUp), clip);
                clip.start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (LineUnavailableException ex) {
            ex.printStackTrace();
        }
        try {
            baos.close();
            dos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateInfo() {
        this.updateInfo(this.container.getIterator());
    }

    private void updateInfo(SeismogramIterator iterator) {
        this.chunkSize = 36 + 2 * iterator.getNumPoints();
        this.subchunk2Size = iterator.getNumPoints() * this.blockAlign;
        this.sampleRate = this.calculateSampleRate(this.container.getIterator().getSampling());
        this.byteRate = this.sampleRate * this.blockAlign;
    }

    public void setSpeedUp(int newSpeed) {
        this.speedUp = newSpeed;
        this.updateInfo();
    }

    private void writeChunkData(DataOutput out) throws IOException {
        out.writeBytes("RIFF");
        FissuresToWAV.writeLittleEndian(out, this.chunkSize);
        out.writeBytes("WAVE");
        out.writeBytes("fmt ");
        FissuresToWAV.writeLittleEndian(out, 16);
        FissuresToWAV.writeLittleEndian(out, (short)1);
        FissuresToWAV.writeLittleEndian(out, (short)this.numChannels);
        FissuresToWAV.writeLittleEndian(out, this.sampleRate);
        FissuresToWAV.writeLittleEndian(out, this.byteRate);
        FissuresToWAV.writeLittleEndian(out, (short)this.blockAlign);
        FissuresToWAV.writeLittleEndian(out, (short)this.bitsPerSample);
        out.writeBytes("data");
        FissuresToWAV.writeLittleEndian(out, this.subchunk2Size);
    }

    private void writeWAVData(DataOutput out) throws IOException {
        this.writeWAVData(out, this.container.getIterator());
    }

    private void writeWAVData(DataOutput out, SeismogramIterator iterator) throws IOException {
        double[] minMaxMean = iterator.minMaxMean();
        double absMax = Double.MAX_VALUE;
        absMax = Math.abs(minMaxMean[0]) > Math.abs(minMaxMean[1]) ? Math.abs(minMaxMean[0]) : Math.abs(minMaxMean[1]);
        double amplification = 32000.0 / absMax;
        while (iterator.hasNext()) {
            try {
                QuantityImpl next = (QuantityImpl)iterator.next();
                FissuresToWAV.writeLittleEndian(out, (short)(amplification * next.getValue()));
            }
            catch (NullPointerException e) {
                FissuresToWAV.writeLittleEndian(out, (short)0);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                FissuresToWAV.writeLittleEndian(out, (short)0);
            }
        }
    }

    public void addPlayEventListener(PlayEventListener pel) {
        this.listenerList.add(class$edu$sc$seis$fissuresUtil$sound$PlayEventListener == null ? (class$edu$sc$seis$fissuresUtil$sound$PlayEventListener = FissuresToWAV.class$("edu.sc.seis.fissuresUtil.sound.PlayEventListener")) : class$edu$sc$seis$fissuresUtil$sound$PlayEventListener, pel);
    }

    private void firePlayEvent(TimeInterval interval, Clip clip) {
        PlayEvent playEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$sc$seis$fissuresUtil$sound$PlayEventListener == null ? FissuresToWAV.class$("edu.sc.seis.fissuresUtil.sound.PlayEventListener") : class$edu$sc$seis$fissuresUtil$sound$PlayEventListener)) continue;
            if (playEvent == null) {
                playEvent = new PlayEvent(this, interval, clip);
            }
            ((PlayEventListener)listeners[i + 1]).eventPlayed(playEvent);
        }
    }

    public int calculateSampleRate(SamplingImpl sampling) {
        logger.debug((Object)sampling);
        QuantityImpl freq = sampling.getFrequency();
        freq = freq.convertTo(UnitImpl.HERTZ);
        int sampleRate = (int)(freq.getValue() * (double)this.speedUp);
        while (sampleRate > 48000) {
            this.setSpeedUp(this.speedUp / 2);
            logger.debug((Object)("speedUp = " + this.speedUp));
            sampleRate = (int)(freq.getValue() * (double)this.speedUp);
            logger.debug((Object)("sampleRate = " + sampleRate));
        }
        return sampleRate;
    }

    public static TimeInterval calculateTime(MicroSecondTimeRange tr, int speedUp) {
        TimeInterval interval = new TimeInterval((Quantity)tr.getInterval().divideBy((double)speedUp));
        return interval;
    }

    protected static void writeLittleEndian(DataOutput out, int value) throws IOException {
        byte[] tmpBytes = Utility.intToByteArray((int)value);
        out.write(tmpBytes[3]);
        out.write(tmpBytes[2]);
        out.write(tmpBytes[1]);
        out.write(tmpBytes[0]);
    }

    protected static void writeLittleEndian(DataOutput out, short value) throws IOException {
        byte[] tmpBytes = Utility.intToByteArray((int)value);
        out.write(tmpBytes[3]);
        out.write(tmpBytes[2]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class PlayThread
    extends Thread {
        MicroSecondTimeRange timeRange;

        public PlayThread(MicroSecondTimeRange tr) {
            this.timeRange = tr;
        }

        public void run() {
            FissuresToWAV.this.playFromThread(this.timeRange);
        }
    }
}

