/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.simple;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.AllVTFactory;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.omg.CORBA_2_3.ORB;

public abstract class Initializer {
    private static Properties props;
    private static ORB orb;
    private static FissuresNamingService fisName;
    private static Object initLock;
    private static final String[] EMPTY_ARGS;
    private static Logger logger;
    public static final NetworkId IU;
    public static final StationId AMNO;
    public static final ChannelId AMNOChannel;
    public static final NetworkId SP;
    public static final StationId ANDY;
    public static final ChannelId ANDYChannel;
    public static final NetworkId fakeNet;
    public static StationId fakeStation;
    public static ChannelId fakeChan;
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$simple$Initializer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String[] args) {
        Object object = initLock;
        synchronized (object) {
            if (fisName == null) {
                props = Initializer.loadProperties(args);
                PropertyConfigurator.configure((Properties)props);
                logger.info((Object)"Logging configured");
                orb = (ORB)org.omg.CORBA.ORB.init((String[])args, (Properties)props);
                logger.info((Object)("orb initialized, class=" + orb.getClass().getName()));
                AllVTFactory vt = new AllVTFactory();
                vt.register(orb);
                logger.info((Object)"register valuetype factories");
                fisName = new FissuresNamingService(orb);
                logger.info((Object)"create fisName helper with orb");
                fisName.setNameServiceCorbaLoc(props.getProperty("edu.sc.seis.fissuresUtil.nameServiceCorbaLoc", "corbaloc:iiop:dmc.iris.washington.edu:6371/NameService"));
                fisName.getNameService();
                logger.info((Object)"got fis name service");
            }
        }
    }

    public static Properties loadProperties(String[] args) {
        Properties sysProps = System.getProperties();
        for (int i = 0; i < args.length - 1; ++i) {
            if (!args[i].equals("-props")) continue;
            String propFilename = args[i + 1];
            try {
                Initializer.loadProps(new FileInputStream(propFilename), sysProps);
                continue;
            }
            catch (FileNotFoundException f) {
                System.err.println(" file missing " + f + " using defaults");
            }
        }
        return sysProps;
    }

    public static ORB getORB() {
        if (orb == null) {
            Initializer.init(EMPTY_ARGS);
        }
        return orb;
    }

    public static FissuresNamingService getNS() {
        if (fisName == null) {
            Initializer.init(EMPTY_ARGS);
        }
        return fisName;
    }

    public static Properties getProps() {
        return props;
    }

    public static void loadProps(InputStream propStream, Properties baseProps) {
        try {
            baseProps.load(propStream);
            propStream.close();
        }
        catch (Exception f) {
            GlobalExceptionHandler.handle("Problem loading props!", f);
            System.exit(0);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        initLock = new Object();
        EMPTY_ARGS = new String[0];
        logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$simple$Initializer == null ? (class$edu$sc$seis$fissuresUtil$simple$Initializer = Initializer.class$("edu.sc.seis.fissuresUtil.simple.Initializer")) : class$edu$sc$seis$fissuresUtil$simple$Initializer));
        IU = new NetworkId("IU", new Time("19981026200000.0000GMT", 0));
        AMNO = new StationId(IU, "ANMO", new Time("19981026200000.0000GMT", 0));
        AMNOChannel = new ChannelId(IU, "ANMO", "00", "BH1", new Time("19981026200000.0000GMT", 0));
        SP = new NetworkId("SP", new Time("20001209T01:00:00.000Z", 22));
        ANDY = new StationId(SP, "ANDY", new Time("20001209T01:00:00.000Z", 22));
        ANDYChannel = new ChannelId(SP, "ANDY", "00", "BHE", new Time("20001209T01:00:00.000Z", 22));
        fakeNet = new NetworkId("II", new Time("19861024000000.0000GMT", 0));
        fakeStation = new StationId(fakeNet, "AAK", new Time("19901012000000.0000GMT", 0));
        fakeChan = new ChannelId(fakeNet, "AAK", "00", "BHE", new Time("19901012000000.0000GMT", 0));
    }
}

