/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130.packetTypes;

import edu.sc.seis.fissuresUtil.rt130.BCDRead;
import edu.sc.seis.fissuresUtil.rt130.HexRead;
import edu.sc.seis.fissuresUtil.rt130.PacketType;
import edu.sc.seis.fissuresUtil.rt130.RT130FormatException;
import java.io.DataInput;
import java.io.IOException;

public class EventTrailerPacket
extends PacketType {
    protected String dataFormat;
    protected String triggerTimeMessage;
    protected String timeSource;
    protected String timeQuality;
    protected String stationNameExt;
    protected String stationName;
    protected String streamName;
    protected String sampleRate;
    protected String triggerType;
    protected String triggerTime;
    protected String firstSampleTime;
    protected String detriggerTime;
    protected String lastSampleTime;
    protected String channelAdjustedNominalBitWeights;
    protected String channelTreeBitWeights;
    protected String channelGain;
    protected String channelADResolution;
    protected String channelFSA;
    protected String channelCode;
    protected String channelSensorFSA;
    protected String channelSensorVPU;
    protected String channelSensorUnits;
    protected String stationComment;
    protected String filterList;
    protected String position;
    protected int eventNumber;
    protected int dataStreamNumber;

    public EventTrailerPacket(EventTrailerPacket original) {
        if (original != null) {
            this.dataFormat = original.dataFormat;
            this.triggerTimeMessage = original.triggerTimeMessage;
            this.timeSource = original.timeSource;
            this.timeQuality = original.timeQuality;
            this.stationNameExt = original.timeQuality;
            this.stationName = original.timeQuality;
            this.streamName = original.timeQuality;
            this.sampleRate = original.timeQuality;
            this.triggerType = original.timeQuality;
            this.triggerTime = original.triggerTime;
            this.firstSampleTime = original.firstSampleTime;
            this.detriggerTime = original.firstSampleTime;
            this.lastSampleTime = original.lastSampleTime;
            this.channelAdjustedNominalBitWeights = original.channelAdjustedNominalBitWeights;
            this.channelTreeBitWeights = original.channelTreeBitWeights;
            this.channelGain = original.channelTreeBitWeights;
            this.channelADResolution = original.channelTreeBitWeights;
            this.channelFSA = original.channelTreeBitWeights;
            this.channelCode = original.channelTreeBitWeights;
            this.channelSensorFSA = original.channelTreeBitWeights;
            this.channelSensorVPU = original.channelTreeBitWeights;
            this.channelSensorUnits = original.channelTreeBitWeights;
            this.stationComment = original.stationComment;
            this.filterList = original.filterList;
            this.position = original.filterList;
            this.eventNumber = original.eventNumber;
            this.dataStreamNumber = original.dataStreamNumber;
        }
    }

    public EventTrailerPacket(DataInput in) throws IOException, RT130FormatException {
        this.read(in);
    }

    private void read(DataInput in) throws IOException, RT130FormatException {
        this.eventNumber = BCDRead.toInt(this.readBytes(in, 2));
        this.dataStreamNumber = BCDRead.toInt(this.readBytes(in, 1));
        in.skipBytes(4);
        this.dataFormat = HexRead.toString(this.readBytes(in, 1));
        this.triggerTimeMessage = new String(this.readBytes(in, 33));
        this.timeSource = new String(this.readBytes(in, 1));
        this.timeQuality = new String(this.readBytes(in, 1));
        this.stationNameExt = new String(this.readBytes(in, 1));
        this.stationName = new String(this.readBytes(in, 4));
        this.streamName = new String(this.readBytes(in, 16));
        this.sampleRate = new String(this.readBytes(in, 4));
        this.triggerType = new String(this.readBytes(in, 4));
        this.triggerTime = new String(this.readBytes(in, 16));
        this.firstSampleTime = new String(this.readBytes(in, 16));
        this.detriggerTime = new String(this.readBytes(in, 16));
        this.lastSampleTime = new String(this.readBytes(in, 16));
        this.channelAdjustedNominalBitWeights = new String(this.readBytes(in, 128));
        this.channelTreeBitWeights = new String(this.readBytes(in, 128));
        this.channelGain = new String(this.readBytes(in, 16));
        this.channelADResolution = new String(this.readBytes(in, 16));
        this.channelFSA = new String(this.readBytes(in, 16));
        this.channelCode = new String(this.readBytes(in, 64));
        this.channelSensorFSA = new String(this.readBytes(in, 16));
        this.channelSensorVPU = new String(this.readBytes(in, 96));
        this.channelSensorUnits = new String(this.readBytes(in, 16));
        in.skipBytes(206);
        this.stationComment = new String(this.readBytes(in, 40));
        this.filterList = new String(this.readBytes(in, 16));
        this.position = new String(this.readBytes(in, 26));
        in.skipBytes(80);
    }

    private byte[] readBytes(DataInput in, int numBytes) throws IOException {
        byte[] seqBytes = new byte[numBytes];
        in.readFully(seqBytes);
        return seqBytes;
    }
}

