/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.SiteId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.IfTimeSeries.TimeSeriesDataSel;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.LocationType;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.TimeUtils;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.SiteImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.mockFissures.IfNetwork.MockNetworkId;
import edu.sc.seis.fissuresUtil.rt130.PacketType;
import java.sql.Connection;
import java.util.Properties;

public class RT130ToLocalSeismogram {
    private Channel[] channel;
    private final String NETWORK_ID = "network.networkId";
    private final String STATION_NAME = "station.stationName";
    private final String NETWORK_BEGIN_TIME = "network.beginTime";
    private Connection conn;
    private Properties props;

    public RT130ToLocalSeismogram() {
        this.conn = null;
        this.props = null;
    }

    public RT130ToLocalSeismogram(Connection conn, Properties props) {
        this.conn = conn;
        this.props = props;
    }

    public LocalSeismogramImpl[] ConvertRT130ToLocalSeismogram(PacketType[] seismogramDataPacket) {
        LocalSeismogramImpl[] seismogramDataArray = new LocalSeismogramImpl[seismogramDataPacket.length];
        this.channel = new Channel[seismogramDataPacket.length];
        for (int i = 0; i < seismogramDataPacket.length; ++i) {
            seismogramDataArray[i] = this.ConvertRT130ToLocalSeismogram(seismogramDataPacket[i], i);
        }
        return seismogramDataArray;
    }

    public LocalSeismogramImpl ConvertRT130ToLocalSeismogram(PacketType seismogramData, int i) {
        ChannelId channelId;
        Time mockBeginTimeOfChannel = seismogramData.begin_time_from_state_of_health_file.getFissuresTime();
        int numPoints = seismogramData.number_of_samples;
        SamplingImpl sampling = new SamplingImpl(seismogramData.sample_rate, new TimeInterval(1.0, UnitImpl.SECOND));
        if (this.props == null || this.conn == null) {
            channelId = new ChannelId(MockNetworkId.createNetworkID(), seismogramData.unitIdNumber, "" + seismogramData.data_stream_number, "BH" + seismogramData.channel_name[seismogramData.channel_number], mockBeginTimeOfChannel);
        } else {
            this.channel[i] = this.createChannel(seismogramData, (Sampling)sampling);
            channelId = this.channel[i].get_id();
        }
        String id = channelId.toString();
        TimeSeriesDataSel timeSeriesDataSel = new TimeSeriesDataSel();
        timeSeriesDataSel.encoded_values(seismogramData.encoded_data);
        return new LocalSeismogramImpl(id, seismogramData.begin_time_of_seismogram.getFissuresTime(), numPoints, (Sampling)sampling, (Unit)UnitImpl.COUNT, channelId, timeSeriesDataSel);
    }

    private Channel createChannel(PacketType seismogramData, Sampling sampling) {
        QuantityImpl elevation;
        String stationCode = this.props.getProperty("station.stationName." + seismogramData.unitIdNumber);
        if (stationCode == null) {
            stationCode = seismogramData.unitIdNumber;
        }
        String networkIdString = "XX";
        ISOTime isoTime = new ISOTime(1970, 0, 0, 0, 0.0f);
        Time networkBeginTime = isoTime.getDate().getFissuresTime();
        Time channelBeginTime = seismogramData.begin_time_from_state_of_health_file.getFissuresTime();
        NetworkId networkId = new NetworkId(networkIdString, networkBeginTime);
        ChannelId channelId = new ChannelId(networkId, stationCode, "00", "BH" + seismogramData.channel_name[seismogramData.channel_number], channelBeginTime);
        TimeRange effectiveNetworkTime = new TimeRange(networkBeginTime, TimeUtils.timeUnknown);
        TimeRange effectiveChannelTime = new TimeRange(channelBeginTime, TimeUtils.timeUnknown);
        SiteId siteId = new SiteId(networkId, stationCode, "00", channelBeginTime);
        StationId stationId = new StationId(networkId, stationCode, channelBeginTime);
        QuantityImpl depth = elevation = new QuantityImpl(0.0, (Unit)UnitImpl.METER);
        Location location = new Location(seismogramData.latitude_, seismogramData.longitude_, (Quantity)elevation, (Quantity)depth, LocationType.from_int((int)0));
        NetworkAttrImpl networkAttr = new NetworkAttrImpl(networkId, "", "", "", effectiveNetworkTime);
        StationImpl station = new StationImpl(stationId, "", location, effectiveChannelTime, "", "", "", (NetworkAttr)networkAttr);
        SiteImpl site = new SiteImpl(siteId, location, effectiveChannelTime, (Station)station, "");
        ChannelImpl newChannel = new ChannelImpl(channelId, "", new Orientation(0.0f, -90.0f), sampling, effectiveChannelTime, (Site)site);
        return newChannel;
    }

    public Channel[] getChannels() {
        return this.channel;
    }
}

