/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130;

import edu.iris.Fissures.IfTimeSeries.EncodedData;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.rt130.BCDRead;
import edu.sc.seis.fissuresUtil.rt130.HexRead;
import edu.sc.seis.fissuresUtil.rt130.RT130FormatException;
import edu.sc.seis.fissuresUtil.rt130.packetTypes.AuxiliaryDataParameterPacket;
import edu.sc.seis.fissuresUtil.rt130.packetTypes.CalibrationParameterPacket;
import edu.sc.seis.fissuresUtil.rt130.packetTypes.DataPacket;
import edu.sc.seis.fissuresUtil.rt130.packetTypes.DataStreamParameterPacket;
import edu.sc.seis.fissuresUtil.rt130.packetTypes.EventHeaderPacket;
import edu.sc.seis.fissuresUtil.rt130.packetTypes.EventTrailerPacket;
import edu.sc.seis.fissuresUtil.rt130.packetTypes.OperatingModeParameterPacket;
import edu.sc.seis.fissuresUtil.rt130.packetTypes.StateOfHealthPacket;
import edu.sc.seis.fissuresUtil.rt130.packetTypes.StationChannelParameterPacket;
import java.io.DataInput;
import java.io.IOException;

public class PacketType {
    protected String packetType;
    protected String unitIdNumber;
    protected MicroSecondDate time;
    public String[] channel_name;
    public MicroSecondDate begin_time_from_state_of_health_file;
    public MicroSecondDate begin_time_of_seismogram;
    public MicroSecondDate begin_time_of_first_packet;
    public MicroSecondDate end_time_of_last_packet;
    protected int experimentNumber;
    protected int year;
    protected int byteCount;
    protected int packetSequence;
    public int number_of_samples;
    public int sample_rate;
    public int channel_number;
    public int data_stream_number;
    public float latitude_;
    public float longitude_;
    public EncodedData[] encoded_data;
    public AuxiliaryDataParameterPacket aDPP;
    public CalibrationParameterPacket cPP;
    public DataStreamParameterPacket dSPP;
    public DataPacket dP;
    public EventHeaderPacket eHP;
    public EventTrailerPacket eTP;
    public OperatingModeParameterPacket oMPP;
    public StationChannelParameterPacket sCPP;
    public StateOfHealthPacket sOHP;

    public PacketType() {
        this.encoded_data = new EncodedData[0];
    }

    public PacketType(DataInput in, boolean processData) throws IOException, RT130FormatException {
        this.encoded_data = new EncodedData[0];
        this.readNextPacket(in, processData);
    }

    public PacketType(PacketType original) throws RT130FormatException {
        this.packetType = original.packetType;
        this.unitIdNumber = original.unitIdNumber;
        this.time = original.time;
        this.begin_time_of_seismogram = original.begin_time_of_seismogram;
        this.begin_time_of_first_packet = original.begin_time_of_first_packet;
        this.end_time_of_last_packet = original.end_time_of_last_packet;
        this.experimentNumber = original.experimentNumber;
        this.year = original.year;
        this.byteCount = original.byteCount;
        this.packetSequence = original.packetSequence;
        this.number_of_samples = original.number_of_samples;
        this.sample_rate = original.sample_rate;
        this.encoded_data = original.encoded_data;
        this.begin_time_from_state_of_health_file = original.begin_time_from_state_of_health_file;
        this.latitude_ = original.latitude_;
        this.longitude_ = original.longitude_;
        this.channel_name = original.channel_name;
        this.channel_number = original.channel_number;
        this.data_stream_number = original.data_stream_number;
        if (original.aDPP != null) {
            this.aDPP = new AuxiliaryDataParameterPacket(original.aDPP);
        }
        if (original.cPP != null) {
            this.cPP = new CalibrationParameterPacket(original.cPP);
        }
        if (original.dSPP != null) {
            this.dSPP = new DataStreamParameterPacket(original.dSPP);
        }
        if (original.dP != null) {
            this.dP = new DataPacket(original.dP);
        }
        if (original.eHP != null) {
            this.eHP = new EventHeaderPacket(original.eHP);
        }
        if (original.eTP != null) {
            this.eTP = new EventTrailerPacket(original.eTP);
        }
        if (original.oMPP != null) {
            this.oMPP = new OperatingModeParameterPacket(original.oMPP);
        }
        if (original.sCPP != null) {
            this.sCPP = new StationChannelParameterPacket(original.sCPP);
        }
        if (original.sOHP != null) {
            this.sOHP = new StateOfHealthPacket(original.sOHP);
        }
    }

    public void readNextPacket(DataInput in, boolean processData) throws IOException, RT130FormatException {
        this.packetType = new String(this.readBytes(in, 2));
        this.experimentNumber = BCDRead.toInt(this.readBytes(in, 1));
        this.year = BCDRead.toInt(this.readBytes(in, 1));
        this.unitIdNumber = HexRead.toString(this.readBytes(in, 2));
        String timeString = BCDRead.toString(this.readBytes(in, 6));
        this.begin_time_of_first_packet = this.time = this.stringToMicroSecondDate(timeString, this.year + 2000);
        this.byteCount = BCDRead.toInt(this.readBytes(in, 2));
        this.packetSequence = BCDRead.toInt(this.readBytes(in, 2));
        if (this.packetType.equals("AD")) {
            this.aDPP = new AuxiliaryDataParameterPacket(in);
        } else if (this.packetType.equals("CD")) {
            this.cPP = new CalibrationParameterPacket(in);
        } else if (this.packetType.equals("DS")) {
            this.dSPP = new DataStreamParameterPacket(in);
        } else if (this.packetType.equals("DT")) {
            this.dP = new DataPacket(in, processData);
            if (processData) {
                this.encoded_data = new EncodedData[1];
                this.encoded_data[0] = new EncodedData(10, this.dP.dataFrames, this.dP.numberOfSamples, false);
            } else {
                this.encoded_data = new EncodedData[0];
            }
            this.channel_number = this.dP.channelNumber;
        } else if (this.packetType.equals("EH")) {
            this.eHP = new EventHeaderPacket(in);
            this.begin_time_of_seismogram = this.time;
            this.end_time_of_last_packet = this.time;
            this.sample_rate = Integer.valueOf(this.eHP.sampleRate.trim());
        } else if (this.packetType.equals("ET")) {
            this.eTP = new EventTrailerPacket(in);
        } else if (this.packetType.equals("OM")) {
            this.oMPP = new OperatingModeParameterPacket(in);
        } else if (this.packetType.equals("SC")) {
            this.sCPP = new StationChannelParameterPacket(in);
            this.channel_name = this.sCPP.channelName;
        } else if (this.packetType.equals("SH")) {
            this.sOHP = new StateOfHealthPacket(in);
        } else {
            System.err.println("First two bytes of Packet Header were not formatted correctly, and do not refer to a valid Packet Type.");
            throw new RT130FormatException();
        }
    }

    private byte[] readBytes(DataInput in, int numBytes) throws IOException {
        byte[] seqBytes = new byte[numBytes];
        in.readFully(seqBytes);
        return seqBytes;
    }

    private MicroSecondDate stringToMicroSecondDate(String timeString, int yearInt) throws RT130FormatException {
        String fractionsOfSecond = "";
        String seconds = "";
        String minutes = "";
        String hours = "";
        String daysOfYearReversed = "";
        if (timeString.length() >= 1) {
            fractionsOfSecond = "" + timeString.charAt(timeString.length() - 3);
            fractionsOfSecond = fractionsOfSecond + timeString.charAt(timeString.length() - 2);
            fractionsOfSecond = fractionsOfSecond + timeString.charAt(timeString.length() - 1);
        }
        if (timeString.length() >= 5) {
            seconds = "" + timeString.charAt(timeString.length() - 5);
            seconds = seconds + timeString.charAt(timeString.length() - 4);
        }
        if (timeString.length() >= 7) {
            minutes = "" + timeString.charAt(timeString.length() - 7);
            minutes = minutes + timeString.charAt(timeString.length() - 6);
        }
        if (timeString.length() >= 9) {
            hours = "" + timeString.charAt(timeString.length() - 9);
            hours = hours + timeString.charAt(timeString.length() - 8);
        }
        if (timeString.length() >= 10) {
            daysOfYearReversed = "" + timeString.charAt(timeString.length() - 10);
        }
        if (timeString.length() >= 11) {
            daysOfYearReversed = daysOfYearReversed + timeString.charAt(timeString.length() - 11);
        }
        if (timeString.length() >= 12) {
            daysOfYearReversed = daysOfYearReversed + timeString.charAt(timeString.length() - 12);
        }
        if (timeString.length() > 12 || timeString.length() < 9) {
            System.err.println("Cannot read time field of Packet Header.");
            throw new RT130FormatException();
        }
        String daysOfYear = "0";
        for (int i = daysOfYearReversed.length() - 1; i >= 0; --i) {
            daysOfYear = daysOfYear.concat("" + daysOfYearReversed.charAt(i));
        }
        int daysOfYearInt = Integer.valueOf(daysOfYear);
        int hoursInt = Integer.valueOf(hours);
        int minutesInt = Integer.valueOf(minutes);
        seconds = seconds.concat(".");
        seconds = seconds.concat(fractionsOfSecond);
        float secondsInt = Float.valueOf(seconds).floatValue();
        ISOTime isoTime = new ISOTime(yearInt, daysOfYearInt, hoursInt, minutesInt, secondsInt);
        return isoTime.getDate();
    }
}

