/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.rt130;

import edu.iris.Fissures.IfTimeSeries.EncodedData;
import edu.sc.seis.fissuresUtil.rt130.PacketType;
import edu.sc.seis.fissuresUtil.rt130.RT130FormatException;

public class Append {
    public static PacketType appendDataPacket(PacketType seismogramData, PacketType nextPacket, boolean processData) {
        seismogramData.channel_number = nextPacket.dP.channelNumber;
        seismogramData.data_stream_number = nextPacket.dP.dataStreamNumber;
        seismogramData.unitIdNumber = nextPacket.unitIdNumber;
        seismogramData.number_of_samples += nextPacket.dP.numberOfSamples;
        seismogramData.begin_time_of_first_packet = nextPacket.begin_time_of_first_packet;
        seismogramData.end_time_of_last_packet = nextPacket.end_time_of_last_packet;
        if (processData) {
            int i;
            int newArraySize = seismogramData.encoded_data.length + nextPacket.encoded_data.length;
            EncodedData[] data = new EncodedData[newArraySize];
            for (i = 0; i < seismogramData.encoded_data.length; ++i) {
                data[i] = seismogramData.encoded_data[i];
            }
            while (i < newArraySize) {
                data[i] = nextPacket.encoded_data[i - seismogramData.encoded_data.length];
                ++i;
            }
            seismogramData.encoded_data = data;
        }
        return seismogramData;
    }

    public static PacketType appendEventHeaderPacket(PacketType seismogramData, PacketType nextPacket) throws RT130FormatException {
        PacketType clone = new PacketType(nextPacket);
        return clone;
    }

    public static PacketType appendEventTrailerPacket(PacketType seismogramData, PacketType nextPacket) {
        return seismogramData;
    }

    public static PacketType appendAuxiliaryDataParameterPacket(PacketType stateOfHealthData, PacketType nextPacket) {
        if (stateOfHealthData.begin_time_from_state_of_health_file == null) {
            stateOfHealthData.begin_time_from_state_of_health_file = nextPacket.time;
        }
        return stateOfHealthData;
    }

    public static PacketType appendCalibrationParameterPacket(PacketType stateOfHealthData, PacketType nextPacket) {
        if (stateOfHealthData.begin_time_from_state_of_health_file == null) {
            stateOfHealthData.begin_time_from_state_of_health_file = nextPacket.time;
        }
        return stateOfHealthData;
    }

    public static PacketType appendDataStreamParameterPacket(PacketType stateOfHealthData, PacketType nextPacket) {
        if (stateOfHealthData.begin_time_from_state_of_health_file == null) {
            stateOfHealthData.begin_time_from_state_of_health_file = nextPacket.time;
        }
        return stateOfHealthData;
    }

    public static PacketType appendOperatingModeParameterPacket(PacketType stateOfHealthData, PacketType nextPacket) {
        if (stateOfHealthData.begin_time_from_state_of_health_file == null) {
            stateOfHealthData.begin_time_from_state_of_health_file = nextPacket.time;
        }
        return stateOfHealthData;
    }

    public static PacketType appendStateOfHealthPacket(PacketType stateOfHealthData, PacketType nextPacket) {
        if (stateOfHealthData.begin_time_from_state_of_health_file == null) {
            stateOfHealthData.begin_time_from_state_of_health_file = nextPacket.time;
        }
        if (stateOfHealthData.latitude_ == 0.0f) {
            stateOfHealthData.latitude_ = nextPacket.sOHP.latitude;
        }
        if (stateOfHealthData.longitude_ == 0.0f) {
            stateOfHealthData.longitude_ = nextPacket.sOHP.longitude;
        }
        return stateOfHealthData;
    }

    public static PacketType appendStationChannelParameterPacket(PacketType stateOfHealthData, PacketType nextPacket) {
        if (stateOfHealthData.begin_time_from_state_of_health_file == null) {
            stateOfHealthData.begin_time_from_state_of_health_file = nextPacket.time;
        }
        if (stateOfHealthData.channel_name == null) {
            stateOfHealthData.channel_name = nextPacket.channel_name;
        }
        return stateOfHealthData;
    }
}

