/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.parmo3d;

import javax.media.j3d.LineArray;
import javax.media.j3d.PointArray;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;

public class Shaker3D {
    public static final int SINE = 0;
    public static final int TRIANGLE = 1;
    public static final int BOX = 2;
    public static final int OTHER = 3;
    static final int NUMWAVES = 4;
    int numberOfPoints = 41;
    int wavetype = 0;
    float backAzimuth = 0.0f;
    float angleOfIncidence = 0.0f;
    boolean centered = true;

    public Shaker3D() {
    }

    public Shaker3D(int waveFlag, float baz, float angI) {
        this.backAzimuth = baz;
        this.angleOfIncidence = angI;
        this.setWaveType(waveFlag);
    }

    public Shaker3D(int waveFlag, int npts, float baz, float angI) {
        this.backAzimuth = baz;
        this.angleOfIncidence = angI;
        this.setWaveType(waveFlag);
        this.setNumPoints(npts);
    }

    public Shaker3D(int waveFlag) {
        this.setWaveType(waveFlag);
    }

    private Point3f rotateToZEN(double amplitude) {
        double z = amplitude * Math.cos(Math.toRadians(this.angleOfIncidence));
        double horizProjection = amplitude * Math.sin(Math.toRadians(this.angleOfIncidence));
        double n = horizProjection * Math.cos(Math.toRadians(this.backAzimuth));
        double e = horizProjection * Math.sin(Math.toRadians(this.backAzimuth));
        Point3d dblresult = new Point3d(z, e, n);
        Point3f result = new Point3f(dblresult);
        return result;
    }

    public void setWaveType(int waveFlag) {
        if (waveFlag < 4) {
            this.wavetype = waveFlag;
        } else {
            System.out.println("Bad Wave Flag: " + waveFlag);
        }
    }

    public int getWaveType() {
        return this.wavetype;
    }

    public void setNumPoints(int numPoints) {
        this.numberOfPoints = numPoints;
    }

    public int getNumPoints() {
        return this.numberOfPoints;
    }

    public void getWavePoints(Point3f[] wavePoints) {
        if (this.wavetype == 0 && this.centered) {
            int i;
            int halfwidth = this.numberOfPoints / 2;
            int quarterwidth = halfwidth / 2;
            for (i = 0; i < quarterwidth; ++i) {
                wavePoints[i] = new Point3f(0.0f, 0.0f, 0.0f);
                wavePoints[i + halfwidth] = new Point3f(0.0f, 0.0f, 0.0f);
            }
            double inc = Math.PI * 2 / (double)halfwidth;
            while (quarterwidth <= i && i < 3 * quarterwidth) {
                double pt = (double)(i - quarterwidth) * inc;
                double value = Math.sin(pt);
                wavePoints[i] = new Point3f();
                wavePoints[i] = this.rotateToZEN(value);
                ++i;
            }
        }
    }

    public void getWaveLineArray(LineArray waveLineArray) {
        int totalVertex = waveLineArray.getVertexCount();
        if (this.wavetype == 0 && this.centered) {
            int halfwidth = this.numberOfPoints / 2;
            int quarterwidth = halfwidth / 2;
            System.out.println(quarterwidth + " " + halfwidth + " " + this.numberOfPoints);
            int i = 0;
            int vertex = 0;
            waveLineArray.setCoordinate(vertex, new Point3f(0.0f, 0.0f, 0.0f));
            ++i;
            while (i <= quarterwidth) {
                waveLineArray.setCoordinate(++vertex, new Point3f(0.0f, 0.0f, 0.0f));
                waveLineArray.setCoordinate(++vertex, new Point3f(0.0f, 0.0f, 0.0f));
                ++i;
            }
            double inc = Math.PI * 2 / (double)halfwidth;
            ++vertex;
            int phase = 0;
            while (quarterwidth < i && i <= 3 * quarterwidth) {
                double pt = (double)phase * inc;
                double value = Math.sin(pt);
                Point3f point = this.rotateToZEN(value);
                waveLineArray.setCoordinate(vertex, point);
                waveLineArray.setCoordinate(++vertex, point);
                ++vertex;
                ++i;
                ++phase;
            }
            while (i < this.numberOfPoints) {
                waveLineArray.setCoordinate(vertex, new Point3f(0.0f, 0.0f, 0.0f));
                waveLineArray.setCoordinate(++vertex, new Point3f(0.0f, 0.0f, 0.0f));
                ++vertex;
                ++i;
            }
        }
    }

    public void getSeisPointArrays(PointArray zPointArray, PointArray ePointArray, PointArray nPointArray) {
        float xstart = -0.6f;
        float xinc = -2.0f * xstart / (float)(this.numberOfPoints - 1);
        float zbase = -0.32f;
        float nbase = -0.56f;
        float ebase = -0.8f;
        float scale = 0.2f;
        Point3f[] zPoints = new Point3f[this.numberOfPoints];
        Point3f[] nPoints = new Point3f[this.numberOfPoints];
        Point3f[] ePoints = new Point3f[this.numberOfPoints];
        if (this.wavetype == 0 && this.centered) {
            int halfwidth = this.numberOfPoints / 2;
            int quarterwidth = halfwidth / 2;
            int i = 0;
            zPoints[i] = new Point3f(xstart, zbase, 0.0f);
            nPoints[i] = new Point3f(xstart, nbase, 0.0f);
            ePoints[i] = new Point3f(xstart, ebase, 0.0f);
            ++i;
            while (i <= quarterwidth) {
                float xpt = xstart + (float)i * xinc;
                zPoints[i] = new Point3f(xpt, zbase, 0.0f);
                nPoints[i] = new Point3f(xpt, nbase, 0.0f);
                ePoints[i] = new Point3f(xpt, ebase, 0.0f);
                ++i;
            }
            double inc = Math.PI * 2 / (double)halfwidth;
            int phase = 1;
            while (quarterwidth < i && i <= 3 * quarterwidth) {
                double pt = (double)phase * inc;
                double value = Math.sin(pt);
                Point3f value3D = new Point3f();
                value3D = this.rotateToZEN(value);
                float[] zen = new float[3];
                value3D.get(zen);
                float xpt = xstart + (float)i * xinc;
                float zValue = zbase + scale * zen[0];
                float nValue = nbase + scale * zen[1];
                float eValue = ebase + scale * zen[2];
                zPoints[i] = new Point3f(xpt, zValue, 0.0f);
                nPoints[i] = new Point3f(xpt, nValue, 0.0f);
                ePoints[i] = new Point3f(xpt, eValue, 0.0f);
                ++i;
                ++phase;
            }
            while (i < this.numberOfPoints) {
                float xpt = xstart + (float)i * xinc;
                zPoints[i] = new Point3f(xpt, zbase, 0.0f);
                nPoints[i] = new Point3f(xpt, nbase, 0.0f);
                ePoints[i] = new Point3f(xpt, ebase, 0.0f);
                ++i;
            }
            int vertex = zPointArray.getVertexCount();
            ePointArray.setCoordinates(0, ePoints);
            nPointArray.setCoordinates(0, nPoints);
            zPointArray.setCoordinates(0, zPoints);
            for (i = 0; i < this.numberOfPoints; ++i) {
            }
        }
    }

    public static void main(String[] args) {
        Shaker3D shake = new Shaker3D();
        Shaker3D shake2 = new Shaker3D(2);
        float num = shake2.getWaveType();
    }
}

