/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.map.layers;

import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfNetwork.Station;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.fissuresUtil.chooser.AvailableStationDataEvent;
import edu.sc.seis.fissuresUtil.chooser.AvailableStationDataListener;
import edu.sc.seis.fissuresUtil.chooser.StationDataEvent;
import edu.sc.seis.fissuresUtil.chooser.StationDataListener;
import edu.sc.seis.fissuresUtil.chooser.StationSelectionEvent;
import edu.sc.seis.fissuresUtil.chooser.StationSelectionListener;
import edu.sc.seis.fissuresUtil.display.EQDataEvent;
import edu.sc.seis.fissuresUtil.display.EQSelectionEvent;
import edu.sc.seis.fissuresUtil.display.EQSelectionListener;
import edu.sc.seis.fissuresUtil.display.EventDataListener;
import edu.sc.seis.fissuresUtil.map.LayerProjectionUpdater;
import edu.sc.seis.fissuresUtil.map.graphics.OMStation;
import edu.sc.seis.fissuresUtil.map.layers.MouseAdapterLayer;
import edu.sc.seis.fissuresUtil.map.layers.StationLoc;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public class StationLayer
extends MouseAdapterLayer
implements StationDataListener,
StationSelectionListener,
AvailableStationDataListener,
EQSelectionListener,
EventDataListener {
    private boolean honorRepaint = true;
    private static int[] xPoints = new int[]{-5, 0, 5};
    private static int[] yPoints = new int[]{5, -5, 5};
    private OMGraphicList omgraphics = new OMGraphicList();
    private static String[] modeList = new String[]{SelectMouseMode.modeID};
    private EventAccessOperations currentEvent;
    private Map stationMap = new HashMap();
    private List stationNames = new ArrayList();
    private static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$map$layers$StationLayer == null ? (class$edu$sc$seis$fissuresUtil$map$layers$StationLayer = StationLayer.class$("edu.sc.seis.fissuresUtil.map.layers.StationLayer")) : class$edu$sc$seis$fissuresUtil$map$layers$StationLayer));
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$map$layers$StationLayer;

    public StationLayer() {
        this.setName("Seismogram Station Layer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        OMGraphicList oMGraphicList = this.omgraphics;
        synchronized (oMGraphicList) {
            this.omgraphics.render(g);
        }
    }

    public void projectionChanged(ProjectionEvent e) {
        LayerProjectionUpdater.update(e, this.omgraphics, this);
    }

    public void honorRepaint(boolean honor) {
        this.honorRepaint = honor;
    }

    public void repaint() {
        if (this.honorRepaint) {
            super.repaint();
        }
    }

    public void printStationLocs() {
        StationLoc[] stationLocs = this.getStationLocs();
        for (int i = 0; i < stationLocs.length; ++i) {
            System.out.println("<area href=\"javascript:flipImage(" + i + ")\" shape=\"poly\" coords=\"" + stationLocs[i].getImageMapStylePoly() + "\"/>");
        }
    }

    public StationLoc[] getStationLocs() {
        StationLoc[] stationLocs = new StationLoc[this.omgraphics.size()];
        Iterator it = this.omgraphics.iterator();
        int i = 0;
        while (it.hasNext()) {
            OMStation cur = (OMStation)it.next();
            Projection proj = this.getProjection();
            Point curXY = proj.forward(cur.getLat(), cur.getLon());
            int[] x = cur.getXs();
            int[] y = cur.getYs();
            int curX = (int)curXY.getX();
            int curY = (int)curXY.getY();
            int[] transX = new int[x.length];
            int[] transY = new int[y.length];
            for (int j = 0; j < x.length; ++j) {
                transX[j] = curX + x[j];
                transY[j] = curY + y[j];
            }
            stationLocs[i] = new StationLoc(cur.getStation(), transX, transY);
            ++i;
        }
        return stationLocs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stationDataChanged(StationDataEvent s) {
        Station[] stations = s.getStations();
        for (int i = 0; i < stations.length; ++i) {
            LinkedList<Station> stationList;
            if (!this.stationMap.containsKey(stations[i].name)) {
                this.stationNames.add(stations[i].name);
                OMGraphicList oMGraphicList = this.omgraphics;
                synchronized (oMGraphicList) {
                    this.omgraphics.add((OMGraphic)new OMStation(stations[i], this));
                }
            }
            if ((stationList = (LinkedList<Station>)this.stationMap.get(stations[i].name)) == null) {
                stationList = new LinkedList<Station>();
                this.stationMap.put(stations[i].name, stationList);
            }
            stationList.add(stations[i]);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stationDataCleared() {
        OMGraphicList oMGraphicList = this.omgraphics;
        synchronized (oMGraphicList) {
            this.stationMap.clear();
            this.omgraphics.clear();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stationSelectionChanged(StationSelectionEvent s) {
        OMGraphicList oMGraphicList = this.omgraphics;
        synchronized (oMGraphicList) {
            Station[] stations = s.getSelectedStations();
            Iterator it = this.omgraphics.iterator();
            while (it.hasNext()) {
                OMStation current = (OMStation)it.next();
                boolean selected = false;
                for (int i = 0; i < stations.length && !selected; ++i) {
                    if (!current.getStation().equals(stations[i])) continue;
                    current.select();
                    selected = true;
                }
                if (selected) continue;
                current.deselect();
            }
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stationAvailabiltyChanged(AvailableStationDataEvent e) {
        Station station = e.getStation();
        boolean isUp = e.stationIsUp();
        OMGraphicList oMGraphicList = this.omgraphics;
        synchronized (oMGraphicList) {
            Iterator it = this.omgraphics.iterator();
            boolean found = false;
            while (it.hasNext() && !found) {
                OMStation current = (OMStation)it.next();
                if (!current.getStation().name.equals(station.name)) continue;
                current.setIsUp(isUp);
                if (isUp) {
                    this.omgraphics.moveIndexedToTop(this.omgraphics.indexOf((OMGraphic)current));
                } else {
                    this.omgraphics.moveIndexedToBottom(this.omgraphics.indexOf((OMGraphic)current));
                }
                found = true;
            }
            if (!found) {
                logger.debug((Object)("no match for available data update, " + station.get_code() + " " + isUp));
            }
            this.repaint();
        }
    }

    public void eqSelectionChanged(EQSelectionEvent eqSelectionEvent) {
        Iterator it = this.omgraphics.iterator();
        while (it.hasNext()) {
            OMStation current = (OMStation)it.next();
            current.resetIsUp();
        }
        this.repaint();
        this.currentEvent = eqSelectionEvent.getEvents()[0];
    }

    public void eventDataAppended(EQDataEvent eqDataEvent) {
    }

    public void eventDataChanged(EQDataEvent eqDataEvent) {
    }

    public void eventDataCleared() {
        this.currentEvent = null;
    }

    public String[] getMouseModeServiceList() {
        return modeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mouseClicked(MouseEvent e) {
        OMStation current;
        Iterator it;
        this.maybeKillCurrentPopup();
        ArrayList<Station> stationsUnderMouse = new ArrayList<Station>();
        OMGraphicList oMGraphicList = this.omgraphics;
        synchronized (oMGraphicList) {
            it = this.omgraphics.iterator();
            while (it.hasNext()) {
                current = (OMStation)it.next();
                if (!current.contains(e.getX(), e.getY())) continue;
                stationsUnderMouse.add(current.getStation());
            }
        }
        if (stationsUnderMouse.size() > 0) {
            if (stationsUnderMouse.size() > 1) {
                JPopupMenu popup = new JPopupMenu();
                popup.setInvoker((Component)((Object)this));
                it = stationsUnderMouse.iterator();
                while (it.hasNext()) {
                    current = (Station)it.next();
                    final JMenuItem menuItem = new JMenuItem(StationLayer.getStationInfo((Station)current, this.currentEvent));
                    menuItem.addActionListener(new ActionListener((Station)current, popup){
                        private final /* synthetic */ Station val$current;
                        private final /* synthetic */ JPopupMenu val$popup;
                        {
                            this.val$current = val$current;
                            this.val$popup = val$popup;
                        }

                        public void actionPerformed(ActionEvent e) {
                            StationLayer.this.toggleStationSelection(this.val$current);
                            this.val$popup.setVisible(false);
                        }
                    });
                    menuItem.addMouseListener(new MouseAdapter(){

                        public void mouseEntered(MouseEvent e) {
                            menuItem.setArmed(true);
                        }

                        public void mouseExited(MouseEvent e) {
                            menuItem.setArmed(false);
                        }
                    });
                    popup.add(menuItem);
                }
                Point compLocation = e.getComponent().getLocationOnScreen();
                double[] popupLoc = new double[]{compLocation.getX(), compLocation.getY()};
                popup.setLocation((int)popupLoc[0] + e.getX(), (int)popupLoc[1] + e.getY());
                popup.setVisible(true);
                this.currentPopup = popup;
            } else {
                this.toggleStationSelection((Station)stationsUnderMouse.get(0));
            }
            return true;
        }
        return false;
    }

    public void toggleStationSelection(Station station) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mouseMoved(MouseEvent e) {
        this.maybeKillCurrentPopup();
        OMGraphicList oMGraphicList = this.omgraphics;
        synchronized (oMGraphicList) {
            Iterator it = this.omgraphics.iterator();
            while (it.hasNext()) {
                OMStation current = (OMStation)it.next();
                if (!current.contains(e.getX(), e.getY())) continue;
                Station station = current.getStation();
                this.fireRequestInfoLine(StationLayer.getStationInfo(station, this.currentEvent));
                return true;
            }
            return false;
        }
    }

    public static String getStationInfo(Station station, EventAccessOperations event) {
        StringBuffer buf = new StringBuffer();
        buf.append("Station: ");
        buf.append(station.my_network.get_code() + "." + station.get_code() + "-");
        buf.append(station.name);
        if (event != null) {
            try {
                double dist = StationLayer.calcDistEventFromLocation(station.my_location.latitude, station.my_location.longitude, event);
                buf.append(" | Distance from Event: ");
                buf.append(dist);
                buf.append(" deg");
            }
            catch (NoPreferredOrigin noPreferredOrigin) {
                // empty catch block
            }
        }
        return buf.toString();
    }

    public static double calcDistEventFromLocation(double latitude, double longitude, EventAccessOperations event) throws NoPreferredOrigin {
        Origin origin = event.get_preferred_origin();
        double dist = SphericalCoords.distance((double)origin.my_location.latitude, (double)origin.my_location.longitude, (double)latitude, (double)longitude);
        dist = (int)(dist * 100.0);
        return dist /= 100.0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

