/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.gmt;

import edu.sc.seis.fissuresUtil.bag.StreamPump;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.log4j.Logger;

public class GenericCommandExecute {
    private static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$gmt$GenericCommandExecute == null ? (class$edu$sc$seis$fissuresUtil$gmt$GenericCommandExecute = GenericCommandExecute.class$("edu.sc.seis.fissuresUtil.gmt.GenericCommandExecute")) : class$edu$sc$seis$fissuresUtil$gmt$GenericCommandExecute));
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$gmt$GenericCommandExecute;

    public static int execute(String command) throws InterruptedException, IOException {
        return GenericCommandExecute.execute(command, (Reader)new StringReader(""), System.out, System.err);
    }

    public static int execute(String command, Reader stdin, OutputStream stdout, OutputStream stderr) throws InterruptedException, IOException {
        return GenericCommandExecute.execute(command, stdin, new OutputStreamWriter(stdout), new OutputStreamWriter(stderr));
    }

    public static int execute(String command, Reader stdin, Writer stdout, Writer stderr) throws InterruptedException, IOException {
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(command);
        InputStreamReader reader = new InputStreamReader(proc.getInputStream());
        OutputStreamWriter inWriter = new OutputStreamWriter(proc.getOutputStream());
        InputStreamReader errReader = new InputStreamReader(proc.getErrorStream());
        StreamPump pump = new StreamPump(reader, stdout, false);
        pump.setName("stdout");
        pump.start();
        StreamPump errPump = new StreamPump(errReader, stderr, false);
        errPump.setName("stderr");
        errPump.start();
        StreamPump stdInPump = new StreamPump(stdin, inWriter, true);
        stdInPump.setName("stdin");
        stdInPump.start();
        int exitVal = proc.waitFor();
        try {
            pump.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            errPump.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            stdInPump.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        logger.info((Object)("command " + command + " returned exit value " + exitVal));
        if (!pump.hasCompleted() || !errPump.hasCompleted()) {
            throw new IllegalStateException("Pumps must complete: stdout:" + pump.hasCompleted() + "  stderr:" + errPump.hasCompleted() + "  exitValue:" + exitVal);
        }
        return exitVal;
    }

    public static void main(String[] args) {
        try {
            if (args.length > 0) {
                GenericCommandExecute.execute(args[0]);
            } else {
                GenericCommandExecute.execute("ls /bin");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

