/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.freq;

import edu.iris.Fissures.IfSeismogramDC.SeismogramAttr;
import edu.iris.Fissures.IfTimeSeries.TimeSeriesDataSel;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.freq.ButterworthFilter;
import edu.sc.seis.fissuresUtil.freq.Cmplx;
import edu.sc.seis.fissuresUtil.freq.SeisGramText;
import edu.sc.seis.fissuresUtil.sac.FissuresToSac;
import edu.sc.seis.fissuresUtil.sac.SacToFissures;
import edu.sc.seis.seisFile.sac.SacTimeSeries;

public class FilterTest {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage java edu.sc.seis.fissuresUtil.freq.FilterTest sacfile");
            System.exit(0);
        }
        try {
            float[] fdata;
            SacTimeSeries sac = new SacTimeSeries();
            sac.read(args[0]);
            LocalSeismogramImpl seis = SacToFissures.getSeismogram(sac);
            if (seis.can_convert_to_long()) {
                int[] idata = seis.get_as_longs();
                fdata = new float[idata.length];
                for (int i = 0; i < idata.length; ++i) {
                    fdata[i] = idata[i];
                }
            } else {
                fdata = seis.get_as_floats();
            }
            Cmplx[] fftdata = Cmplx.fft(fdata);
            SeisGramText localeText = new SeisGramText(null);
            ButterworthFilter filter = new ButterworthFilter(localeText, 0.1, 8.0, 2, 1);
            double dt = seis.getSampling().getPeriod().convertTo(UnitImpl.SECOND).getValue();
            Cmplx[] filtered = filter.apply(dt, fftdata);
            float[] outdata = Cmplx.fftInverse(filtered, seis.getNumPoints());
            TimeSeriesDataSel ts = new TimeSeriesDataSel();
            ts.flt_values(outdata);
            LocalSeismogramImpl outSeis = new LocalSeismogramImpl((SeismogramAttr)seis, ts);
            sac = FissuresToSac.getSAC(outSeis);
            sac.write("filter.out");
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

