/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.exceptionHandler;

import edu.sc.seis.fissuresUtil.exceptionHandler.DefaultExtractor;
import edu.sc.seis.fissuresUtil.exceptionHandler.ExceptionInterceptor;
import edu.sc.seis.fissuresUtil.exceptionHandler.ExceptionReporter;
import edu.sc.seis.fissuresUtil.exceptionHandler.ExceptionReporterUtils;
import edu.sc.seis.fissuresUtil.exceptionHandler.Extractor;
import edu.sc.seis.fissuresUtil.exceptionHandler.Log4jReporter;
import edu.sc.seis.fissuresUtil.exceptionHandler.Section;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class GlobalExceptionHandler {
    private static final String EXITONEXCEPTION = "fissuresUtil.exceptionHandler.exitOnException";
    private static final boolean exitOnException = Boolean.getBoolean("fissuresUtil.exceptionHandler.exitOnException");
    private static Map sectionToContents = new HashMap();
    private static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$exceptionHandler$GlobalExceptionHandler == null ? (class$edu$sc$seis$fissuresUtil$exceptionHandler$GlobalExceptionHandler = GlobalExceptionHandler.class$("edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler")) : class$edu$sc$seis$fissuresUtil$exceptionHandler$GlobalExceptionHandler));
    private static List reporters = Collections.synchronizedList(new ArrayList());
    private static List extractors = Collections.synchronizedList(new ArrayList());
    private static List interceptors = Collections.synchronizedList(new ArrayList());
    private static boolean showSysInfo = true;
    private static int numHandled = 0;
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$exceptionHandler$GlobalExceptionHandler;

    public static void handle(Throwable thrown) {
        GlobalExceptionHandler.handle("Houston, we have a problem...", thrown);
    }

    public static int getNumHandled() {
        return numHandled;
    }

    public static void handle(String message) {
        GlobalExceptionHandler.handle(message, new Exception());
    }

    public static void handle(String message, Throwable thrown) {
        GlobalExceptionHandler.handle(message, thrown, new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handle(String message, Throwable thrown, List additonalSections) {
        block15: {
            try {
                ExceptionInterceptor interceptor;
                Iterator intIt = interceptors.iterator();
                boolean handledByInterceptor = false;
                while (intIt.hasNext() && !(handledByInterceptor = (interceptor = (ExceptionInterceptor)intIt.next()).handle(message, thrown))) {
                }
                if (handledByInterceptor) break block15;
                if (reporters.size() == 0) {
                    System.err.println(message);
                    thrown.printStackTrace(System.err);
                    logger.error((Object)"handle exception, but there are no Reporters.", thrown);
                    break block15;
                }
                ArrayList<Object> parsedContents = new ArrayList<Object>(sectionToContents.size());
                Iterator<Object> it = sectionToContents.keySet().iterator();
                while (it.hasNext()) {
                    String name = (String)it.next();
                    parsedContents.add(new Section(name, GlobalExceptionHandler.parse(sectionToContents.get(name))));
                }
                if (showSysInfo) {
                    parsedContents.add(new Section("System Information", ExceptionReporterUtils.getSysInfo()));
                }
                it = additonalSections.iterator();
                while (it.hasNext()) {
                    parsedContents.add(it.next());
                }
                ArrayList<Throwable> reporterExceptions = new ArrayList<Throwable>();
                List list = reporters;
                synchronized (list) {
                    ++numHandled;
                    it = reporters.iterator();
                    while (it.hasNext()) {
                        try {
                            ((ExceptionReporter)it.next()).report(message, thrown, parsedContents);
                        }
                        catch (Throwable e) {
                            it.remove();
                            reporterExceptions.add(e);
                        }
                    }
                }
                it = reporterExceptions.iterator();
                while (it.hasNext()) {
                    GlobalExceptionHandler.handle("An exception reporter caused this exception.  It has been removed from the GlobalExceptionHandler", (Throwable)it.next());
                }
            }
            catch (Throwable e) {
                GlobalExceptionHandler.paranoid(e, thrown);
            }
        }
        if (exitOnException) {
            System.exit(1);
        }
    }

    public static void add(ExceptionInterceptor interceptor) {
        interceptors.add(interceptor);
    }

    public static void add(ExceptionInterceptor interceptor, int position) {
        interceptors.add(position, interceptor);
    }

    public static void remove(ExceptionInterceptor interceptor) {
        interceptors.remove(interceptor);
    }

    public static void add(Extractor extractor) {
        extractors.add(extractor);
    }

    static List getExtractors() {
        return extractors;
    }

    public static void add(ExceptionReporter reporter) {
        reporters.add(reporter);
    }

    public static void remove(ExceptionReporter reporter) {
        reporters.remove(reporter);
    }

    public static void add(String sectionName, File file) {
        sectionToContents.put(sectionName, file);
    }

    public static void append(String sectionName, String contents) {
        List<String> contentsList = null;
        if (sectionToContents.containsKey(sectionName)) {
            contentsList = (List)sectionToContents.get(sectionName);
        } else {
            contentsList = new LinkedList();
            sectionToContents.put(sectionName, contentsList);
        }
        if (contentsList.size() > 1000) {
            contentsList.remove(0);
        }
        contentsList.add(contents);
    }

    public static void registerWithAWTThread() {
        System.setProperty("sun.awt.exception.handler", "edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler");
    }

    private static String parse(Object item) throws IOException {
        if (item instanceof List) {
            return GlobalExceptionHandler.createString((List)item);
        }
        if (item instanceof File) {
            return GlobalExceptionHandler.createString((File)item);
        }
        throw new IllegalArgumentException();
    }

    private static String createString(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        StringBuffer message = new StringBuffer();
        String line = reader.readLine();
        while (line != null) {
            message.append(line + "\n");
            line = reader.readLine();
        }
        return message.toString();
    }

    private static String createString(List stringList) {
        StringBuffer message = new StringBuffer();
        Iterator it = stringList.iterator();
        while (it.hasNext()) {
            message.append((String)it.next() + "\n");
        }
        return message.toString();
    }

    private static void paranoid(Throwable e, Throwable thrown) {
        System.err.println("Caught an exception in the exception handler: " + e.toString());
        e.printStackTrace(System.err);
        System.err.println("Original exception was:" + thrown.toString());
        thrown.printStackTrace(System.err);
        try {
            logger.error((Object)"Caught an exception in the exception handler: ", e);
            logger.error((Object)"Original exception was:", thrown);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        GlobalExceptionHandler.add(new Log4jReporter());
        GlobalExceptionHandler.add(new DefaultExtractor());
    }
}

