/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.registrar;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.fissuresUtil.bag.TauPUtil;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.display.registrar.RelativeTimeConfig;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;

public class PhaseAlignedTimeConfig
extends RelativeTimeConfig {
    TauP_Time taup = null;
    String phaseName;

    public PhaseAlignedTimeConfig() {
        this("ttp");
    }

    public PhaseAlignedTimeConfig(String phaseName) {
        this.phaseName = phaseName;
    }

    public MicroSecondTimeRange getInitialTime(DataSetSeismogram seis) {
        DataSet ds = seis.getDataSet();
        EventAccessOperations eao = ds.getEvent();
        if (eao != null) {
            TimeInterval interval;
            MicroSecondDate phaseTime;
            Channel chan = ds.getChannel(seis.getRequestFilter().channel_id);
            if (chan == null) {
                return super.getInitialTime(seis);
            }
            Location stationLoc = chan.my_site.my_station.my_location;
            try {
                phaseTime = this.calculate(EventUtil.extractOrigin(eao), stationLoc);
            }
            catch (TauModelException e) {
                return super.getInitialTime(seis);
            }
            if (this.initialTime != null) {
                interval = this.initialTime.getInterval();
            } else {
                MicroSecondDate seisEndTime = new MicroSecondDate(seis.getRequestFilter().end_time);
                interval = new TimeInterval(phaseTime, seisEndTime);
            }
            MicroSecondTimeRange originRange = new MicroSecondTimeRange(phaseTime, interval);
            return originRange.shale(this.shift, this.scale);
        }
        return super.getInitialTime(seis);
    }

    protected void shaleInitialTime() {
        this.shaleTime(-0.1, 1.1);
    }

    public synchronized MicroSecondDate calculate(Origin origin, Location station) throws TauModelException {
        TauPUtil util = TauPUtil.getTauPUtil();
        Arrival[] arrivals = util.calcTravelTimes(station, origin, new String[]{this.phaseName});
        MicroSecondDate out = new MicroSecondDate(origin.origin_time);
        if (arrivals.length > 0) {
            out = out.add(new TimeInterval(arrivals[0].getTime(), UnitImpl.SECOND));
        }
        return out;
    }

    public synchronized String getPhaseName() {
        return this.phaseName;
    }

    public synchronized void setPhaseName(String phaseName) {
        this.phaseName = phaseName;
    }

    public String getTypeOfRelativity() {
        return "Time since the " + this.getPhaseName() + " arrival";
    }
}

