/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.registrar;

import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.fissuresUtil.display.registrar.BasicLayoutConfig;
import edu.sc.seis.fissuresUtil.display.registrar.LayoutData;
import edu.sc.seis.fissuresUtil.display.registrar.LayoutEvent;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;

public class CustomLayOutConfig
extends BasicLayoutConfig {
    private LayoutEvent lastEvent = LayoutEvent.EMPTY_EVENT;
    private double percent_offset;
    private double minDistance;
    private boolean swapAxes = false;
    private double maxDistance;

    public CustomLayOutConfig(double minDistance, double maxDistance, double percentSeisHeight) {
        this.percent_offset = percentSeisHeight / 100.0;
        double axisCorrection = (maxDistance - minDistance) * this.percent_offset;
        this.minDistance = minDistance - axisCorrection;
        this.maxDistance = maxDistance + axisCorrection;
    }

    public LayoutEvent getLayout() {
        return this.lastEvent;
    }

    public void setSwapAxes(boolean swapAxes) {
        this.swapAxes = swapAxes;
    }

    public synchronized LayoutEvent generateLayoutEvent() {
        DataSetSeismogram[] seis = this.getSeismograms();
        if (seis.length > 0) {
            double startDist = this.minDistance;
            double endDist = this.maxDistance;
            double totalDistance = endDist - startDist;
            LayoutData[] data = new LayoutData[seis.length];
            for (int i = 0; i < data.length; ++i) {
                DataSetSeismogram cur = seis[i];
                double curDist = ((QuantityImpl)this.valueMap.get(cur)).getValue();
                double centerPercentage = 0.0;
                double cpVal = (endDist - curDist) / totalDistance;
                centerPercentage = this.swapAxes ? 1.0 - cpVal : cpVal;
                data[i] = new LayoutData(cur, centerPercentage - this.percent_offset, centerPercentage + this.percent_offset);
            }
            UnitRangeImpl range = new UnitRangeImpl(startDist, endDist, (Unit)UnitImpl.DEGREE);
            this.lastEvent = new LayoutEvent(data, range);
            return this.lastEvent;
        }
        this.lastEvent = LayoutEvent.EMPTY_EVENT;
        return this.lastEvent;
    }
}

