/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.particlemotion;

import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.borders.TitleBorder;
import edu.sc.seis.fissuresUtil.display.particlemotion.ParticleMotionDisplay;
import edu.sc.seis.fissuresUtil.display.particlemotion.ParticleMotionDisplayDrawable;
import edu.sc.seis.fissuresUtil.display.particlemotion.SelfDrawableTitleProvider;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;

public class ParticleMotionSelfDrawableTitleProvider
extends MouseAdapter
implements MouseMotionListener,
SelfDrawableTitleProvider {
    private Color drawColorOfBigX = Color.BLACK;
    private Color titleColor;
    private int xDrawMax;
    private int xDrawMin;
    private int yDrawMax;
    private int yDrawMin;
    private double horzXMin;
    private double horzXMax;
    private double horzYMin;
    private double horzYMax;
    private double vertXMin;
    private double vertXMax;
    private double vertYMin;
    private double vertYMax;
    private boolean visible = true;
    private Font font = DisplayUtils.DEFAULT_FONT;
    private final int DEFAULT_LENGTH = 5;
    private String title;
    private int count = 0;
    private ParticleMotionDisplayDrawable drawable;
    private SeismogramDisplay parent;
    private TitleBorder border;

    public ParticleMotionSelfDrawableTitleProvider(TitleBorder border, String title, ParticleMotionDisplayDrawable drawable, SeismogramDisplay parent) {
        this(border, title, DisplayUtils.DEFAULT_FONT, drawable, parent);
    }

    public ParticleMotionSelfDrawableTitleProvider(TitleBorder border, String title, Font f, ParticleMotionDisplayDrawable drawable, SeismogramDisplay parent) {
        this.setTitle(title);
        this.parent = parent;
        this.drawable = drawable;
        this.border = border;
        this.setTitleFont(f);
        this.border.addMouseListener(this);
        this.border.addMouseMotionListener(this);
    }

    public String getTitle() {
        return this.title;
    }

    public Font getTitleFont() {
        return this.font;
    }

    public void setTitleFont(Font f) {
        this.font = f;
    }

    public void setTitleColor(Color c) {
        this.titleColor = c;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public Rectangle2D getBounds(Graphics2D canvas) {
        FontMetrics fm = canvas.getFontMetrics();
        Rectangle2D stringBounds = fm.getStringBounds(this.title, canvas);
        double height = this.findMaxHeight(stringBounds.getHeight());
        double width = stringBounds.getWidth() + 5.0;
        Rectangle rec = new Rectangle();
        ((Rectangle2D)rec).setRect(0.0, 0.0, width, height);
        return rec;
    }

    public void draw(int x, int y, Graphics2D canvas) {
        this.xDrawMin = x;
        this.xDrawMax = x + 5;
        this.yDrawMin = y;
        this.yDrawMax = y + 5;
        if (this.visible && !SeismogramDisplay.PRINTING) {
            canvas.setColor(this.drawColorOfBigX);
            canvas.setStroke(DisplayUtils.THREE_PIXEL_STROKE);
            canvas.drawLine(this.xDrawMin, this.yDrawMin, this.xDrawMax, this.yDrawMax);
            canvas.drawLine(this.xDrawMin, this.yDrawMax, this.xDrawMax, this.yDrawMin);
            canvas.setStroke(DisplayUtils.ONE_PIXEL_STROKE);
            canvas.setColor(this.titleColor);
            canvas.drawString(this.title, this.xDrawMax + 5, this.yDrawMax + 2);
        }
    }

    public void setVisibility(boolean visible) {
        this.visible = visible;
    }

    public void mouseDragged(MouseEvent e) {
        if (this.intersects(e)) {
            this.setDrawColorOfBigX(Color.RED);
            this.repaint();
        } else {
            this.setDrawColorOfBigX(Color.BLACK);
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this.intersects(e)) {
            ((ParticleMotionDisplay)this.parent).remove(this.drawable.getSeismogram());
            ((ParticleMotionDisplay)this.parent).removeTitle(this.drawable);
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this.intersects(e)) {
            this.setDrawColorOfBigX(Color.RED);
            this.repaint();
        } else {
            this.setDrawColorOfBigX(Color.BLACK);
            this.repaint();
        }
    }

    private void repaint() {
        this.border.repaint();
    }

    protected boolean intersects(MouseEvent e) {
        int clickX = e.getX();
        int clickY = e.getY();
        if ((double)clickX >= this.horzXMin && (double)clickX <= this.horzXMax && (double)clickY >= this.horzYMin && (double)clickY <= this.horzYMax) {
            return true;
        }
        return (double)clickX >= this.vertXMin && (double)clickX <= this.vertXMax && (double)clickY >= this.vertYMin && (double)clickY <= this.vertYMax;
    }

    public void setVerticalCoordinates(double x, double y) {
        this.vertXMin = x;
        this.vertXMax = x + 5.0;
        this.vertYMin = y;
        this.vertYMax = y + 5.0;
    }

    public void setHorizontalCoordinates(double x, double y) {
        this.horzXMin = x;
        this.horzXMax = x + 5.0;
        this.horzYMin = y;
        this.horzYMax = y + 5.0;
    }

    private void setDrawColorOfBigX(Color newColor) {
        this.drawColorOfBigX = newColor;
    }

    public Color getDrawColorOfBigX() {
        return this.drawColorOfBigX;
    }

    private double findMaxHeight(double num) {
        if (num > 5.0) {
            return num;
        }
        return 5.0;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

