/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.particlemotion;

import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.display.SeismogramContainer;
import edu.sc.seis.fissuresUtil.display.SeismogramContainerFactory;
import edu.sc.seis.fissuresUtil.display.SeismogramContainerListener;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramIterator;
import edu.sc.seis.fissuresUtil.display.SimplePlotUtil;
import edu.sc.seis.fissuresUtil.display.drawable.Drawable;
import edu.sc.seis.fissuresUtil.display.particlemotion.ParticleMotionDirectionBorder;
import edu.sc.seis.fissuresUtil.display.particlemotion.ParticleMotionSelfDrawableTitleProvider;
import edu.sc.seis.fissuresUtil.display.particlemotion.SeisContainer;
import edu.sc.seis.fissuresUtil.display.registrar.AmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.AmpEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeEvent;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.LinkedList;
import java.util.List;

public class ParticleMotionDisplayDrawable
implements Drawable,
SeismogramContainerListener {
    private Color color;
    private boolean visible = true;
    List sectors = new LinkedList();
    private SeismogramDisplay parent;
    private SeisContainer container;
    private static final boolean DEFAULT_VISIBILITY = true;
    private List children;
    private SeismogramContainer horiz;
    private SeismogramContainer vert;
    private TimeConfig tc;
    private AmpConfig ac;
    private boolean horizPlane;
    protected Shape s;
    private MicroSecondTimeRange timeRange;
    private static boolean defaultVisibility = true;
    private ParticleMotionSelfDrawableTitleProvider top;
    private ParticleMotionSelfDrawableTitleProvider right;

    public ParticleMotionDisplayDrawable(SeismogramDisplay parent, SeisContainer cont) {
        this(parent, cont, ParticleMotionDisplayDrawable.colorGenerator());
    }

    protected ParticleMotionDisplayDrawable(SeismogramDisplay parent, SeisContainer cont, Color color) {
        this.parent = parent;
        this.container = cont;
        this.color = color;
        this.horiz = SeismogramContainerFactory.create(this, cont.getHorz());
        this.vert = SeismogramContainerFactory.create(this, cont.getVert());
        this.setVisibility(defaultVisibility);
    }

    private static Color colorGenerator() {
        return new Color(ParticleMotionDisplayDrawable.genNumber(), ParticleMotionDisplayDrawable.genNumber(), ParticleMotionDisplayDrawable.genNumber());
    }

    private static float genNumber() {
        return (float)Math.random();
    }

    public void draw(Graphics2D canvas, Dimension size, TimeEvent currentTime, AmpEvent currentAmp) {
        SeismogramIterator hiter = this.horiz.getIterator();
        SeismogramIterator viter = this.vert.getIterator();
        hiter.setTimeRange(currentTime.getTime(this.container.getHorz()));
        viter.setTimeRange(viter.getSeisTime());
        if (this.horiz.getIterator(currentTime.getTime()).numPointsLeft() <= 0 || this.vert.getIterator(currentTime.getTime()).numPointsLeft() <= 0) {
            return;
        }
        canvas.setColor(this.color);
        canvas.setStroke(DisplayUtils.TWO_PIXEL_STROKE);
        GeneralPath generalPath = new GeneralPath(0);
        boolean prevPointBad = true;
        SeismogramIterator hIt = this.horiz.getIterator(currentTime.getTime());
        UnitImpl horizUnit = hIt.getUnit();
        UnitRangeImpl horizRange = currentAmp.getAmp(this.horiz.getDataSetSeismogram()).convertTo(horizUnit);
        double hMin = horizRange.getMinValue();
        double hMax = horizRange.getMaxValue();
        SeismogramIterator vIt = this.vert.getIterator(currentTime.getTime());
        UnitImpl vertUnit = vIt.getUnit();
        UnitRangeImpl vertRange = currentAmp.getAmp(this.vert.getDataSetSeismogram()).convertTo(vertUnit);
        double vMin = vertRange.getMinValue();
        double vMax = vertRange.getMaxValue();
        while (hIt.hasNext() && vIt.hasNext()) {
            double hVal = this.getVal(hIt, hMin, hMax, size.height);
            double vVal = this.getVal(vIt, vMin, vMax, size.height);
            if (hVal == 2.147483647E9 || vVal == 2.147483647E9) {
                prevPointBad = true;
                continue;
            }
            vVal *= -1.0;
            vVal += (double)size.height;
            if (prevPointBad) {
                generalPath.moveTo((int)hVal, (int)vVal);
                prevPointBad = false;
                continue;
            }
            generalPath.lineTo((int)hVal, (int)vVal);
        }
        canvas.draw(generalPath);
    }

    private double getVal(SeismogramIterator it, double minAmp, double maxAmp, int size) {
        double itVal = ((QuantityImpl)it.next()).getValue();
        itVal = Double.isNaN(itVal) ? 2.147483647E9 : (double)Math.round(SimplePlotUtil.linearInterp(minAmp, 0.0, maxAmp, size, itVal));
        return itVal;
    }

    public boolean equals(SeismogramDisplay parent, SeisContainer container) {
        return this.parent.equals(parent) && this.container.equals(container);
    }

    public void setVisibility(boolean vis) {
        DataSetSeismogram[] seis = this.container.getSeismograms();
        if (vis) {
            this.parent.getTimeConfig().add(seis);
            this.parent.getAmpConfig().add(seis);
        } else {
            this.parent.getTimeConfig().remove(seis);
            this.parent.getAmpConfig().remove(seis);
        }
        if (this.visible != vis) {
            this.parent.repaint();
        }
        this.visible = vis;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public SeisContainer getSeismogram() {
        return this.container;
    }

    public String getVName() {
        return this.container.getVert().getName();
    }

    public String getHName() {
        return this.container.getHorz().getName();
    }

    public void updateData() {
        this.parent.repaint();
    }

    public static void setDefaultVisibility(boolean visible) {
        defaultVisibility = visible;
    }

    public void setTopTitle(ParticleMotionDirectionBorder top) {
        this.top = top.addLabel(this.getHName(), this);
        this.top.setTitleColor(this.color);
    }

    public void setRightTitle(ParticleMotionDirectionBorder right) {
        this.right = right.addLabel(this.getVName(), this);
        this.right.setTitleColor(this.color);
    }

    public ParticleMotionSelfDrawableTitleProvider getTopTitle() {
        return this.top;
    }

    public ParticleMotionSelfDrawableTitleProvider getRightTitle() {
        return this.right;
    }

    public SeismogramDisplay getParent() {
        return this.parent;
    }
}

