/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.particlemotion;

import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplayProvider;
import edu.sc.seis.fissuresUtil.display.borders.AmpBorder;
import edu.sc.seis.fissuresUtil.display.drawable.Drawable;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableIterator;
import edu.sc.seis.fissuresUtil.display.drawable.SeismogramRemover;
import edu.sc.seis.fissuresUtil.display.particlemotion.ParticleMotionDirectionBorder;
import edu.sc.seis.fissuresUtil.display.particlemotion.ParticleMotionDisplayDrawable;
import edu.sc.seis.fissuresUtil.display.particlemotion.SeisContainer;
import edu.sc.seis.fissuresUtil.display.registrar.AmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.AmpEvent;
import edu.sc.seis.fissuresUtil.display.registrar.AmpListener;
import edu.sc.seis.fissuresUtil.display.registrar.IndividualizedAmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeListener;
import edu.sc.seis.fissuresUtil.freq.NamedFilter;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;

public class ParticleMotionDisplay
extends SeismogramDisplay
implements TimeListener,
AmpListener {
    public static final int PREFERRED_HEIGHT = 150;
    public static final int PREFERRED_WIDTH = 250;
    private LinkedList drawables = new LinkedList();
    private TimeConfig tc;
    private AmpConfig ac;
    private TimeEvent timeEvent;
    private AmpEvent ampEvent;
    private List seismograms = new ArrayList();
    private boolean initialized = false;
    public static final int ASCENDING = 0;
    public static final int DESCENDING = 4;
    private Color color = Color.BLACK;
    private ParticleMotionDirectionBorder top;
    private ParticleMotionDirectionBorder right;
    private SeismogramRemover remover;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    private static int count = 0;
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$display$particlemotion$ParticleMotionDisplayDrawable;
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$display$drawable$Drawable;

    public ParticleMotionDisplay(TimeConfig tc, AmpConfig ac) {
        System.out.println("yes we're here!");
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add(new AmpBorder(this, 0, false), 3);
        this.add(new AmpBorder(this, 3, false), 7);
        this.right = new ParticleMotionDirectionBorder(0, 0, this);
        this.add(this.right, 5);
        this.top = new ParticleMotionDirectionBorder(2, 0, this);
        this.add(this.top, 1);
        this.setTimeConfig(tc);
        this.setAmpConfig(ac);
    }

    public SeismogramDisplayProvider createCenter() {
        ParticleMotionProvider pmp = new ParticleMotionProvider();
        pmp.addMouseListener(ParticleMotionDisplay.getMouseForwarder());
        pmp.addMouseMotionListener(ParticleMotionDisplay.getMouseMotionForwarder());
        pmp.setPreferredSize(new Dimension(250, 150));
        return pmp;
    }

    public void add(DataSetSeismogram horizontal, DataSetSeismogram vertical) {
        this.add(new SeisContainer(horizontal, vertical));
    }

    public void add(DataSetSeismogram[] seismos) {
    }

    public void add(SeisContainer cont) {
        ParticleMotionDisplayDrawable tempDraw;
        if (cont == null) {
            return;
        }
        if (!this.seismograms.contains(cont)) {
            this.seismograms.add(cont);
        }
        if (!this.drawables.contains(tempDraw = new ParticleMotionDisplayDrawable(this, cont))) {
            this.drawables.add(tempDraw);
            tempDraw.setTopTitle(this.top);
            tempDraw.setRightTitle(this.right);
            this.getTimeConfig().add(this.getSeismograms());
            this.getAmpConfig().add(this.getSeismograms());
        }
        this.initialized = true;
        Iterator e = activeFilters.iterator();
        while (e.hasNext()) {
            DisplayUtils.applyFilter((NamedFilter)e.next(), new DrawableIterator(class$edu$sc$seis$fissuresUtil$display$particlemotion$ParticleMotionDisplayDrawable == null ? ParticleMotionDisplay.class$("edu.sc.seis.fissuresUtil.display.particlemotion.ParticleMotionDisplayDrawable") : class$edu$sc$seis$fissuresUtil$display$particlemotion$ParticleMotionDisplayDrawable, this.drawables));
        }
    }

    public void remove(Drawable drawable) {
    }

    public void add(Drawable drawable) {
    }

    public DrawableIterator getDrawables(MouseEvent e) {
        return new DrawableIterator(class$edu$sc$seis$fissuresUtil$display$drawable$Drawable == null ? (class$edu$sc$seis$fissuresUtil$display$drawable$Drawable = ParticleMotionDisplay.class$("edu.sc.seis.fissuresUtil.display.drawable.Drawable")) : class$edu$sc$seis$fissuresUtil$display$drawable$Drawable, new ArrayList());
    }

    public DataSetSeismogram[] getSeismograms() {
        DataSetSeismogram[] returnArray = new DataSetSeismogram[this.seismograms.size() * 2];
        Iterator iter = this.seismograms.iterator();
        int n = -1;
        while (iter.hasNext()) {
            SeisContainer tempSeis = (SeisContainer)iter.next();
            returnArray[++n] = tempSeis.getHorz();
            returnArray[++n] = tempSeis.getVert();
        }
        return returnArray;
    }

    public void reset() {
        this.tc.reset();
        this.ac.reset();
    }

    public void reset(DataSetSeismogram[] seismos) {
        this.tc.reset(seismos);
        this.ac.reset(seismos);
    }

    public void setAmpConfig(AmpConfig ampConfig) {
        if (this.seismograms == null) {
            return;
        }
        if (this.ac != null) {
            this.ac.removeListener(this);
            this.tc.removeListener(this.ac);
            this.ac.remove(this.getSeismograms());
        }
        this.ac = ampConfig;
        this.ac.addListener(this);
        this.tc.addListener(this.ac);
        this.ac.add(this.getSeismograms());
    }

    public void setGlobalizedAmpConfig(AmpConfig ampConfig) {
        this.setAmpConfig(this.ac);
    }

    public void setIndividualizedAmpConfig(AmpConfig ampConfig) {
        this.setAmpConfig(new IndividualizedAmpConfig(this.ac));
    }

    public AmpConfig getAmpConfig() {
        return this.ac;
    }

    public void setTimeConfig(TimeConfig timeConfig) {
        if (this.tc != null) {
            this.tc.removeListener(this);
            this.tc.removeListener(this.ac);
            this.tc.add(this.getSeismograms());
        }
        this.tc = timeConfig;
        this.tc.addListener(this);
        this.tc.addListener(this.ac);
        this.tc.add(this.getSeismograms());
    }

    public TimeConfig getTimeConfig() {
        return this.tc;
    }

    public DrawableIterator iterator(Class drawableClass) {
        return new DrawableIterator(drawableClass, this.drawables);
    }

    public void print() {
    }

    public void remove(SeisContainer seismos) {
        System.out.println("the size of seismograms before remove is: " + this.seismograms.size());
        if (this.seismograms.contains(seismos)) {
            this.seismograms.remove(seismos);
        }
        Iterator iter = this.drawables.iterator();
        while (iter.hasNext()) {
            ParticleMotionDisplayDrawable draw = (ParticleMotionDisplayDrawable)iter.next();
            if (!draw.equals(this, seismos)) continue;
            iter.remove();
        }
        if (this.seismograms.size() == 0) {
            this.clear();
        }
        this.tc.remove(seismos.getSeismograms());
        this.ac.remove(seismos.getSeismograms());
        System.out.println("the size of seismograms after remove is: " + this.seismograms.size());
    }

    public void remove(DataSetSeismogram[] seismos) {
        for (int i = 0; i < seismos.length; ++i) {
            if (seismos[i] == null || !this.seismograms.contains(seismos[i])) continue;
            this.seismograms.remove(seismos[i]);
        }
        this.removeDrawable(seismos);
        if (this.seismograms.size() == 0) {
            this.clear();
        }
        this.tc.remove(seismos);
        this.ac.remove(seismos);
        System.out.println("after remove: ");
        System.out.println("the size of seismograms is: " + this.seismograms.size());
    }

    private void removeDrawable(DataSetSeismogram[] seismos) {
        Iterator iter = this.drawables.iterator();
        for (int i = 0; i < seismos.length - 1; i += 2) {
            if (seismos[i] == null || seismos[i + 1] == null) continue;
            SeisContainer cont = new SeisContainer(seismos[i], seismos[i + 1]);
            while (iter.hasNext()) {
                Drawable current = (Drawable)iter.next();
                if (!(current instanceof ParticleMotionDisplayDrawable) || !((ParticleMotionDisplayDrawable)current).getSeismogram().equals(cont)) continue;
                iter.remove();
                this.repaint();
            }
        }
    }

    public void clear() {
        this.tc.remove(this.getSeismograms());
        this.ac.remove(this.getSeismograms());
    }

    public boolean initialized() {
        return this.initialized;
    }

    public void drawSeismograms(Graphics2D g2, Dimension size) {
        g2.setColor(Color.WHITE);
        g2.fill(new Rectangle2D.Float(0.0f, 0.0f, size.width, size.height));
        for (int i = 0; i < this.drawables.size(); ++i) {
            Drawable parMoDrawable = (Drawable)this.drawables.get(i);
            parMoDrawable.draw(g2, size, this.timeEvent, this.ampEvent);
        }
    }

    private boolean isNumberOdd(int n) {
        return n % 2 != 0;
    }

    public MicroSecondTimeRange getTime() {
        return this.timeEvent.getTime();
    }

    public void updateTime(TimeEvent event) {
        this.timeEvent = event;
        this.repaint();
    }

    public void updateAmp(AmpEvent event) {
        this.ampEvent = event;
        this.repaint();
    }

    public boolean contains(DataSetSeismogram seismo) {
        return false;
    }

    public void removeTitle(ParticleMotionDisplayDrawable draw) {
        this.top.removeTitle(draw);
        this.right.removeTitle(draw);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ParticleMotionProvider
    extends SeismogramDisplayProvider {
        private ParticleMotionProvider() {
        }

        public SeismogramDisplay provide() {
            return ParticleMotionDisplay.this;
        }

        public void paintComponent(Graphics g) {
            count++;
            System.out.println("count is " + count);
            ParticleMotionDisplay.this.drawSeismograms((Graphics2D)g, this.getSize());
        }
    }
}

