/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.drawable;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.drawable.Drawable;
import edu.sc.seis.fissuresUtil.display.registrar.AmpEvent;
import edu.sc.seis.fissuresUtil.display.registrar.BasicTimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.PhaseAlignedTimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.RTTimeRangeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeListener;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.apache.log4j.Category;

public class Selection
implements TimeListener,
Drawable {
    private SeismogramDisplay parent;
    private SeismogramDisplay child;
    private TimeConfig tc = new BasicTimeConfig();
    private DataSetSeismogram[] seismos;
    private Color color;
    private boolean selectedBegin;
    private boolean visible = true;
    private TimeEvent latestTime;
    private static Category logger = Category.getInstance((String)(class$edu$sc$seis$fissuresUtil$display$drawable$Selection == null ? (class$edu$sc$seis$fissuresUtil$display$drawable$Selection = Selection.class$("edu.sc.seis.fissuresUtil.display.drawable.Selection")) : class$edu$sc$seis$fissuresUtil$display$drawable$Selection).getName());
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$display$drawable$Selection;

    public Selection(MicroSecondTimeRange range, SeismogramDisplay parent, Color color) {
        TimeConfig parentConfig = parent.getTimeConfig();
        if (parentConfig instanceof RTTimeRangeConfig) {
            parentConfig = ((RTTimeRangeConfig)parentConfig).getInternalConfig();
        }
        Class<?> dispTimeConfigClass = parentConfig.getClass();
        try {
            this.tc = (TimeConfig)dispTimeConfigClass.newInstance();
            if (parentConfig instanceof PhaseAlignedTimeConfig) {
                ((PhaseAlignedTimeConfig)this.tc).setPhaseName(((PhaseAlignedTimeConfig)parentConfig).getPhaseName());
            }
        }
        catch (IllegalAccessException e) {
            GlobalExceptionHandler.handle("Problem trying to create new TimeCongig for pick zone", e);
        }
        catch (InstantiationException e) {
            GlobalExceptionHandler.handle("Problem trying to create new TimeCongig for pick zone", e);
        }
        this.seismos = parent.getSeismograms();
        this.parent = parent;
        this.color = color;
        this.tc.addListener(this);
        this.tc.add(this.seismos);
        this.setBegin(range.getBeginTime());
        this.setInterval(range.getInterval());
        parent.repaint();
    }

    public void updateTime(TimeEvent event) {
        this.latestTime = event;
        this.repaintParent();
    }

    public void toggleVisibility() {
        this.visible = !this.visible;
    }

    public void setVisibility(boolean b) {
        this.visible = b;
    }

    public boolean isVisible(TimeEvent externalTime) {
        MicroSecondTimeRange currentExternal = externalTime.getTime();
        MicroSecondTimeRange currentInternal = this.latestTime.getTime();
        return this.visible && currentExternal.getBeginTime().getMicroSecondTime() < currentInternal.getEndTime().getMicroSecondTime() && currentExternal.getEndTime().getMicroSecondTime() > currentInternal.getBeginTime().getMicroSecondTime();
    }

    public void draw(Graphics2D canvas, Dimension size, TimeEvent timeEvent, AmpEvent ampEvent) {
        if (this.isVisible(timeEvent)) {
            Rectangle2D.Float selection = new Rectangle2D.Float(this.getX(size.width, timeEvent), -1.0f, (float)(this.getWidth(timeEvent) * (double)size.width), size.height + 1);
            canvas.setPaint(this.color);
            canvas.fill(selection);
            canvas.setPaint(this.color.darker());
            canvas.setStroke(DisplayUtils.THREE_PIXEL_STROKE);
            canvas.draw(selection);
        }
    }

    public boolean isRemoveable() {
        return this.latestTime.getTime().getInterval().getValue() / this.parent.getTimeConfig().getTime().getInterval().getValue() < 0.01;
    }

    public void remove() {
        this.parent.remove(this);
        if (this.child != null) {
            this.child.remove(this.getSeismograms());
        }
    }

    private void removeFromAllChildren() {
        this.child.remove(this.getSeismograms());
    }

    public boolean borders(MicroSecondDate selectionBegin, MicroSecondDate selectionEnd) {
        double timeWidth = this.parent.getTimeConfig().getTime().getInterval().getValue();
        MicroSecondTimeRange currentInternal = this.latestTime.getTime();
        return (double)Math.abs(currentInternal.getEndTime().getMicroSecondTime() - selectionBegin.getMicroSecondTime()) / timeWidth < 0.03 || (double)Math.abs(currentInternal.getBeginTime().getMicroSecondTime() - selectionEnd.getMicroSecondTime()) / timeWidth < 0.03;
    }

    public void setParent(SeismogramDisplay parent) {
        this.parent = parent;
    }

    public SeismogramDisplay getParent() {
        return this.parent;
    }

    public void setChild(SeismogramDisplay child) {
        this.child = child;
    }

    public SeismogramDisplay getChild() {
        return this.child;
    }

    public void repaintParent() {
        this.parent.repaint();
    }

    public float getX(int width, TimeEvent currentExternalState) {
        MicroSecondTimeRange currentExternal = currentExternalState.getTime();
        float offset = (float)(this.latestTime.getTime().getBeginTime().getMicroSecondTime() - currentExternal.getBeginTime().getMicroSecondTime()) / (float)currentExternal.getInterval().getValue();
        return offset * (float)width;
    }

    public double getWidth(TimeEvent currentExternalState) {
        MicroSecondTimeRange currentInternal = this.latestTime.getTime();
        return (double)(currentInternal.getEndTime().getMicroSecondTime() - currentInternal.getBeginTime().getMicroSecondTime()) / currentExternalState.getTime().getInterval().getValue();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public DataSetSeismogram[] getSeismograms() {
        return this.seismos;
    }

    public void setTime(MicroSecondTimeRange selRange) {
        MicroSecondDate currentBegin = this.latestTime.getTime().getBeginTime();
        MicroSecondDate newBegin = selRange.getBeginTime();
        TimeInterval timeInt = (TimeInterval)this.latestTime.getTime().getInterval().convertTo(UnitImpl.MICROSECOND);
        TimeInterval newInt = selRange.getInterval();
        double currentInterval = timeInt.getValue();
        double shift = (double)(newBegin.getMicroSecondTime() - currentBegin.getMicroSecondTime()) / currentInterval;
        double scale = newInt.getValue() / currentInterval;
        this.tc.shaleTime(shift, scale);
    }

    public MicroSecondDate getBegin() {
        return this.latestTime.getTime().getBeginTime();
    }

    public void setBegin(MicroSecondDate newBegin) {
        if (this.latestTime.getTime().getEndTime().equals((Object)newBegin)) {
            throw new IllegalArgumentException("Selection must not have zero width, newBegin and end are the same.");
        }
        MicroSecondDate currentBegin = this.latestTime.getTime().getBeginTime();
        TimeInterval timeInt = (TimeInterval)this.latestTime.getTime().getInterval().convertTo(UnitImpl.MICROSECOND);
        double currentInterval = timeInt.getValue();
        double shift = (double)(newBegin.getMicroSecondTime() - currentBegin.getMicroSecondTime()) / currentInterval;
        double scale = (currentInterval + currentBegin.subtract(newBegin).getValue()) / currentInterval;
        this.tc.shaleTime(shift, scale);
    }

    public MicroSecondDate getEnd() {
        return this.latestTime.getTime().getEndTime();
    }

    public void setEnd(MicroSecondDate newEnd) {
        if (this.latestTime.getTime().getBeginTime().equals((Object)newEnd)) {
            throw new IllegalArgumentException("Selection must not have zero width, begin and newEnd are the same.");
        }
        MicroSecondDate currentEnd = this.latestTime.getTime().getEndTime();
        TimeInterval timeInt = (TimeInterval)this.latestTime.getTime().getInterval().convertTo(UnitImpl.MICROSECOND);
        double currentInterval = timeInt.getValue();
        double scale = (currentInterval + newEnd.subtract(currentEnd).getValue()) / currentInterval;
        this.tc.shaleTime(0.0, scale);
    }

    private void setInterval(TimeInterval newInterval) {
        double currentInterval = this.latestTime.getTime().getInterval().getValue();
        double scale = newInterval.getValue() / currentInterval;
        this.tc.shaleTime(0.0, scale);
    }

    public void setTimeConfig(TimeConfig config) {
        this.tc.removeListener(this);
        this.tc.remove(this.seismos);
        this.tc = config;
        this.tc.addListener(this);
        this.tc.add(this.seismos);
    }

    public TimeConfig getTimeConfig() {
        return this.tc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

