/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.drawable;

import edu.iris.Fissures.IfNetwork.Sensitivity;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.display.SeismogramContainer;
import edu.sc.seis.fissuresUtil.display.SeismogramContainerFactory;
import edu.sc.seis.fissuresUtil.display.SeismogramContainerListener;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramIterator;
import edu.sc.seis.fissuresUtil.display.drawable.SeismogramShapeIterator;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.apache.log4j.Logger;

public class SeismogramShape
implements Shape,
SeismogramContainerListener {
    private boolean newData = false;
    private SeismogramDisplay parent;
    private SeismogramShapeIterator currentIterator;
    private SeismogramContainer container;
    private static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$fissuresUtil$display$drawable$SeismogramShape == null ? (class$edu$sc$seis$fissuresUtil$display$drawable$SeismogramShape = SeismogramShape.class$("edu.sc.seis.fissuresUtil.display.drawable.SeismogramShape")) : class$edu$sc$seis$fissuresUtil$display$drawable$SeismogramShape));
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$display$drawable$SeismogramShape;

    public SeismogramShape(SeismogramDisplay parent, DataSetSeismogram seis) {
        this.parent = parent;
        this.container = SeismogramContainerFactory.create(seis);
        this.container.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateData() {
        SeismogramShape seismogramShape = this;
        synchronized (seismogramShape) {
            this.newData = true;
        }
        this.parent.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(MicroSecondTimeRange time, UnitRangeImpl amp, Dimension size) {
        if (this.container.getSeismograms().length <= 0) {
            return false;
        }
        SeismogramShape seismogramShape = this;
        synchronized (seismogramShape) {
            SeismogramShapeIterator newIterator = new SeismogramShapeIterator(time, amp, size);
            if (newIterator.isDraggedFrom(this.currentIterator) && newIterator.hasSimilarAmp(this.currentIterator) && !this.newData) {
                this.dragPlot(newIterator);
            } else {
                this.plot(newIterator);
            }
            return true;
        }
    }

    public String getDataStatus() {
        return this.container.getDataStatus();
    }

    public void getData() {
        this.container.getSeismograms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void plot(SeismogramShapeIterator iterator) {
        boolean plotNewData = false;
        SeismogramShape seismogramShape = this;
        synchronized (seismogramShape) {
            plotNewData = this.newData;
        }
        iterator.setSeisPoints(DisplayUtils.getPoints(this.container.getIterator(), iterator.getTime()));
        if (plotNewData) {
            seismogramShape = this;
            synchronized (seismogramShape) {
                this.newData = false;
            }
        }
        iterator.setBaseSeisPoint();
        iterator.setPointsPerPixel();
        iterator.setPoints(new int[2][iterator.getSize().width]);
        this.plotPixels(iterator);
        this.currentIterator = iterator;
    }

    private void dragPlot(SeismogramShapeIterator iterator) {
        iterator.copyBasicInfo(this.currentIterator);
        double shiftPercentage = SeismogramShape.getShiftPercentage(this.currentIterator.getTime(), iterator.getTime());
        double pixels = (double)this.currentIterator.getSize().width * shiftPercentage + this.currentIterator.getLeftoverPixels();
        pixels *= 1000.0;
        pixels = Math.round(pixels);
        pixels /= 1000.0;
        int shift = 0;
        if (pixels >= 1.0) {
            shift = (int)Math.floor(pixels);
            this.drag(shift, 0, iterator);
        } else if (pixels <= -1.0) {
            shift = (int)Math.ceil(pixels);
            this.drag(shift, -shift, iterator);
        } else {
            iterator.setSeisPoints(this.currentIterator.getSeisPoints());
            iterator.setDrawnPixels(this.currentIterator.getDrawnPixels());
            iterator.setTotalShift(this.currentIterator.getTotalShift());
        }
        iterator.setLeftoverPixels(pixels - (double)shift);
        this.currentIterator = iterator;
    }

    private void drag(int dragAmount, int dragFrom, SeismogramShapeIterator iterator) {
        int drawEnd;
        int drawStart;
        iterator.setTotalShift(this.currentIterator.getTotalShift() + dragAmount);
        double pointsPerPixel = iterator.getPointsPerPixel();
        int[] seisPoints = this.currentIterator.getSeisPoints();
        seisPoints[0] = (int)(-((double)iterator.getTotalShift() * pointsPerPixel)) + iterator.getBaseSeisPoint();
        seisPoints[1] = seisPoints[0] + (int)((double)iterator.getSize().width * pointsPerPixel);
        iterator.setSeisPoints(seisPoints);
        int[][] points = this.currentIterator.getPoints();
        int length = points[0].length - Math.abs(dragAmount);
        System.arraycopy(points[0], dragFrom, points[0], dragFrom + dragAmount, length);
        System.arraycopy(points[1], dragFrom, points[1], dragFrom + dragAmount, length);
        int[] drawnPixels = this.setPixels(iterator);
        if (pointsPerPixel <= 2.0) {
            this.plotPixels(drawnPixels[0], drawnPixels[1], iterator);
            return;
        }
        if (dragAmount < 0) {
            drawStart = drawnPixels[1] + dragAmount;
            drawEnd = drawnPixels[1];
        } else {
            drawStart = drawnPixels[0];
            drawEnd = dragAmount - 1;
        }
        this.plotPixels(drawStart, drawEnd, iterator);
    }

    private void plotPixels(SeismogramShapeIterator iterator) {
        int[] drawnPixels = this.setPixels(iterator);
        this.plotPixels(drawnPixels[0], drawnPixels[1], iterator);
    }

    private void plotPixels(int start, int end, SeismogramShapeIterator iterator) {
        if (start >= end || start < 0 || start == end) {
            return;
        }
        int[][] points = iterator.getPoints();
        double pointsPerPixel = iterator.getPointsPerPixel();
        UnitImpl lseisUnit = this.container.getIterator().getUnit();
        UnitRangeImpl ampRange = iterator.getAmp();
        ampRange = ampRange.convertTo(lseisUnit);
        double minAmp = ampRange.getMinValue();
        double maxAmp = ampRange.getMaxValue();
        double range = maxAmp - minAmp;
        int height = iterator.getSize().height;
        int totalShift = iterator.getTotalShift();
        for (int i = start; i < end; ++i) {
            double shift = (double)(i - totalShift) * pointsPerPixel;
            double unroundStartPoint = (double)iterator.getBaseSeisPoint() + shift;
            if (iterator.getPointsPerPixel() <= 2.0) {
                this.plotExpansion(unroundStartPoint, points, minAmp, range, height, i);
                continue;
            }
            this.plotCompression(unroundStartPoint, points, minAmp, range, height, i, pointsPerPixel);
        }
    }

    private void plotExpansion(double unroundStartPoint, int[][] points, double minAmp, double range, int height, int point) {
        double firstPoint;
        int endPoint;
        int startPoint = (int)Math.floor(unroundStartPoint);
        if (startPoint < 0 && startPoint >= -3) {
            startPoint = 0;
        }
        if ((endPoint = startPoint + 1) >= this.container.getIterator().getNumPoints()) {
            endPoint = this.container.getIterator().getNumPoints() - 1;
            startPoint = endPoint - 1;
        }
        if (startPoint < 0) {
            startPoint = 0;
            endPoint = 1;
        }
        double lastPoint = firstPoint = (double)(height / 2);
        firstPoint = this.container.getIterator().getValueAt(startPoint).getValue();
        lastPoint = this.container.getIterator().getValueAt(endPoint).getValue();
        double difference = unroundStartPoint - (double)startPoint;
        double value = firstPoint * (1.0 - difference) + lastPoint * difference;
        points[0][point] = this.container.getDataSetSeismogram().getAuxillaryDataKeys().contains("sensitivity") && ((Sensitivity)this.container.getDataSetSeismogram().getAuxillaryData((Object)"sensitivity")).sensitivity_factor < 0.0f ? (int)((value - minAmp) / range * (double)height) : height - (int)((value - minAmp) / range * (double)height);
        points[1][point] = points[0][point];
    }

    private void plotCompression(double unroundStartPoint, int[][] points, double minAmp, double range, int height, int point, double pointsPerPixel) {
        SeismogramIterator it;
        int startPoint = (int)Math.floor(unroundStartPoint);
        int endPoint = (int)Math.ceil(unroundStartPoint + pointsPerPixel);
        if (startPoint < 0) {
            startPoint = 0;
        }
        if (endPoint > (it = this.container.getIterator()).getNumPoints()) {
            endPoint = it.getNumPoints();
        }
        double[] minMax = it.minMaxMean(startPoint, endPoint);
        if (this.container.getDataSetSeismogram().getAuxillaryDataKeys().contains("sensitivity") && ((Sensitivity)this.container.getDataSetSeismogram().getAuxillaryData((Object)"sensitivity")).sensitivity_factor < 0.0f) {
            points[0][point] = (int)((minMax[0] - minAmp) / range * (double)height);
            points[1][point] = (int)((minMax[1] - minAmp) / range * (double)height);
        } else {
            points[0][point] = height - (int)((minMax[0] - minAmp) / range * (double)height);
            points[1][point] = height - (int)((minMax[1] - minAmp) / range * (double)height);
        }
    }

    private static double getShiftPercentage(MicroSecondTimeRange from, MicroSecondTimeRange to) {
        long fromBeginTime = from.getBeginTime().getMicroSecondTime();
        long toBeginTime = to.getBeginTime().getMicroSecondTime();
        double toInterval = to.getInterval().getValue();
        return (double)(fromBeginTime - toBeginTime) / toInterval;
    }

    private int[] setPixels(SeismogramShapeIterator iterator) {
        int[] displayPixels = new int[2];
        int[] seisPoints = iterator.getSeisPoints();
        double pointsPerPixel = iterator.getPointsPerPixel();
        int displayWidth = iterator.getSize().width;
        double seisPointRange = seisPoints[1] - seisPoints[0];
        if (seisPoints[1] < 0 || seisPoints[0] >= this.container.getIterator().getNumPoints()) {
            return SeismogramShape.setArrayToNegativeOne(displayPixels);
        }
        if (seisPoints[0] >= 0) {
            displayPixels[0] = 0;
        } else {
            displayPixels[0] = (int)Math.round((double)(-seisPoints[0]) / pointsPerPixel);
            if (displayPixels[0] == displayWidth) {
                return SeismogramShape.setArrayToNegativeOne(displayPixels);
            }
        }
        displayPixels[1] = seisPoints[1] < this.container.getIterator().getNumPoints() ? displayWidth - 1 : (int)Math.round((double)(this.container.getIterator().getNumPoints() - seisPoints[0]) / seisPointRange * (double)displayWidth);
        iterator.setDrawnPixels(displayPixels);
        return displayPixels;
    }

    private static int[] setArrayToNegativeOne(int[] setee) {
        setee[0] = -1;
        setee[1] = -1;
        return setee;
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return this.getPathIterator(at, 0.0);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        this.currentIterator.setAT(at);
        return this.currentIterator;
    }

    public boolean intersects(double x, double y, double w, double h) {
        return false;
    }

    public boolean intersects(Rectangle2D r) {
        return false;
    }

    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    public boolean contains(Rectangle2D r) {
        return false;
    }

    public boolean contains(double x, double y) {
        return false;
    }

    public boolean contains(Point2D p) {
        return false;
    }

    public Rectangle getBounds() {
        return null;
    }

    public Rectangle2D getBounds2D() {
        return null;
    }

    public DataSetSeismogram getSeismogram() {
        return this.container.getDataSetSeismogram();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

