/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.drawable;

import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.PlottableDisplay;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class PlottableSelection {
    private Rectangle2D extractLocation;
    private static AlphaComposite OPAQUE = AlphaComposite.getInstance(3, 1.0f);
    private static AlphaComposite TRANSPARENT = AlphaComposite.getInstance(3, 0.4f);
    private Color color = Color.RED;
    private PlottableDisplay display;
    private int startRowX;
    private int endRowX;
    private int startRow = -1;
    private int endRow = -1;
    private boolean visible = false;
    private Color extractColor = Color.BLACK;
    private boolean placed;

    public PlottableSelection(PlottableDisplay display) {
        this.display = display;
    }

    public PlottableSelection(PlottableDisplay display, int x, int y) {
        this(display);
        this.setXY(x, y, 10);
    }

    public void draw(Graphics g) {
        if (this.visible) {
            Graphics2D newG = (Graphics2D)g.create();
            int rowHeight = this.display.getRowOffset();
            int yOffset = this.display.titleHeight;
            int xOffset = 50;
            for (int currRow = this.startRow; currRow <= this.endRow; ++currRow) {
                int x = xOffset;
                int width = this.display.getRowWidth();
                int y = rowHeight * currRow + yOffset - rowHeight / 2 + 5;
                int height = rowHeight - 10;
                if (currRow == this.startRow) {
                    x = this.startRowX;
                    width -= x - xOffset;
                }
                if (currRow == this.endRow) {
                    width = this.endRowX - x;
                }
                newG.setPaint(this.color);
                newG.setComposite(TRANSPARENT);
                newG.fillRect(x, y, width, height);
                newG.setComposite(OPAQUE);
                newG.setStroke(DisplayUtils.TWO_PIXEL_STROKE);
                newG.drawRect(x, y, width, height);
                if (currRow != this.startRow) continue;
                newG.setFont(DisplayUtils.BIG_BOLD_FONT);
                FontMetrics fm = newG.getFontMetrics();
                Rectangle2D bounds = fm.getStringBounds("Extract", newG);
                this.extractLocation = bounds;
                this.extractLocation.setRect((x -= 3) - 2, (double)(y += 3 + height) - bounds.getHeight() + 5.0, bounds.getWidth() + 4.0, bounds.getHeight() + 2.0);
                newG.setColor(Color.WHITE);
                newG.fill(this.extractLocation);
                newG.setColor(this.extractColor);
                newG.drawString("Extract", x, y);
                newG.draw(this.extractLocation);
            }
            newG.dispose();
        }
    }

    public boolean intersectsExtract(int x, int y) {
        return this.extractLocation != null && this.extractLocation.contains(x, y);
    }

    private int[] getSelectedRows(int beginy, int endy) {
        if (beginy == -1 || endy == -1) {
            return new int[0];
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int selectionOffset = this.display.getRowOffset() / 2;
        for (int counter = 0; counter < this.display.getRows(); ++counter) {
            int value = this.display.getRowOffset() / 2 + this.display.titleHeight + this.display.getRowOffset() * counter;
            if (beginy > value + selectionOffset || endy <= value - selectionOffset) continue;
            arrayList.add(new Integer(counter));
        }
        int[] rtnValues = new int[arrayList.size()];
        for (int counter = 0; counter < arrayList.size(); ++counter) {
            rtnValues[counter] = (Integer)arrayList.get(counter);
        }
        return rtnValues;
    }

    public int getRow(int yPixel) {
        int rowHeight = this.display.getRowOffset();
        if (yPixel - this.display.titleHeight + rowHeight / 2 < 0) {
            return -1;
        }
        for (int counter = 1; counter <= this.display.getRows(); ++counter) {
            int value = this.display.titleHeight + rowHeight * counter - rowHeight / 2;
            if (yPixel > value) continue;
            return counter - 1;
        }
        return -1;
    }

    public RequestFilter getRequestFilter() {
        if (!this.visible) {
            return null;
        }
        if (this.endRow == -1) {
            return null;
        }
        int rows = this.display.getRows();
        double rowWidth = this.display.getRowWidth();
        int offset = 50;
        double beginPercentage = ((double)(this.startRowX - offset) / rowWidth + (double)this.startRow) / (double)rows;
        double endPercentage = ((double)(this.endRowX - offset) / rowWidth + (double)this.endRow) / (double)rows;
        return new RequestFilter(this.display.getChannelId(), this.getTime(beginPercentage).getFissuresTime(), this.getTime(endPercentage).getFissuresTime());
    }

    private MicroSecondDate getTime(double percentageOfPlottable) {
        Date startTime = this.display.getDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startTime);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(11, 0);
        calendar.set(12, 0);
        startTime = calendar.getTime();
        long milliSecondsPast = (long)(percentageOfPlottable * (double)(this.display.getTotalHours() * 60 * 60 * 1000));
        return new MicroSecondDate(new Date(startTime.getTime() + milliSecondsPast));
    }

    public int[][] getSelectedArea() {
        int[][] selectedArea = new int[this.endRow - this.startRow + 1][3];
        if (this.visible && this.endRow != -1) {
            for (int i = 0; i < selectedArea.length; ++i) {
                selectedArea[i][0] = this.startRow + i;
                selectedArea[i][1] = selectedArea[i][0] == this.startRow ? this.startRowX : 0;
                selectedArea[i][2] = selectedArea[i][0] == this.endRow ? this.endRowX : this.display.getRowWidth();
            }
        }
        return selectedArea;
    }

    public void addXY(int x, int y) {
        this.setExtractColor(Color.BLACK);
        if (x < 50 || x > this.display.getRowWidth() + 50) {
            return;
        }
        int row = this.getRow(y);
        if (row > -1 && row < this.display.getRows()) {
            int xToStart = Math.abs(x - this.startRowX);
            int xToEnd = Math.abs(x - this.endRowX);
            int rowsToStart = Math.abs(row - this.startRow);
            int rowsToEnd = Math.abs(row - this.endRow);
            if (this.startRow == this.endRow) {
                if (row == this.startRow) {
                    if (xToStart < xToEnd) {
                        this.setStart(x, row);
                    } else {
                        this.setEnd(x, row);
                    }
                } else if (row < this.startRow) {
                    if (xToStart > xToEnd) {
                        this.setEnd(this.startRowX, this.startRow);
                    }
                    this.setStart(x, row);
                } else {
                    if (xToStart < xToEnd) {
                        this.setStart(this.endRowX, this.endRow);
                    }
                    this.setEnd(x, row);
                }
            } else if (this.endRow - this.startRow > 1) {
                if (rowsToStart < rowsToEnd) {
                    this.setStart(x, row);
                } else {
                    this.setEnd(x, row);
                }
            } else if (row < this.startRow) {
                this.setStart(x, row);
            } else if (row > this.endRow) {
                this.setEnd(x, row);
            } else if (row == this.startRow && xToStart <= xToEnd + 3) {
                this.setStart(x, row);
            } else if (row == this.endRow && xToEnd <= xToStart + 3) {
                this.setEnd(x, row);
            } else if (row == this.startRow) {
                if (x < this.startRowX) {
                    this.setEnd(this.startRowX, this.startRow);
                    this.setStart(x, row);
                } else {
                    this.setEnd(x, row);
                }
            } else if (x > this.endRowX) {
                this.setStart(this.endRowX, this.endRow);
                this.setEnd(x, row);
            } else {
                this.setStart(x, row);
            }
        }
        this.placed = true;
    }

    private void setStart(int x, int row) {
        this.startRowX = x;
        this.startRow = row;
    }

    private void setEnd(int x, int row) {
        this.endRowX = x;
        this.endRow = row;
    }

    public void set(int[][] rowX) {
        this.visible = true;
        this.setStart(rowX[0][1], rowX[0][0]);
        this.setEnd(rowX[1][1], rowX[1][0]);
    }

    public void setXY(int x, int y, int width) {
        if (x < 50 || x > this.display.getRowWidth() + 50) {
            if (!this.placed) {
                this.visible = false;
            }
            return;
        }
        if (this.placed) {
            if (this.intersectsExtract(x, y)) {
                this.setExtractColor(Color.RED);
            } else {
                this.setExtractColor(Color.BLACK);
            }
            return;
        }
        int row = this.getRow(y);
        if (row < 0) {
            if (!this.placed) {
                this.visible = false;
            }
            return;
        }
        this.visible = true;
        this.startRow = this.endRow = row;
        this.startRowX = x - width / 2;
        this.endRowX = x + width / 2;
    }

    public void setExtractColor(Color newColor) {
        this.extractColor = newColor;
        this.display.repaint();
    }

    public boolean borders(int x, int y) {
        int row = this.getRow(y);
        return row == this.startRow && Math.abs(x - this.startRowX) < 3 || row == this.endRow && Math.abs(x - this.endRowX) < 3;
    }

    public void setPlaced(boolean isPlaced) {
        this.placed = isPlaced;
    }
}

